function[OutFilePath]=MergeTTxConAvgFiles(Subj,Scan,Session,CondMat)

%	MergeTTxConAvgFiles.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  

if nargin<4; CondMat=[]; end
if nargin<3; fprintf(1,'[OutFilePath]=MergeTTxConAvgFiles(Subj,Scan,Session)'); return; end
%===============================================================
if isempty(CondMat); CondMat=[1 2;3 4;3 4]; end
fprintf('\n\n');
%'no weighting                [1]
%'trial number weighting      [2]
%'Std matrix weighting        [3]

chWeight=2;
SubjStr=int2str(Subj);
if Subj<9
    SubjStr=['0',SubjStr];
end
PathTmp=['/export/jesse/data3/TTx/TTx',SubjStr,filesep,'Scan',int2str(Scan),filesep,'Session',int2str(Session)]
NMerge=size(CondMat,1)
for MergeInd=1:NMerge

CondVec=CondMat(MergeInd,:)
CondVec=CondVec(find(CondVec))
NCond=length(CondVec)
CondStr=int2str(CondVec(1));
for CondInd=2:NCond
    CondStr=[CondStr,',',int2str(CondVec(CondInd))];
end
CondStr=CondStr
for RunIndex=1:1
    RunPath=[PathTmp,filesep,'Run',int2str(RunIndex)]
    GMFilePath=[RunPath,filesep,'GM.w2.',SubjStr,'.',int2str(Scan),'.',int2str(Session),'.',int2str(RunIndex),'.f.msi.at',CondStr]
    for CondInd=1:NCond
        CondIndex=CondVec(CondInd)
        Path=[PathTmp,filesep,'Run',int2str(RunIndex)]
        File=['TTx',SubjStr,'.',int2str(Scan),'.',int2str(Session),'.',int2str(RunIndex),'.f.msi.at',int2str(CondIndex)]    
        FilePath=[Path,filesep,File]
        [AvgMat,File,Path,FilePath,NTrialAvgVec,StdMat,SampRate,AvgRef,Version,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra]=ReadAvgFile(FilePath);
	    if CondIndex==1; 
		    [NChan,NPoints]=size(AvgMat);
		    if chWeight==1
			    MergeAvgMat=AvgMat;
		    elseif chWeight==2
			    MaxNumberOfTrials=max(NTrialAvgVec);
			    TotMaxNumberOfTrials=MaxNumberOfTrials;
			    MergeAvgMat=MaxNumberOfTrials.*AvgMat;
		    elseif chWeight==3
			    MergeAvgMat=AvgMat./StdMat; 
			    InvMergeStdMat=1./StdMat;
		    end
		    MergeStdMat=StdMat; 
		    MergeNTrialAvgVec=NTrialAvgVec;
		    MergeMedMedRawVec=MedMedRawVec;
		    MergeMedMedAvgVec=MedMedAvgVec;
	    else
		    if chWeight==1
			    MergeAvgMat=MergeAvgMat+AvgMat;
		    elseif chWeight==2
			    MaxNumberOfTrials=max(NTrialAvgVec);
			    TotMaxNumberOfTrials=TotMaxNumberOfTrials+MaxNumberOfTrials;
			    MergeAvgMat=MergeAvgMat+MaxNumberOfTrials.*AvgMat;
		    elseif chWeight==3
			    MergeAvgMat=MergeAvgMat+AvgMat./StdMat;
			    InvMergeStdMat=InvMergeStdMat+1./StdMat;
		    end
		    MergeStdMat=MergeStdMat+StdMat;
		    %============Falls MergeNTrialAvgVec=NTrialAvgVec'=============
		    SizeMergeNTrialAvgVec=size(MergeNTrialAvgVec);
		    SizeNTrialAvgVec=size(NTrialAvgVec);
		    if SizeMergeNTrialAvgVec(2)==SizeNTrialAvgVec(1); NTrialAvgVec=NTrialAvgVec'; end
		%==============================================================

		    NMergeMedMedRawVec=length(MergeMedMedRawVec);
		    NMedMedRawVec=length(MedMedRawVec);
		    NTmpMedMedRaw=NMergeMedMedRawVec+NMedMedRawVec;
		    TmpMedMedRaw=zeros(NTmpMedMedRaw,1);
		    TmpMedMedRaw(1:NMergeMedMedRawVec)=MergeMedMedRawVec;
		    TmpMedMedRaw(NMergeMedMedRawVec+1:NTmpMedMedRaw)=MedMedRawVec;
		    MergeMedMedRawVec=TmpMedMedRaw;

		    NMergeMedMedAvgVec=length(MergeMedMedAvgVec);
		    NMedMedAvgVec=length(MedMedAvgVec);
		    NTmpMedMedAvg=NMergeMedMedAvgVec+NMedMedAvgVec;
		    TmpMedMedAvg=zeros(NTmpMedMedAvg,1);
		    TmpMedMedAvg(1:NMergeMedMedAvgVec)=MergeMedMedAvgVec;
		    TmpMedMedAvg(NMergeMedMedAvgVec+1:NTmpMedMedAvg)=MedMedAvgVec;
		    MergeMedMedAvgVec=TmpMedMedAvg;
	    end
    end

    if chWeight==1
	    MergeAvgMat=MergeAvgMat./NCond;
    elseif chWeight==2
	    MergeAvgMat=MergeAvgMat./TotMaxNumberOfTrials;
    elseif chWeight==3
	    MergeAvgMat=MergeAvgMat./InvMergeStdMat;
    end
    MergeStdMat=MergeStdMat./NCond;
    MergeMedMedRawVec=MergeMedMedRawVec./NCond;
    MergeMedMedAvgVec=MergeMedMedAvgVec./NCond;
    SaveAvgFile(GMFilePath,MergeAvgMat,MergeNTrialAvgVec,MergeStdMat,SampRate,MergeMedMedRawVec,MergeMedMedAvgVec,EegMegStatus,NChanExtra);
end
end
return;
