function[OutFilePath]=MergeTTxRunAvgFiles(Subj,Scan,Session)

%	MergeTTxRunAvgFiles.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  

if nargin<1; fprintf(1,'[OutFilePath]=MergeTTxAvgFiles(Subj,Scan,Session)'); return; end
%===============================================================

fprintf('\n\n');
%'no weighting                [1]
%'trial number weighting      [2]
%'Std matrix weighting        [3]

chWeight=2;
SubjStr=int2str(Subj);
if Subj<9
    SubjStr=['0',SubjStr];
end
RunVec=1:2:6
PathTmp=['/export/jesse/data3/TTx/TTx',SubjStr,filesep,'Scan',int2str(Scan),filesep,'Session',int2str(Session)]
SubDir=['GMRun'];
[MkDirStatus,MkDirMessage]=mkdir(PathTmp,SubDir);
fprintf(1,'\n\n');
fprintf(1,MkDirMessage);
for CondIndex=1:8
    GMFilePath=[PathTmp,filesep,SubDir,filesep,'GM.w2.',SubjStr,'.',int2str(Scan),'.',int2str(Session),'.',int2str(CondIndex),'.f.msi.at',int2str(CondIndex)]
    for RunInd=1:length(RunVec)
        RunIndex=RunVec(RunInd)
        Path=[PathTmp,filesep,'Run',int2str(RunIndex)]
        File=[SubjStr,'.',int2str(Scan),'.',int2str(Session),'.',int2str(RunIndex),'.f.ses.msi.at',int2str(CondIndex)]    
        FilePath=[Path,filesep,File]
        [AvgMat,File,Path,FilePath,NTrialAvgVec,StdMat,SampRate,AvgRef,Version,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra]=ReadAvgFile(FilePath);
	    if RunIndex==1; 
		    [NChan,NPoints]=size(AvgMat);
		    if chWeight==1
			    MergeAvgMat=AvgMat;
		    elseif chWeight==2
			    MaxNumberOfTrials=max(NTrialAvgVec);
			    TotMaxNumberOfTrials=MaxNumberOfTrials;
			    MergeAvgMat=MaxNumberOfTrials.*AvgMat;
		    elseif chWeight==3
			    MergeAvgMat=AvgMat./StdMat; 
			    InvMergeStdMat=1./StdMat;
		    end
		    MergeStdMat=StdMat; 
		    MergeNTrialAvgVec=NTrialAvgVec;
		    MergeMedMedRawVec=MedMedRawVec;
		    MergeMedMedAvgVec=MedMedAvgVec;
	    else
		    if chWeight==1
			    MergeAvgMat=MergeAvgMat+AvgMat;
		    elseif chWeight==2
			    MaxNumberOfTrials=max(NTrialAvgVec);
			    TotMaxNumberOfTrials=TotMaxNumberOfTrials+MaxNumberOfTrials;
			    MergeAvgMat=MergeAvgMat+MaxNumberOfTrials.*AvgMat;
		    elseif chWeight==3
			    MergeAvgMat=MergeAvgMat+AvgMat./StdMat;
			    InvMergeStdMat=InvMergeStdMat+1./StdMat;
		    end
		    MergeStdMat=MergeStdMat+StdMat;
		    %============Falls MergeNTrialAvgVec=NTrialAvgVec'=============
		    SizeMergeNTrialAvgVec=size(MergeNTrialAvgVec);
		    SizeNTrialAvgVec=size(NTrialAvgVec);
		    if SizeMergeNTrialAvgVec(2)==SizeNTrialAvgVec(1); NTrialAvgVec=NTrialAvgVec'; end
		%==============================================================

		    NMergeMedMedRawVec=length(MergeMedMedRawVec);
		    NMedMedRawVec=length(MedMedRawVec);
		    NTmpMedMedRaw=NMergeMedMedRawVec+NMedMedRawVec;
		    TmpMedMedRaw=zeros(NTmpMedMedRaw,1);
		    TmpMedMedRaw(1:NMergeMedMedRawVec)=MergeMedMedRawVec;
		    TmpMedMedRaw(NMergeMedMedRawVec+1:NTmpMedMedRaw)=MedMedRawVec;
		    MergeMedMedRawVec=TmpMedMedRaw;

		    NMergeMedMedAvgVec=length(MergeMedMedAvgVec);
		    NMedMedAvgVec=length(MedMedAvgVec);
		    NTmpMedMedAvg=NMergeMedMedAvgVec+NMedMedAvgVec;
		    TmpMedMedAvg=zeros(NTmpMedMedAvg,1);
		    TmpMedMedAvg(1:NMergeMedMedAvgVec)=MergeMedMedAvgVec;
		    TmpMedMedAvg(NMergeMedMedAvgVec+1:NTmpMedMedAvg)=MedMedAvgVec;
		    MergeMedMedAvgVec=TmpMedMedAvg;
	    end
    end

    if chWeight==1
	    MergeAvgMat=MergeAvgMat./NRun;
    elseif chWeight==2
	    MergeAvgMat=MergeAvgMat./TotMaxNumberOfTrials;
    elseif chWeight==3
	    MergeAvgMat=MergeAvgMat./InvMergeStdMat;
    end
    MergeStdMat=MergeStdMat./NRun;
    MergeMedMedRawVec=MergeMedMedRawVec./NRun;
    MergeMedMedAvgVec=MergeMedMedAvgVec./NRun;
    SaveAvgFile(GMFilePath,MergeAvgMat,MergeNTrialAvgVec,MergeStdMat,SampRate,MergeMedMedRawVec,MergeMedMedAvgVec,EegMegStatus,NChanExtra);
end
return;
