function[NM1RawFileMat]=NRaw2NM1Raw(NRawFileMat,MaxMemory);

%   NRaw2NM1Raw

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<2; MaxMemory=20; end;
if nargin<1; NRawFileMat=[]; end;

DefDataFilePath=SetDefPath('r','.RAW',[],0);
[NFiles,NRawFileMat,NonUse,BatchFilePath]=ReadFileNames(NRawFileMat,DefDataFilePath,'Choose a NetStation RAW file:');
SetDefPath('w',BatchFilePath,[],0);
NM1RawFileMat=[];

for FileIndex=1:NFiles
    [NRawFile,NRawPath,NRawFilePath]=GetFileNameOfMat(NRawFileMat,FileIndex);
    if NRawFile==0; return; end;
    NM1RawFilePath=[NRawFilePath,'.tmp'];
    [NM1RawFileMat,NFileMatOut,MatlabVersionString]=AddFileName2Mat(NM1RawFileMat,NM1RawFilePath,1);
    
    NRawFid=fopen(NRawFilePath,'r','b');
    NM1RawFid=fopen(NM1RawFilePath,'w','b');
    
    Version=fread(NRawFid,1,'long');
    Year=fread(NRawFid,1,'short');
    Month=fread(NRawFid,1,'short');
    Day=fread(NRawFid,1,'short');
    Hour=fread(NRawFid,1,'short');
    Minute=fread(NRawFid,1,'short');
    Sec=fread(NRawFid,1,'short');
    MSec=fread(NRawFid,1,'long');
    SampRate=fread(NRawFid,1,'short');
    NChan=fread(NRawFid,1,'short');
    Gain=fread(NRawFid,1,'short');
    Bits=fread(NRawFid,1,'short');
    Range=fread(NRawFid,1,'short');
    NPoints=fread(NRawFid,1,'long');
    NEvents=fread(NRawFid,1,'short');
    EventCodes=fread(NRawFid,[NEvents,4],'char');
    LHeader=ftell(NRawFid);
    
    CountVersion=fwrite(NM1RawFid,Version,'long');
    CountYear=fwrite(NM1RawFid,Year,'short');
    CountMonth=fwrite(NM1RawFid,Month,'short');
    CountDay=fwrite(NM1RawFid,Day,'short');
    CountHour=fwrite(NM1RawFid,Hour,'short');
    CountMinute=fwrite(NM1RawFid,Minute,'short');
    CountSec=fwrite(NM1RawFid,Sec,'short');
    CountMSec=fwrite(NM1RawFid,MSec,'long');
    CountSampRate=fwrite(NM1RawFid,SampRate,'short');
    CountNChan=fwrite(NM1RawFid,NChan-1,'short');
    CountGain=fwrite(NM1RawFid,Gain,'short');
    CountBits=fwrite(NM1RawFid,Bits,'short');
    CountRange=fwrite(NM1RawFid,Range,'short');
    CountNPoints=fwrite(NM1RawFid,NPoints,'long');
    CountNEvents=fwrite(NM1RawFid,NEvents,'short');
    CountEventCodes=fwrite(NM1RawFid,EventCodes,'char');
    
    NTotChan=NChan+NEvents;
    if NEvents>0
        NChanVec=[1:NChan-1,NChan+1:NTotChan];
    else
        NChanVec=[1:NChan-1];
    end
    MaxSizePoints=floor(MaxMemory.*1000000./(NTotChan.*8));
    NLoops=max([1,floor((NPoints./MaxSizePoints))]);
    RestPoints=NPoints-NLoops.*MaxSizePoints;
    if NLoops==1
        DataMat=fread(NRawFid,[NTotChan,NPoints],'int16');
        fwrite(NM1RawFid,DataMat(NChanVec,:),'int16');
    else
        for LoopInd=1:NLoops
            fprintf('\n'); clc;
            fprintf(1,'%g of %g total loops done !',LoopInd+NLoops,2.*NLoops);
            DataMat=fread(NRawFid,[NTotChan,MaxSizePoints],'int16');
            fwrite(NM1RawFid,DataMat(NChanVec,:),'int16');
        end
        if RestPoints>0
            DataMat=fread(NRawFid,[NTotChan,RestPoints],'int16');
            fwrite(NM1RawFid,DataMat(NChanVec,:),'int16');
        end
    end
    fclose(NRawFid);
    fclose(NM1RawFid);
    delete(NRawFilePath);
    mvers = version;
    mvers = mvers(3);
    if mvers==1
        [Success,Message]=copyfile(NM1RawFilePath,NRawFilePath);
    else mvers==5
        [Success,Message,MessageId]=copyfile(NM1RawFilePath,NRawFilePath);
    end
    if ~Success
        Message=char(' ');
		Message=char(Message,'Problems copying file:');
		fprintf(1,'Problems copying file from source:\n\n');
	    Message=char(Message,' ');
	    Message=char(Message,NM1RawFilePath);
	    Message=char(Message,'');
	    Message=char(Message,'to destination:');
        Message=char(Message,' ');
	    Message=char(Message,NRawFilePath);
        Message=char(Message,' ');
        Message=char(Message,'Error message:');
        Message=char(Message,' ');
        Message=char(Message,Message);
        Message=char(Message,'Error message Id:');
        Message=char(Message,' ');
        Message=char(Message,MessageId);
        Message=char(Message,' ');
        pause
    end
    delete(NM1RawFilePath);
end
return;