function[FilterFileMat]=PlotNetFFT(NetFileMat,TRStatus,MaxMemory);


%	PlotNetFFT

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  

if nargin<3; MaxMemory=50; end
if nargin<2; TRStatus=-1; end
if nargin<1; NetFileMat=[]; end


fprintf('\n');clc;
[TRStatus]=IfEmptyInputSpecVal(TRStatus,[-1 1],1,...
'Please insert the file status:\n',...
'RAW                   [ 1]',...
'TAW                   [-1]');

if TRStatus==1; Mask='*.RAW'; Ext='.RAW'; elseif TRStatus==-1; Mask='*.TAW'; Ext='.TAW'; end

[NNetFiles,NetFileMat]=ReadFileNames(NetFileMat,Mask,'Choose NetStation file:');
if NNetFiles==0; return; end


%========================================================================================================

for FileIndex=1:NNetFiles
	
	[NetFile,NetPath,NetFilePath]=GetFileNameOfMat(NetFileMat,FileIndex);
	

	%=========NetStation Header===============

	[FilePath,NetHeader,LNetHeader,Version, ...
	Year, Month, Day, Hour, Minute, Sec, MSec, ...
	SampRate, NChan, NGain, Bits, Range, NPoints, NEvents, EventCodes]= ...
	ReadRAWHeader(NetFilePath);
	NTotChan=NChan+NEvents;
	
	%==================================================================
	NetFid=fopen(NetFilePath,'r');
	fseek(NetFid,LNetHeader,-1);
	
	if TRStatus==1 %RAW
		MaxNPointToRead=floor(MaxMemory.*1000000./(8.*NTotChan));
		if MaxNPointToRead>=NPoints; 
			ReadAllStatus=1; 
			DataMat=fread(NetFid,[NTotChan,NPoints],'int16');	
		else; 
			ReadAllStatus=0; 
		end
	end
	global ChanVec
	NPoints=NPoints
	NFFT=2^17
	FrequVec=linspace(0,250,NFFT./2+1);
	[TestVal,TestInd]=min(abs(FrequVec-1.3021));
	[TestVal10,TestInd10]=min(abs(FrequVec-10))
	Mat=zeros(NTotChan,TestInd10);
	for ChanIndex=1:NTotChan
		ChanIndex=ChanIndex
		if TRStatus==1 %RAW
			if ReadAllStatus
				DataVec=(DataMat(ChanIndex,:))';
			else
				fseek(NetFid,LNetHeader+(ChanIndex-1).*2,-1);
				DataVec=zeros(NPoints,1);
				for TimeInd=1:NPoints-1
					DataVec(TimeInd)=fread(NetFid,1,'int16');
					fseek(NetFid,(NTotChan-1).*2,0);
				end
			end
		elseif TRStatus==-1  %TAW
			DataVec=fread(NetFid,NPoints,'int16');	
		end
		TmpVec=DataVec(1:NFFT);
		TmpVec=TmpVec-ones(NFFT,1).*mean(TmpVec);
		FFTDataVec=fft(TmpVec);
		PFFTDataVec=abs(FFTDataVec.*conj(FFTDataVec))./NPoints;
% 		plot(FrequVec,PFFTDataVec(1:NFFT./2+1))
% 		hold on
% 		plot([1.3021 1.3021],[0 10000000],'-r')
% 		axis([0 60 0 5000000])
% 		hold off
		Mat(ChanIndex,:)=PFFTDataVec(1:TestInd10)';
% 		pause(1)
	end
	fclose(NetFid);
end
SaveData(Mat,'AlData:MovieIAPS:Test2',1)
return;
		
