function[varargout]=PrePro(action,varargin)

%   PrePro - opens a user interface, that offers batch functions
%   to segment continuous data based on trigger events, to filter
%   data and to calculate statistical parameters that can be used
%   for artifact detection.
%   
%   See also EMEGS, FILTERNETFILE, TRANSRAWTAW, TRANSNETGEOHIST,
%   NEUROSCAN2EGIS, FILTNEUROSCANFILES, CALCAUTOEDITMAT, EDITAEM, FINDBADCHAN,
%   FINDBADCHANTRIAL.

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  


if nargin<2; FileMat=[]; end
if nargin<1; action='InitializeMenu'; end

%================= global variables =============================================
global hPreProMenuFig


%============================================================================
%=========== INITIALIZE MENU ================================================
%============================================================================
if strcmp(action,'InitializeMenu'),
	

	
	%============== figure with graphs =========================		
	if strcmp(computer,'MAC2')	
       	PreProMenuFigVec=[.8 0 .2 1];
	elseif strcmp(computer,'PCWIN') 
       	PreProMenuFigVec=[.78 .05 .2 .92];
	else
       	PreProMenuFigVec=[.8 .01 .2 .91];
	end
	%============== figure with menu ===========================
    set(0,'DefaultFigureCreateFcn','preproopenmenu;');
    PreProMenuFigString=['Preprocessing Menu:'];
	CloseRequestFcnStr='PrePro(''ClosePreProMenuFig'')';
   	hPreProMenuFig=figure('Units','normalized',...
        'Position',PreProMenuFigVec,...
        'Name',PreProMenuFigString,...
        'Color',[.99 .99 .99],...
        'NumberTitle','off',...
        'CloseRequestFcn',CloseRequestFcnStr,...
        'MenuBar','none',...
        'tag','PreProMenuFig');
	
    set(0,'DefaultFigureCreateFcn','');
	% Information for all buttons (and menus)
	labelColor=[0.8 0.8 0.8];
	yInitPos=0.90;
    frametop = 0.955;
	menutop=0.935;
	btnTop = 0.6;
	top=0.75;
	left=0.1;
	btnWid=0.8;
	btnHt=0.04;
	btnHth=0.02;
	btnHt_edit=0.050;
	textHeight = 0.05;			% not used !!!!!!!!!!!
	textWidth = 0.06;
    DefColor = [0.9137254901960784 0.9137254901960784 0.8470588235294118];
	% Spacing between the button and the next command's label
	spacing=0.015;
	%====================================
	%====================================
	% The CONSOLE frames
	%====================================
	%====================================
	frmBorder=0.05; 
	frmLeft=left - frmBorder;
	frmBottom=0.010; 
	frmHeight = 0.489-3.*frmBottom; 
	frmWidth = 1- 0.1;
	yPos=frmBottom-frmBorder;
	ConsoleRGBColor=[0.9 0.9 0];
	%====================================
    %bottom whole width frame
	%====================================
	frmPos=[frmLeft frmBottom frmWidth frmHeight-0.01];
	uicontrol( ...
	'Style','frame', ...
	'Units','normalized', ...
    'ForegroundColor',ConsoleRGBColor,...
	'Position',frmPos, ...
	'BackgroundColor',ConsoleRGBColor);
	%====================================
    %top right edge frame
	%====================================
	frmPos=[left+ 4.7*frmBorder,frmBottom+frmHeight-0.01,btnWid-frmBorder*3.7,0.507+0.0255];
	uicontrol( ...
	'Style','frame', ...
	'Units','normalized', ...
    'ForegroundColor',ConsoleRGBColor,...
	'Position',frmPos, ...
	'BackgroundColor',ConsoleRGBColor);
	%====================================
    %top left edge frame
	%====================================
    frmPos=[frmLeft, frmBottom+frmHeight-2*(btnHth+spacing)+0.06, 0.05, 0.507+0.024];
	uicontrol( ...
	'Style','frame', ...
	'Units','normalized', ...
    'ForegroundColor',ConsoleRGBColor,...
	'Position',frmPos, ...
	'BackgroundColor',ConsoleRGBColor);
    frmPos=[frmLeft, frmBottom+frmHeight-0.3*(btnHth+spacing), btnWid-frmBorder*4 , 0.088];
	uicontrol( ...
	'Style','frame', ...
	'Units','normalized', ...
    'ForegroundColor',ConsoleRGBColor,...
	'Position',frmPos, ...
	'BackgroundColor',ConsoleRGBColor);
    frmPos=[left - frmBorder,frmBottom+2.064*frmHeight-2*(btnHth+spacing ),btnWid-frmBorder*4 ,0.073+0.90*(btnHth+spacing) ];
	uicontrol( ...
	'Style','frame', ...
	'Units','normalized', ...
    'ForegroundColor',ConsoleRGBColor,...
	'Position',frmPos, ...
	'BackgroundColor',ConsoleRGBColor);
    frmPos=[left - frmBorder,frmBottom+1.771*frmHeight-2*(btnHth+spacing),btnWid-frmBorder*4 ,0.048];
	uicontrol( ...
	'Style','frame', ...
	'Units','normalized', ...
    'ForegroundColor',ConsoleRGBColor,...
	'Position',frmPos, ...
	'BackgroundColor',ConsoleRGBColor);
    frmPos=[left - frmBorder,frmBottom+1.446*frmHeight-2*(btnHth+spacing),btnWid-frmBorder*4 ,0.055];
	uicontrol( ...
	'Style','frame', ...
	'Units','normalized', ...
    'ForegroundColor',ConsoleRGBColor,...
	'Position',frmPos, ...
	'BackgroundColor',ConsoleRGBColor);

	%==============================================================
	% OpenRawFiles button           =============================
	%==============================================================
	btnNumber=0.2;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos=[left yPos-btnHt btnWid./3.2 3*btnHt/3];
	callbackStr = 'PrePro(''OpenFileMatrix'')';
    tooltipstring = '';
	hOpenRawFilesButton=uicontrol( ...
	'Style','pushbutton', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
	'String','open file(s) ', ...
	'Userdata',[], ...
    'ToolTipString',tooltipstring,...
	'Callback',callbackStr,...
	'Enable','on',...
    'visible','on');

	%==============================================================
	% NFiles Text               =============================
	%==============================================================
	btnNumber=0.2;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos=[left+ btnWid./3 yPos-btnHt btnWid./6.6 1.5*btnHt/3];
	callbackStr = '';
    tooltipstring = '';
	hNFilesText=uicontrol( ...
	'Style','text', ...
	'Units','normalized', ...
	'Position',btnPos, ...
	'String',' ', ...
    'BackgroundColor',[1 1 1],...
    'ToolTipString',tooltipstring,...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','on');
	%==============================================================
	% NFiles Label Text               =======================
	%==============================================================
    btnPos=[left+ btnWid./3 yPos-btnHt/2 btnWid./6.6 btnHt/2];
	callbackStr = ')';
    tooltipstring = '';
	hNFilesLabelText=uicontrol( ...
	'Style','text', ...
	'Units','normalized', ...
	'Position',btnPos, ...
    'BackgroundColor',ConsoleRGBColor,...
    'ToolTipString',tooltipstring,...
	'String','NFiles', ...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','on');
    %==============================================================
	% Format Text               =============================
	%==============================================================
	btnNumber=0.2;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos=[left+3*btnWid./6 yPos-btnHt btnWid./6.6 1.5*btnHt/3];
	callbackStr = '';
    tooltipstring = '';
	hFileFormatText=uicontrol( ...
	'Style','text', ...
	'Units','normalized', ...
	'Position',btnPos, ...
	'String',' ', ...
    'BackgroundColor',[1 1 1],...
    'ToolTipString',tooltipstring,...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','on');
	%==============================================================
	% Format Label Text               =======================
	%==============================================================
    btnPos=[left+3*btnWid./6 yPos-btnHt/2 btnWid./6.6 btnHt/2];
	callbackStr = ')';
    tooltipstring = '';
	hFileFormatLabelText=uicontrol( ...
	'Style','text', ...
	'Units','normalized', ...
	'Position',btnPos, ...
    'BackgroundColor',ConsoleRGBColor,...
    'ToolTipString',tooltipstring,...
	'String','Format', ...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','on');

	%==============================================================
	% SamplingRate Text               =============================
	%==============================================================
	btnNumber=0.2;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos=[left+4*btnWid/6 yPos-btnHt btnWid./6.6 1.5*btnHt/3];
	callbackStr = '';
    tooltipstring = '';
	hSamplingRateText=uicontrol( ...
	'Style','text', ...
	'Units','normalized', ...
	'Position',btnPos, ...
	'String',' ', ...
    'BackgroundColor',[1 1 1],...
    'ToolTipString',tooltipstring,...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','off');
	%==============================================================
	% SamplingRate Label Text               =======================
	%==============================================================
    btnPos=[left+4*btnWid/6 yPos-btnHt/2 btnWid./6.6 btnHt/2];
	callbackStr = ')';
    tooltipstring = '';
	hSamplingRateLabelText=uicontrol( ...
	'Style','text', ...
	'Units','normalized', ...
	'Position',btnPos, ...
    'BackgroundColor',ConsoleRGBColor,...
    'ToolTipString',tooltipstring,...
	'String','SRate', ...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','on');
    %==============================================================
	% NChan Text               =============================
	%==============================================================
	btnNumber=0.2;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos=[left+5*btnWid/6 yPos-btnHt btnWid./6.6 1.5*btnHt/3];
	callbackStr = '';
    tooltipstring = '';
	hNChanText=uicontrol( ...
	'Style','text', ...
	'Units','normalized', ...
	'Position',btnPos, ...
	'String',' ', ...
    'BackgroundColor',[1 1 1],...
    'ToolTipString',tooltipstring,...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','off');
	%==============================================================
	% NChan Label Text               =======================
	%==============================================================
    btnPos=[left+5*btnWid/6 yPos-btnHt/2 btnWid./6.6 btnHt/2];
	callbackStr = ')';
    tooltipstring = '';
	hNChanLabelText=uicontrol( ...
	'Style','text', ...
	'Units','normalized', ...
	'Position',btnPos, ...
    'BackgroundColor',ConsoleRGBColor,...
    'ToolTipString',tooltipstring,...
	'String','NChan', ...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','on');
	%====================================
	%====================================
	% The LowPassFilter frame
	%====================================
	%====================================
    
	frmBorder=0.05; 
	frmLeft=left+ 5*frmBorder;
	frmBottom=1 - 3.5*btnHt -frmBorder; 
	frmHeight = 3.37*btnHt; 
	frmWidth = btnWid-frmBorder*4.6;
	yPos=frmBottom-frmBorder;
	frmPos=[frmLeft frmBottom-0.4*(btnHth+spacing) frmWidth frmHeight*0.84];
	hLowPassFilterFrame=uicontrol( ...
	'Style','frame', ...
    'ForegroundColor',DefColor,...
    'ToolTipString',tooltipstring,...
	'Units','normalized', ...
	'Position',frmPos, ...
	'BackgroundColor',DefColor);
	%==============================================================
	% The LowPassFilter text
	%==============================================================
	lowpassbtnNumber = 1.3;
    btnNumber=lowpassbtnNumber-0.9;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left yPos-1.55*btnHth-spacing btnWid btnHth*0.8];
	callbackStr = '';
    tooltipstring = '';
	hLowPassFilterText=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',ConsoleRGBColor,...
	'Units','normalized', ...
    'ToolTipString',tooltipstring,...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
	'String','Choose low pass filter: ', ...
	'Userdata',[], ...
	'Enable','on');
    %==============================================================
	% The LowPassFilterConfigure button
	%==============================================================
    btnNumber=lowpassbtnNumber-0.9;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+2*btnWid./3 yPos-1.55*btnHth-spacing btnWid/3 btnHth];
	callbackStr = 'PrePro(''LaunchGetLowFiltCoeff'')';
    tooltipstring = '';
	hLowPassFiltConfigureButton=uicontrol( ...
	'Style','pushbutton', ...
	'Units','normalized', ...
    'ToolTipString',tooltipstring,...
    'BackgroundColor',DefColor,...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
	'String','configure ', ...
	'Callback',callbackStr,...
	'Userdata',[], ...
	'Enable','off');
    %==============================================================
	% Lowpass axes =============================================
	%==============================================================
	btnNumber=lowpassbtnNumber+3;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+0.037 0.81  btnWid./4.2 3.4*btnHth];
    labelStr='';
	hLowFiltAxes=axes( ...
	'Units','normalized', ...
	'Position',btnPos,'tag','lowpassaxes','fontunits','normalized','fontsize',0.07);
    %axis off;
	%==============================================================
	% hLowFiltRadio=============
	%==============================================================
    btnNumber=lowpassbtnNumber+ 0;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left yPos-btnHth-spacing+btnHth*0.2 btnWid./3 btnHth*0.8];
    tooltipstring = '';
	callbackStr = 'PrePro(''EnableLowPass'')';
	hLowFiltRadio=uicontrol( ...
	'Style','radio', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
    'ToolTipString',tooltipstring,...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
    'ToolTipString',tooltipstring,...
	'String','enable', ...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','off',...
    'tag','lowfiltradio');
	%==============================================================
	% Order ==============================
	%==============================================================
	btnNumber=lowpassbtnNumber+0;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+1*btnWid./3 yPos-btnHth-spacing btnWid./3 btnHth*0.8];
    tooltipstring = '';
	hLowFiltOrderText=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
    'ToolTipString',tooltipstring,...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
	'String','Order ', ...
	'Userdata',[], ...
	'Enable','off');
	%==============================================================
	% Order =============================================
	%==============================================================
	btnNumber=lowpassbtnNumber+1;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+1*btnWid./3 yPos-btnHth btnWid./3 btnHth*0.8];
	callbackStr = '';
    labelStr='auto';
    tooltipstring = '';
	hLowFiltOrder=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',[1 1 1],...
	'Units','normalized', ...
    'ToolTipString',tooltipstring,...
	'Position',btnPos, ...
	'String',labelStr, ...
    'ToolTipString',tooltipstring,...
	'Value',1,...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','off');
 	%==============================================================
	% FilterType ==============================
	%==============================================================
	btnNumber=lowpassbtnNumber+0;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+2*btnWid./3 yPos-btnHth-spacing btnWid./3 btnHth*0.8];
    tooltipstring = '';
	hLowFiltTypeText=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
    'ToolTipString',tooltipstring,...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
	'String','filter type ', ...
	'Userdata',[], ...
	'Enable','off');
	%==============================================================
	% Set FilterType =============================================
	%==============================================================
	btnNumber=lowpassbtnNumber+1;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+2*btnWid./3 yPos-btnHth btnWid./3 btnHth*0.8];
	callbackStr = '';
    labelStr='BUTTER';
    tooltipstring = '';
	hLowFiltType=uicontrol( ...
	'Style','text', ...
	'Units','normalized', ...
    'ToolTipString',tooltipstring,...
    'BackgroundColor',[1 1 1],...
    'ToolTipString',tooltipstring,...
	'Position',btnPos, ...
	'String',labelStr, ...
	'Value',4,...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','off');
	
  	%==============================================================
	% FPass ==============================
	%==============================================================
	btnNumber=lowpassbtnNumber+1.8;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+1*btnWid./3 yPos-btnHth+btnHth*0.2 btnWid./3 btnHth*0.8];
    tooltipstring = '';
	hLowFiltFPassText=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',DefColor,...
    'ToolTipString',tooltipstring,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
	'String','FPass ', ...
	'Userdata',[], ...
	'Enable','off');
	%==============================================================
	% FPass =============================================
	%==============================================================
	
	btnNumber=lowpassbtnNumber+1.8;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+1*btnWid./3 yPos-btnHth+btnHth*0.2-spacing btnWid./3 btnHth*0.8];
    tooltipstring = '';
	callbackStr = '';
    labelStr='40';
	hLowFiltFPass=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',[1 1 1],...
    'ToolTipString',tooltipstring,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'ToolTipString',tooltipstring,...
	'String',labelStr, ...
	'Value',4,...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','off');

    %==============================================================
	% FStop ==============================
	%==============================================================
	btnNumber=lowpassbtnNumber+1.8;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+2*btnWid./3 yPos-btnHth+btnHth*0.2 btnWid./3 btnHth*0.8];
    tooltipstring = '';
	hLowFiltFStopText=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'ToolTipString',tooltipstring,...
    'HorizontalAlignment','left',...
	'String','FStop ', ...
	'Userdata',[], ...
	'Enable','off');
	%==============================================================
	% FStop =============================================
	%==============================================================
	
	btnNumber=lowpassbtnNumber+1.8;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+2*btnWid./3 yPos-btnHth+btnHth*0.2-spacing btnWid./3 btnHth*0.8];
    tooltipstring = '';
	callbackStr = '';
    labelStr='50';
	hLowFiltFStop=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',[1 1 1],...
	'Units','normalized', ...
	'Position',btnPos, ...
    'ToolTipString',tooltipstring,...
	'String',labelStr, ...
	'Value',4,...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','off');

   %==============================================================
	%FPass ==============================
	%==============================================================
	btnNumber=lowpassbtnNumber+2.6;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+1*btnWid./3 yPos-btnHth+btnHth*0.2 btnWid./3 btnHth*0.8];
    tooltipstring = '';
	hLowFiltRPassText=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
    'ToolTipString',tooltipstring,...
	'String','RPass ', ...
	'Userdata',[], ...
	'Enable','off');
	%==============================================================
	% RPass =============================================
	%==============================================================
	
	btnNumber=lowpassbtnNumber+2.6;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+1*btnWid./3 yPos-btnHth+btnHth*0.2-spacing btnWid./3 btnHth*0.8];
    tooltipstring = '';
	callbackStr = '';
    labelStr='3';
	hLowFiltRPass=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',[1 1 1],...
	'Units','normalized', ...
	'Position',btnPos, ...
    'ToolTipString',tooltipstring,...
	'String',labelStr, ...
	'Value',4,...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','off');
	 %==============================================================
	% FStop ==============================
	%==============================================================
	btnNumber=lowpassbtnNumber+2.6;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+2*btnWid./3 yPos-btnHth+btnHth*0.2 btnWid./3 btnHth*0.8];
    tooltipstring = '';
	hLowFiltRStopText=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
    'ToolTipString',tooltipstring,...
	'String','RStop ', ...
	'Userdata',[], ...
	'Enable','off');
	%==============================================================
	% RStop =============================================
	%==============================================================
	
	btnNumber=lowpassbtnNumber+2.6;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+2*btnWid./3 yPos-btnHth+btnHth*0.2-spacing btnWid./3 btnHth*0.8];
    tooltipstring = '';
	callbackStr = '';
    labelStr='45';
	hLowFiltRStop=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',[1 1 1],...
    'ToolTipString',tooltipstring,...
	'Units','normalized', ...
	'Position',btnPos, ...
	'String',labelStr, ...
	'Value',4,...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','off');
 

    %====================================
	%====================================
	% The HighPassFilter frame
    %====================================
	%====================================
    
    
	frmBorder=0.05; 
	frmLeft=left+ 5*frmBorder;
	frmBottom=1 - 6.5*btnHt -frmBorder; 
	frmHeight = 3.35*btnHt; 
	frmWidth = btnWid-frmBorder*4.6;
	yPos=frmBottom-frmBorder;
	frmPos=[frmLeft frmBottom-1.0*(btnHth+spacing) frmWidth frmHeight*0.88];
	uicontrol( ...
	'Style','frame', ...
    'ForegroundColor',DefColor,...
	'Units','normalized', ...
	'Position',frmPos, ...
	'BackgroundColor',DefColor);

    %==============================================================
	% The HighPassFilter text
	%==============================================================
	highpassbtnNumber = 5.2;
    btnNumber=highpassbtnNumber-0.8;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left yPos-1.5*btnHth-spacing btnWid btnHth];
    tooltipstring = '';
	callbackStr = '';
	hHighPassFiltText=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',ConsoleRGBColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
    'ToolTipString',tooltipstring,...
	'String','Choose high pass filter: ', ...
	'Userdata',[], ...
	'Enable','on');
    %==============================================================
	% The HighPassFilterConfigure button
	%==============================================================
    btnNumber=highpassbtnNumber-0.8;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+2*btnWid./3 yPos-1.4*btnHth-spacing btnWid/3 btnHth];
    tooltipstring = '';
	callbackStr = 'PrePro(''LaunchGetHighFiltCoeff'')';
	hHighPassFiltConfigureButton=uicontrol( ...
	'Style','pushbutton', ...
	'Units','normalized', ...
    'BackgroundColor',DefColor,...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
    'ToolTipString',tooltipstring,...
	'Callback',callbackStr,...
    'BackgroundColor',DefColor,...
	'String','configure ', ...
	'Userdata',[], ...
	'Enable','off');
   %==============================================================
	% HighPass axes =============================================
	%==============================================================
	btnNumber=highpassbtnNumber+3;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+0.037 0.6702  btnWid./4.2 3.5*btnHth];
    labelStr='';
	hHighFiltAxes=axes( ...
	'Units','normalized', ...
	'Position',btnPos,...
    'tag','highpassaxes','fontunits','normalized','fontsize',0.07);
    %axis off;
	%==============================================================
	% hHighPassFiltRadio=================
	%==============================================================
	btnNumber=highpassbtnNumber+ 0;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left yPos-btnHth-spacing+0.2*btnHth btnWid./3 btnHth*0.8];
    tooltipstring = '';
	callbackStr = 'PrePro(''EnableHighPass'')';
	hHighPassFiltRadio=uicontrol( ...
	'Style','radio', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
    'ToolTipString',tooltipstring,...
	'String','enable', ...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','off',...
    'tag','highfiltradio');
	%==============================================================
	% Order ==============================
	%==============================================================
	btnNumber=highpassbtnNumber+ 0;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+1*btnWid./3 yPos-btnHth-spacing btnWid./3 btnHth];
    tooltipstring = '';
	hHighPassFiltOrderText=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
    'ToolTipString',tooltipstring,...
	'String','Order ', ...
	'Userdata',[], ...
	'Enable','off');
	%==============================================================
	% Order =============================================
	%==============================================================
	btnNumber=highpassbtnNumber+ 1;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+1*btnWid./3 yPos-btnHth btnWid./3 btnHth*0.8];
	callbackStr = '';
    labelStr='auto';
    tooltipstring = '';
	hHighPassFiltOrder=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',[1 1 1],...
	'Units','normalized', ...
	'Position',btnPos, ...
    'ToolTipString',tooltipstring,...
	'String',labelStr, ...
	'Value',1,...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','off');
 	%==============================================================
	% FilterType ==============================
	%==============================================================
	btnNumber=highpassbtnNumber+ 0;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+2*btnWid./3 yPos-btnHth-spacing btnWid./3 btnHth];
    tooltipstring = '';
	hHighPassFiltTypeText=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
	'String','filter type ', ...
	'Userdata',[], ...
	'Enable','off');
	%==============================================================
	% Set FilterType =============================================
	%==============================================================
	
	btnNumber=highpassbtnNumber+ 1;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+2*btnWid./3 yPos-btnHth btnWid./3 btnHth*0.8];
    tooltipstring = '';
	callbackStr = '';
    labelStr='BUTTER';
	hHighPassFiltType=uicontrol( ...
	'Style','text', ...
	'Units','normalized', ...
    'BackgroundColor',[1 1 1],...
    'ToolTipString',tooltipstring,...
	'Position',btnPos, ...
	'String',labelStr, ...
	'Value',4,...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','off');
	
  	%==============================================================
	% FPass ==============================
	%==============================================================
	btnNumber=highpassbtnNumber+ 1.8;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+1*btnWid./3 yPos-btnHth btnWid./3 btnHth*0.8];
    tooltipstring = '';
	hHighPassFiltFPassText=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
    'ToolTipString',tooltipstring,...
	'String','FPass ', ...
	'Userdata',[], ...
	'Enable','off');
	%==============================================================
	% FPass =============================================
	%==============================================================
	
	btnNumber=highpassbtnNumber+  1.8;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+1*btnWid./3 yPos-btnHth-spacing btnWid./3 btnHth*0.8];
    tooltipstring = '';
	callbackStr = '';
    labelStr='5';
	hHighPassFiltFPass=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',[1 1 1],...
    'ToolTipString',tooltipstring,...
	'Units','normalized', ...
	'Position',btnPos, ...
	'String',labelStr, ...
	'Value',4,...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','off');

    %==============================================================
	% FStop ==============================
	%==============================================================
	btnNumber=highpassbtnNumber+  1.8;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+2*btnWid./3 yPos-btnHth btnWid./3 btnHth*0.8];
    tooltipstring = '';
	hHighPassFiltFStopText=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
	'String','FStop ', ...
	'Userdata',[], ...
	'Enable','off');
	%==============================================================
	% FStop =============================================
	%==============================================================
	
	btnNumber=highpassbtnNumber+  1.8;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+2*btnWid./3 yPos-btnHth-spacing btnWid./3 btnHth*0.8];
    tooltipstring = '';
	callbackStr = '';
    labelStr='2';
	hHighPassFiltFStop=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',[1 1 1],...
    'ToolTipString',tooltipstring,...
	'Units','normalized', ...
	'Position',btnPos, ...
	'String',labelStr, ...
	'Value',4,...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','off');

   %==============================================================
	% RPass ==============================
	%==============================================================
	btnNumber=highpassbtnNumber+ 2.6;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+1*btnWid./3 yPos-btnHth btnWid./3 btnHth*0.8];
    tooltipstring = '';
	hHighPassFiltRPassText=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
	'String','RPass ', ...
	'Userdata',[], ...
	'Enable','off');
	%==============================================================
	% RPass =============================================
	%==============================================================
	
	btnNumber=highpassbtnNumber+ 2.6;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+1*btnWid./3 yPos-btnHth-spacing btnWid./3 btnHth*0.8];
    tooltipstring = '';
	callbackStr = '';
    labelStr='3';
	hHighPassFiltRPass=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',[1 1 1],...
    'ToolTipString',tooltipstring,...
	'Units','normalized', ...
	'Position',btnPos, ...
	'String',labelStr, ...
	'Value',4,...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','off');
	 %==============================================================
	% RStop ==============================
	%==============================================================
	btnNumber=highpassbtnNumber+ 2.6;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+2*btnWid./3 yPos-btnHth btnWid./3 btnHth*0.8];
    tooltipstring = '';
	hHighPassFiltRStopText=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
	'String','RStop ', ...
	'Userdata',[], ...
	'Enable','off');
	%==============================================================
	% RStop =============================================
	%==============================================================
	
	btnNumber=highpassbtnNumber+ 2.6;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+2*btnWid./3 yPos-btnHth-spacing btnWid./3 btnHth*0.8];
    tooltipstring = '';
	callbackStr = '';
    labelStr='45';
	hHighPassFiltRStop=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',[1 1 1],...
    'ToolTipString',tooltipstring,...
	'Units','normalized', ...
	'Position',btnPos, ...
	'String',labelStr, ...
	'Value',4,...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','off');





    %====================================
	%====================================
	% The StopFilter frame
    %====================================
	%====================================
	frmBorder=0.05; 
	frmLeft=left+ 5*frmBorder;
	frmBottom=1 - 9.92*btnHt -frmBorder; 
	frmHeight = 2.80*btnHt; 
	frmWidth = btnWid-frmBorder*4.6;
	yPos=frmBottom-frmBorder;
	frmPos=[frmLeft frmBottom-0.2*(btnHth+spacing) frmWidth frmHeight-0.8*(btnHth+spacing)];
	uicontrol( ...
	'Style','frame', ...
    'ForegroundColor',DefColor,...
	'Units','normalized', ...
	'Position',frmPos, ...
	'BackgroundColor',DefColor);

    %==============================================================
	% The StopFilter text
	%==============================================================
	stopbtnNumber = 9.3;
    btnNumber=stopbtnNumber-0.8;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left yPos-1.3*btnHth-spacing btnWid btnHth];
    tooltipstring = '';
	callbackStr = '';
	hStopFiltText = uicontrol( ...
	'Style','text', ...
    'BackgroundColor',ConsoleRGBColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
    'ToolTipString',tooltipstring,...
	'String','Choose stop filter: ', ...
	'Userdata',[], ...
	'Enable','on');
    %==============================================================
	% The StopFilterConfigure button
	%==============================================================
    btnNumber=stopbtnNumber-0.8;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+2*btnWid./3 yPos-1.3*btnHth-spacing btnWid/3 btnHth];
	callbackStr = 'PrePro(''LaunchGetStopFiltCoeff'')';
    tooltipstring = '';
	hStopFilterConfigureButton=uicontrol( ...
	'Style','pushbutton', ...
	'Units','normalized', ...
    'BackgroundColor',DefColor,...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
    'ToolTipString',tooltipstring,...
	'Callback',callbackStr,...
	'String','configure ', ...
	'Userdata',[], ...
	'Enable','off');
    %==============================================================
	% StopFilter axes =============================================
	%==============================================================
	btnNumber=lowpassbtnNumber+3;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+0.037 0.5563  btnWid./4.2 1.87*btnHth];
    labelStr='';
	hStopFiltAxes=axes( ...
	'Units','normalized', ...
	'Position',btnPos,...
    'tag','stopaxes','fontunits','normalized','fontsize',0.07);
    %axis off;
    
	%==============================================================
	%hStopFiltRadio===========
	%==============================================================
	btnNumber=stopbtnNumber+ 0;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left yPos-btnHth-spacing btnWid./3 btnHth];
    tooltipstring = '';
	callbackStr = 'PrePro(''EnableStop'')';
	hStopFiltRadio = uicontrol( ...
	'Style','radio', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
    'ToolTipString',tooltipstring,...
	'String','enable', ...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','off',...
    'tag','stopfiltradio');
	%==============================================================
	% Order ==============================
	%==============================================================
	btnNumber=stopbtnNumber+ 0;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+1*btnWid./3 yPos-btnHth-spacing btnWid./3 btnHth*0.8];
	hStopFiltOrderText=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
	'String','Order ', ...
	'Userdata',[], ...
	'Enable','off');
	%==============================================================
	% Order =============================================
	%==============================================================
	btnNumber=stopbtnNumber+ 0.8;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+1*btnWid./3 yPos-btnHth btnWid./3 btnHth*0.8];
	callbackStr = '';
    labelStr='auto';
    tooltipstring = '';
	hStopFiltOrder=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',[1 1 1],...
	'Units','normalized', ...
	'Position',btnPos, ...
	'String',labelStr, ...
    'ToolTipString',tooltipstring,...
	'Value',1,...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','off');
 	%==============================================================
	% FilterType ==============================
	%==============================================================
	btnNumber=stopbtnNumber+ 0;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+2*btnWid./3 yPos-btnHth-spacing btnWid./3 btnHth*0.8];
    tooltipstring = '';
	hStopFiltTypeText=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
    'ToolTipString',tooltipstring,...
	'String','filter type ', ...
	'Userdata',[], ...
	'Enable','off');
	%==============================================================
	% Set FilterType =============================================
	%==============================================================
	
	btnNumber=stopbtnNumber+ 0.8;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+2*btnWid./3 yPos-btnHth btnWid./3 btnHth*0.8];
	callbackStr = '';
    labelStr='Butter';
    tooltipstring = '';
	hStopFiltType=uicontrol( ...
	'Style','text', ...
	'Units','normalized', ...
    'BackgroundColor',[1 1 1],...
	'Position',btnPos, ...
	'String',labelStr, ...
    'ToolTipString',tooltipstring,...
	'Value',4,...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','off');
	
  	%==============================================================
	% FPass ==============================
	%==============================================================
	btnNumber=stopbtnNumber+ 1.6;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+1*btnWid./3 yPos-btnHth btnWid./3 btnHth*0.8];
    tooltipstring = '';
	hStopFiltFPassText=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
    'ToolTipString',tooltipstring,...
	'String','FLow ', ...
	'Userdata',[], ...
	'Enable','off');
	%==============================================================
	% FPass =============================================
	%==============================================================
	
	btnNumber=stopbtnNumber+ 1.6;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+1*btnWid./3 yPos-btnHth-spacing btnWid./3 btnHth*0.8];
	callbackStr = 'PrePro(''SetStopFilterFLow'')';
    tooltipstring = '';
    labelStr='49';
	hStopFiltFPass=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',[1 1 1],...
	'Units','normalized', ...
	'Position',btnPos, ...
	'String',labelStr, ...
	'Value',4,...
    'ToolTipString',tooltipstring,...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','off');

    %==============================================================
	% FStop ==============================
	%==============================================================
	btnNumber=stopbtnNumber+ 1.6;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+2*btnWid./3 yPos-btnHth btnWid./3 btnHth*0.8];
    tooltipstring = '';
	hStopFiltFStopText=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
	'String','FHigh ', ...
    'ForegroundColor',[0 0 0],...
	'Userdata',[], ...
	'Enable','off');
	%==============================================================
	% FStop =============================================
	%==============================================================
	
	btnNumber=stopbtnNumber+ 1.6;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+2*btnWid./3 yPos-btnHth-spacing btnWid./3 btnHth*0.8];
	callbackStr = 'PrePro(''SetStopFiltFHigh'')';
    tooltipstring = '';
    labelStr='51';
	hStopFiltFStop=uicontrol( ...
	'Style','text', ...
    'BackgroundColor',[1 1 1],...
	'Units','normalized', ...
    'ToolTipString',tooltipstring,...
	'Position',btnPos, ...
	'String',labelStr, ...
	'Value',4,...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','off');

 



    %====================================
	%====================================
	% The Segmentation frame
    %====================================
	%====================================
	frmBorder=0.05; 
	frmLeft=left-frmBorder*0.3;
	frmBottom=1 - 13.0*btnHt -frmBorder; 
	frmHeight = 1.5*btnHt; 
	frmWidth = btnWid+2*frmBorder*0.3;
	yPos=frmBottom-frmBorder;
	frmPos=[frmLeft frmBottom-0.3*(btnHth+spacing) frmWidth frmHeight*0.5];
	uicontrol( ...
	'Style','frame', ...
    'ForegroundColor',DefColor,...
	'Units','normalized', ...
	'Position',frmPos, ...
	'BackgroundColor',DefColor);

    %==============================================================
	% The Segmentation text
	%==============================================================
	segmbtnNumber = 14.9;
    btnNumber=segmbtnNumber-0.8;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left yPos-btnHth-0.4*spacing btnWid btnHth*0.7];
	callbackStr = '';
	hSegmentationText = uicontrol( ...
	'Style','text', ...
    'BackgroundColor',ConsoleRGBColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
	'String','Choose pre- and post trigger points: ', ...
	'Userdata',[], ...
	'Enable','on');
	%==============================================================
	% The PreTrig text
	%==============================================================
	segmbtnNumber = 14.6;
    btnNumber=segmbtnNumber+ 0;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left yPos-btnHth-spacing btnWid./2 btnHth];
	callbackStr = '';
	hPreTrigText = uicontrol( ...
	'Style','text', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
	'String','PreTrig', ...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','on');
    %==============================================================
	% The PreTrig edit=========================================
	%==============================================================
	btnNumber=segmbtnNumber+ 0;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+btnWid./4 yPos-btnHth-spacing 0.9*btnWid./4 btnHth];
	callbackStr = 'PrePro(''SetPreTrig'')';
    tooltipstring = 'enter number of time points before events';
    labelStr='';
	hPreTrigEdit=uicontrol( ...
	'Style','edit', ...
    'BackgroundColor',[1 1 1],...
    'ToolTipString',tooltipstring,...
	'Units','normalized', ...
	'Position',btnPos, ...
	'String','0', ...
	'Value',4,...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','on');
	%==============================================================
	%  The PostTrig text===========================
	%==============================================================
	btnNumber=segmbtnNumber+ 0;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+1*btnWid./2 yPos-btnHth-spacing btnWid./2 btnHth];
	hPostTrigText = uicontrol( ...
	'Style','text', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
	'String','PostTrig ', ...
	'Userdata',[], ...
	'Enable','on');
	
 	%==============================================================
	% The PostTrig edit===============================
	%==============================================================
	btnNumber=segmbtnNumber+ 0;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+3*btnWid./4 yPos-btnHth-spacing  0.9*btnWid./4 btnHth];
    tooltipstring = 'enter number of time points after events';
	callbackStr = 'PrePro(''SetPostTrig'')';
	hPostTrigEdit=uicontrol( ...
	'Style','edit', ...
    'BackgroundColor',[1 1 1],...
    'ForegroundColor',[0 0 0],...
    'ToolTipString',tooltipstring,...
	'Units','normalized', ...
	'Position',btnPos, ...
	'String','0', ...
	'Callback',callbackStr,...
	'Userdata',[], ...
	'Enable','on');
	
	
    %====================================
	%====================================
	% The Events frame
    %====================================
	%====================================
	frmBorder=0.05; 
	frmLeft=left-frmBorder*0.3;
	frmBottom=1 - 12.8*btnHt -frmBorder; 
	frmHeight = 1.5*btnHt; 
	frmWidth = btnWid+2*frmBorder*0.3;
	yPos=frmBottom-frmBorder;
	frmPos=[frmLeft frmBottom-2*(btnHth+spacing) frmWidth frmHeight*0.9];
	uicontrol( ...
	'Style','frame', ...
    'ForegroundColor',DefColor,...
	'Units','normalized', ...
	'Position',frmPos, ...
	'BackgroundColor',DefColor);

    %==============================================================
	% The Events text
	%==============================================================
	segmbtnNumber = 15.3;
    btnNumber=segmbtnNumber-0.8;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left yPos-btnHth-spacing btnWid btnHth];
	callbackStr = '';
	hEventText = uicontrol( ...
	'Style','text', ...
    'BackgroundColor',ConsoleRGBColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
	'String','Choose events to extract: ', ...
	'Userdata',[], ...
	'Enable','on',...
	'BackgroundColor',DefColor,...
    'visible','off');
	%==============================================================
	% The hUseAllConditionsRadio
	%==============================================================
	btnNumber=segmbtnNumber+ 0;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left yPos-btnHth-spacing 1.5*btnWid./2 btnHth];
	callbackStr = 'PrePro(''SetSpecConditionVec'')';
    tooltipstring = 'select to process all triggered events';
	hUseAllConditionsRadio = uicontrol( ...
	'Style','radiobutton', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
    'ToolTipString',tooltipstring,...
	'String','use all events', ...
    'Value',1,...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','on');
    %==============================================================
	% The hUseOnlyConditionsRadio=========================================
	%==============================================================
	btnNumber=segmbtnNumber+ 1;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left yPos-btnHth btnWid./2 btnHth];
	callbackStr = 'PrePro(''SetSpecConditionVec'')';
    labelStr='use only conditions: ';
    tooltipstring = 'select to only process listed triggers';
	hUseOnlyConditionsRadio=uicontrol( ...
	'Style','radiobutton', ...
	'Units','normalized', ...
	'Position',btnPos, ...
    'BackgroundColor',DefColor,...
    'ToolTipString',tooltipstring,...
	'Userdata',[], ...
	'Callback',callbackStr,...
    'String','use only: ',...
    'Value',0,...
	'Enable','on');
		
 	%==============================================================
	% The hUseOnlyEdit edit===============================
	%==============================================================
	btnNumber=segmbtnNumber+ 1;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+1*btnWid./3 yPos-btnHth 2*btnWid./3 btnHth];
	callbackStr = 'PrePro(''SetSpecConditionVec'')';
    tooltipstring = 'enter event codes to be processed';
	hUseOnlyEdit=uicontrol( ...
	'Style','edit', ...
    'BackgroundColor',[1 1 1],...
    'ForegroundColor',[0 0 0],...
	'Units','normalized', ...
	'Position',btnPos, ...
    'BackgroundColor',DefColor,...
    'ToolTipString',tooltipstring,...
	'Userdata',[], ...
	'Enable','off');

    %====================================
	%====================================
	% The Artifacts Detection
    %====================================
	%====================================
	frmBorder=0.05; 
	frmLeft=left-frmBorder*0.3;
	frmBottom=1 - 17.9*btnHt -frmBorder; 
	frmHeight = 3.8*btnHt; 
	frmWidth = btnWid+2*frmBorder*0.3;
	yPos=frmBottom-frmBorder;
	frmPos=[frmLeft frmBottom frmWidth frmHeight-1.0*(btnHth+spacing) ];
	uicontrol( ...
	'Style','frame', ...
    'ForegroundColor',DefColor,...
	'Units','normalized', ...
	'Position',frmPos, ...
	'BackgroundColor',DefColor);

    %==============================================================
	% The Artifacts  text
	%==============================================================
	segmbtnNumber = 17.5;
    btnNumber=segmbtnNumber-0.8;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left yPos-btnHth-spacing btnWid btnHth*0.8];
	callbackStr = '';
	hArtifactsText = uicontrol( ...
	'Style','text', ...
    'BackgroundColor',ConsoleRGBColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
	'String','Artifact detection: ', ...
	'Userdata',[], ...
	'Enable','on');
	%==============================================================
	% The Artifacts startpoint text
	%==============================================================
	btnNumber=segmbtnNumber+ 0.5;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left yPos-btnHth-spacing btnWid./4 btnHth];
	callbackStr = '';
	hArtStartPointText = uicontrol( ...
	'Style','text', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
	'String','pre:', ...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','off');
    %==============================================================
	% The Artifacts endpoint text
	%==============================================================
	btnNumber=segmbtnNumber+ 0.5;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+2*btnWid./4 yPos-btnHth-spacing btnWid./4 btnHth];
	callbackStr = '';
    labelStr='post:';
	hArtEndPointText = uicontrol( ...
	'Style','text', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
	'Userdata',[], ...
	'Callback',callbackStr,...
    'String',labelStr,...
	'Enable','off');
	%==============================================================
	% The Artifacts startpoint edit===============================
	%==============================================================
	btnNumber=segmbtnNumber+ 0.5;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+1*btnWid./4 yPos-btnHth-spacing 0.9*btnWid./4 btnHth];
    tooltipstring = 'enter first point to include in artifact detection';
	hArtifactsStartpointEdit=uicontrol( ...
	'Style','edit', ...
    'BackgroundColor',[1 1 1],...
    'ForegroundColor',[0 0 0],...
    'ToolTipString',tooltipstring,...
	'Units','normalized', ...
	'Position',btnPos, ...
	'Userdata',[], ...
    'String','0',...
	'Enable','off');	
 	%==============================================================
	% The Artifacts endpoint edit===============================
	%==============================================================
	btnNumber=segmbtnNumber+ 0.5;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+3*btnWid./4 yPos-btnHth-spacing 0.9*btnWid./4 btnHth];
    tooltipstring = 'enter last point to include in artifact detection';
	hArtifactsEndpointEdit=uicontrol( ...
	'Style','edit', ...
    'BackgroundColor',[1 1 1],...
    'ForegroundColor',[0 0 0],...
    'ToolTipString',tooltipstring,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'String','0',...
	'Userdata',[], ...
	'Enable','off');
    %==============================================================
	% The 'WholeIntervall' button
	%==============================================================
	btnNumber=segmbtnNumber+ 0.3;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left yPos-btnHth btnWid./2 btnHth];
    tooltipstring = 'select to include all points in artifact detection';
	callbackStr = 'PrePro(''ToggleTotalIntervallArtifacts'')';
    labelStr='artifact endpoint:';
	hWholeIntervall = uicontrol( ...
	'Style','radiobutton', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
    'ToolTipString',tooltipstring,...
	'Userdata',[], ...
	'Callback',callbackStr,...
    'String','total intervall',...
    'Value',1,...
	'Enable','on');
  
    %==============================================================
	% The 'FindBadChan' checkbox
	%==============================================================
	btnNumber=segmbtnNumber+ 2.2;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left yPos-btnHth btnWid./2 btnHth];
	callbackStr = '';
    tooltipstring = 'select to include all points in artifact detection';
    labelStr='artifact endpoint:';
	hFindBadChan = uicontrol( ...
	'Style','checkbox', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
    'ToolTipString',tooltipstring,...
	'Userdata',[], ...
	'Callback',callbackStr,...
    'String','find bad ch.',...
	'Enable','on',...
    'Value',1);
    %==============================================================
	% The 'FindBadChanTrial' checkbox
	%==============================================================
	btnNumber=segmbtnNumber+ 2.2;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+1*btnWid./2 yPos-btnHth btnWid./2 btnHth];
	callbackStr = '';
    labelStr='artifact endpoint:';
    tooltipstring = '';
	hFindBadChanTrial = uicontrol( ...
	'Style','checkbox', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
    'ToolTipString',tooltipstring,...
	'Userdata',[], ...
	'Callback',callbackStr,...
    'String','find bad ch. trials',...
	'Enable','on',...
    'Value',1);

    %==============================================================
	% The 'calc without a.ref.' checkbox
	%==============================================================
	btnNumber=segmbtnNumber+ 1.6;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left yPos-btnHth btnWid./2 btnHth];
    tooltipstring = '';
	callbackStr = '';
    labelStr='artifact endpoint:';
	hCalcWithoutAR = uicontrol( ...
	'Style','checkbox', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
    'ToolTipString',tooltipstring,...
	'Userdata',[], ...
	'Callback',callbackStr,...
    'String','calc without AR',...
	'Enable','on',...
    'Value',1);
    %==============================================================
	% The 'calc with a.ref.' checkbox
	%==============================================================
	btnNumber=segmbtnNumber+ 1.6;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+1*btnWid./2 yPos-btnHth btnWid./2 btnHth];
    tooltipstring = '';
	callbackStr = 'PrePro(''EnableCalcWithAR'')';
    labelStr='artifact endpoint:';
	hCalcWithAR = uicontrol( ...
	'Style','checkbox', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
    'ToolTipString',tooltipstring,...
	'Userdata',[], ...
	'Callback',callbackStr,...
    'String','calc with AR',...
	'Enable','on',...
    'Value',1);



    %====================================
	%====================================
	% The Data Format section
    %====================================
	%====================================
	frmBorder=0.05; 
	frmLeft=left-frmBorder*0.3;
	frmBottom=1 - 21.8*btnHt -frmBorder; 
	frmHeight = 4.1*btnHt; 
	frmWidth = btnWid+2*frmBorder*0.3;
	yPos=frmBottom-frmBorder;
	frmPos=[frmLeft frmBottom frmWidth frmHeight-1.0*(btnHth+spacing) ];
	uicontrol( ...
	'Style','frame', ...
    'ForegroundColor',DefColor,...
	'Units','normalized', ...
	'Position',frmPos, ...
	'BackgroundColor',DefColor);

    %==============================================================
	% The Data Format  text
	%==============================================================
	segmbtnNumber = 21.6;
    btnNumber=segmbtnNumber-0.8;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left yPos-btnHth-spacing btnWid btnHth];
    tooltipstring = '';
	callbackStr = '';
	hDataFormatText = uicontrol( ...
	'Style','text', ...
    'BackgroundColor',ConsoleRGBColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
    'ToolTipString',tooltipstring,...
	'String','Miscellanous: ', ...
	'Userdata',[], ...
	'Enable','on');
   %==============================================================
	% The 'remove artificial AR-channels' checkbox
	%==============================================================
	btnNumber=segmbtnNumber+ 0.25;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left yPos-btnHth btnWid btnHth];
    tooltipstring = '';
	callbackStr = '';
    labelStr='artifact endpoint:';
	hRemArtArChan = uicontrol( ...
	'Style','checkbox', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
    'ToolTipString',tooltipstring,...
	'Userdata',[], ...
	'Callback',callbackStr,...
    'String','remove additional AR-channels',...
	'Enable','on',...
    'Value',1);
    %==============================================================
	% The 'change RAW->TAW if necessary' checkbox
	%==============================================================
	btnNumber=segmbtnNumber+ 0.85;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left yPos-btnHth btnWid btnHth];
    tooltipstring = '';
	callbackStr = '';
	hChangeRawTaw = uicontrol( ...
	'Style','checkbox', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
    'ToolTipString',tooltipstring,...
	'Userdata',[], ...
	'Callback',callbackStr,...
    'String','change RAW->TAW if necessary',...
	'Enable','on',...
    'Value',1);
    %==============================================================
	% The 'skip step if file exists' checkbox
	%==============================================================
	btnNumber=segmbtnNumber+ 1.45;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left yPos-btnHth btnWid btnHth];
    tooltipstring = '';
	callbackStr = '';
	hRedoIfFileExists = uicontrol( ...
	'Style','checkbox', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
    'ToolTipString',tooltipstring,...
	'Userdata',[], ...
	'Callback',callbackStr,...
    'String','skip step if file exists',...
	'Enable','on',...
    'Value',1);
    %==============================================================
	% The 'one step for all files' radio
	%==============================================================
	btnNumber=segmbtnNumber+ 2.05;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left yPos-btnHth btnWid/2 btnHth];
    tooltipstring = '';
	callbackStr = 'PrePro(''OneForAll'')';
	hOneStepAllFiles = uicontrol( ...
	'Style','radio', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
    'ToolTipString',tooltipstring,...
	'Userdata',[], ...
	'Callback',callbackStr,...
    'String','one step for all',...
	'Enable','on',...
    'Value',0);
    %==============================================================
	% The 'all steps for one file' radio
	%==============================================================
	btnNumber=segmbtnNumber+ 2.05;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+btnWid/2 yPos-btnHth btnWid/2 btnHth];
    tooltipstring = '';
	callbackStr = 'PrePro(''AllForOne'')';
	hAllStepsOneFile = uicontrol( ...
	'Style','radio', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
    'ToolTipString',tooltipstring,...
	'Userdata',[], ...
	'Callback',callbackStr,...
    'String','all steps for one',...
	'Enable','on',...
    'Value',1);
    %==============================================================
	% The 'CreateEditingBatchfiles' check
	%==============================================================
	btnNumber=segmbtnNumber+ 2.65;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left yPos-btnHth btnWid btnHth];
    tooltipstring = '';
	callbackStr = '';
	hCreateEditingBatchfiles = uicontrol( ...
	'Style','checkbox', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
    'ToolTipString',tooltipstring,...
	'Userdata',[], ...
	'Callback',callbackStr,...
    'String','create editing batchfiles',...
	'Enable','on',...
    'Value',1);

    %==============================================================
	% The 'hContinueIfError' check
	%==============================================================
	btnNumber=segmbtnNumber+ 3.25;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left yPos-btnHth btnWid btnHth];
    tooltipstring = '';
	callbackStr = '';
	hContinueIfError = uicontrol( ...
	'Style','checkbox', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
    'ToolTipString',tooltipstring,...
	'Userdata',[], ...
	'Callback',callbackStr,...
    'String','continue if error',...
	'Enable','on',...
    'Value',1);


	%==============================================================
	% Run  button                     =============================
	%==============================================================
	btnNumber=26.4;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left yPos-btnHth btnWid./2 btnHth*2];
    tooltipstring = 'starts preprocessing of files in filematrix with given settings';
	callbackStr = 'PrePro(''Run'')';
	hRun=uicontrol( ...
	'Style','pushbutton', ...
	'Units','normalized', ...
    'BackgroundColor',DefColor,...
	'Position',btnPos, ...
	'String','Run', ...
    'ToolTipString',tooltipstring,...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','on');
    %==============================================================
	% close all button                =============================
	%==============================================================
	btnNumber=26.4;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+btnWid./2 yPos-btnHth btnWid./4 btnHth];
	callbackStr = 'PrePro(''CloseAll'')';
    tooltipstring = 'closes all figures';
	hCloseAll=uicontrol( ...
	'Style','pushbutton', ...
	'Units','normalized', ...
    'BackgroundColor',DefColor,...
	'Position',btnPos, ...
	'String','Close all', ...
    'ToolTipString',tooltipstring,...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','on');
  %==============================================================
	% close all % EditAEM                =============================
	%==============================================================
	btnNumber=26.4;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+btnWid./2+btnWid./4 yPos-btnHth btnWid./4 btnHth];
	callbackStr = 'PrePro(''Restart'')';
    tooltipstring = ' restarts ''PrePro''';
	hRestart=uicontrol( ...
	'Style','pushbutton', ...
	'Units','normalized', ...
    'BackgroundColor',DefColor,...
	'Position',btnPos, ...
	'String','Restart', ...
    'ToolTipString',tooltipstring,...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','on');
    %==============================================================
	% Restart button                  =============================
	%==============================================================
	btnNumber=26.4;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+btnWid./2 yPos btnWid./2 btnHth];
	callbackStr = 'PrePro(''CloseAllEditAEM'')';
    tooltipstring = 'closes all figures and starts EditAEM';
	hCloseAllEditAEM=uicontrol( ...
	'Style','pushbutton', ...
	'Units','normalized', ...
    'BackgroundColor',DefColor,...
	'Position',btnPos, ...
	'String',sprintf('%c','Close / EditAEM'), ...
    'ToolTipString',tooltipstring,...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','on');


    %====================================
	%====================================
	% The Choose amplifier calibration method frame
    %====================================
	%====================================
	frmBorder=0.05; 
	frmLeft=left-frmBorder*0.3;
	frmBottom=1 - 10.1*btnHt -frmBorder; 
	frmHeight = 1.5*btnHt; 
	frmWidth = btnWid+2*frmBorder*0.3;
	yPos=frmBottom-frmBorder;
	frmPos=[frmLeft frmBottom-2*(btnHth+spacing) frmWidth frmHeight*0.78];
	uicontrol( ...
	'Style','frame', ...
    'ForegroundColor',DefColor,...
	'Units','normalized', ...
	'Position',frmPos, ...
	'BackgroundColor',DefColor);

    %==============================================================
	% The Choose amplifier calibration method text
	%==============================================================
	segmbtnNumber = 12.5;
    btnNumber=segmbtnNumber-0.8;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left yPos-btnHth-1.1*spacing btnWid btnHth*0.8];
	callbackStr = '';
	uicontrol( ...
	'Style','text', ...
    'BackgroundColor',ConsoleRGBColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
	'String','Choose amplifier calibration method: ', ...
	'Userdata',[], ...
	'Enable','on',...
	'BackgroundColor',ConsoleRGBColor,...
    'visible','on');
	%==============================================================
	% The hAutoSearchAmpFilesRadio
	%==============================================================
	btnNumber=segmbtnNumber+ 0;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left yPos-btnHth-spacing btnWid btnHth];
	callbackStr = 'PrePro(''ToggleAmpFileMethod'')';
    tooltipstring = 'select to process all triggered events';
	hAutoSearchAmpFilesRadio = uicontrol( ...
	'Style','radiobutton', ...
    'BackgroundColor',DefColor,...
	'Units','normalized', ...
	'Position',btnPos, ...
    'HorizontalAlignment','left',...
    'ToolTipString',tooltipstring,...
	'String','autosearch GAIN & ZERO -files', ...
    'Value',1,...
	'Userdata',[], ...
	'Callback',callbackStr,...
	'Enable','on');
    %==============================================================
	% The hUseSpecAmpFilesRadio=========================================
	%==============================================================
	btnNumber=segmbtnNumber+ 1;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left yPos-btnHth btnWid./1.1 btnHth];
	callbackStr = 'PrePro(''ToggleAmpFileMethod2'')';
    labelStr='use the files:';
    tooltipstring = '';
	hUseSpecAmpFilesRadio=uicontrol( ...
	'Style','radiobutton', ...
	'Units','normalized', ...
    'BackgroundColor',DefColor,...
	'Position',btnPos, ...
    'ToolTipString',tooltipstring,...
	'Userdata',[], ...
	'Callback',callbackStr,...
    'String',labelStr,...
    'Value',0,...
	'Enable','on');
    %==============================================================
	% The hUseSpecAmpFilesButton=========================================
	%==============================================================
	btnNumber=segmbtnNumber+ 1;
	yPos=menutop-(btnNumber-1)*(btnHth+spacing);
	btnPos=[left+btnWid./2 yPos-btnHth btnWid./2 btnHth];
	callbackStr = 'PrePro(''ChooseAmpFiles'')';
    labelStr='browse';
    tooltipstring = '';
	hUseSpecAmpFilesButton=uicontrol( ...
	'Style','pushbutton', ...
	'Units','normalized', ...
    'BackgroundColor',DefColor,...
	'Position',btnPos, ...
    'ToolTipString',tooltipstring,...
	'Userdata',[], ...
	'Callback',callbackStr,...
    'String',labelStr,...
    'Value',0,...
	'Enable','on');

  
    
     
    
    %================================================================
    %================================================================
    % Menus
    %================================================================
    %================================================================
    
    %================================================================
    %   File Menu
    %================================================================  
    hFileMenu=uimenu('Label','File','ForegroundColor',[0 0 1],'Enable','on');
    
    hDataFormatMenu=uimenu(hFileMenu,'Label','Data Format','Separator','on');
	callbackStr = 'PrePro(''DataFormatEGI'')';
	hDataFormatEGIMenu=uimenu(hDataFormatMenu,'Label','EGI','Callback',callbackStr,'Checked','on');
	callbackStr = 'PrePro(''DataFormatNeuroscan'')';
	hDataFormatNeuroscanMenu=uimenu(hDataFormatMenu,'Label','Neuroscan','Callback',callbackStr,'Checked','off');
	callbackStr = 'PrePro(''DataFormatBTI'')';
	hDataFormatBTIMenu=uimenu(hDataFormatMenu,'Label','BTI','Callback',callbackStr,'Enable','on','Checked','off');
    
    
    
	hDefFileMenu=uimenu(hFileMenu,'Label','Default File','Separator','on');
	callbackStr = 'PrePro(''AutoViewDefaultFile'')';
	hAutoDefFileMenu=uimenu(hDefFileMenu,'Label','Auto','Callback',callbackStr,'Userdata',0);
	callbackStr = 'PrePro(''ReadViewDefaultFile'')';
	hFileLoadSettingsMenu=uimenu(hDefFileMenu,'Label','Open','Callback',callbackStr,'Accelerator','y');
	callbackStr = 'PrePro(''SaveViewDefaultFile'')';
	hFileSaveSettingsMenu=uimenu(hDefFileMenu,'Label','Save','Callback',callbackStr,'Enable','on','Accelerator','x');
	hInfoDefFileMenu=uimenu(hDefFileMenu,'Label','Info','Callback',callbackStr,'Separator','on','Enable','on');
	uimenu(hInfoDefFileMenu,'Label','No view def. file opened','Enable','on');
    
    hFileMatrixMenu=uimenu(hFileMenu,'Label','File matrix','Separator','on');
    callbackStr='PrePro(''OpenFileMatrix'')';
    hFileOpenFileMatrixMenu=uimenu(hFileMatrixMenu,'Label','Open file matrix','Callback',callbackStr);
    callbackStr='PrePro(''SaveFileMatrix'')';
    hFileSaveFileMatrixMenu=uimenu(hFileMatrixMenu,'Label','Save file matrix','Callback',callbackStr,'Enable','off');
    callbackStr='PrePro(''AddFile2FileMatrix'')';
    hFileAddFile2FileMatrixMenu=uimenu(hFileMatrixMenu,'Label','Add file to file matrix','Callback',callbackStr,'Enable','off');
    callbackStr='PrePro(''UseFileMatrix'')';
    hFileUseFileMatrixMenu=uimenu(hFileMatrixMenu,'Label','Use file matrix','Callback',callbackStr,'Enable','off','Userdata',0);
    callbackStr='PrePro(''FileMatrixInfo'')';
    hFileUseFileMatrixMenu=uimenu(hFileMatrixMenu,'Label','Info file matrix','Callback',callbackStr,'Enable','off','Userdata',0);
  
 
    %================================================================
    %================================================================
    % data controls
    %================================================================
    %================================================================
    
    hDefPath = uicontrol('visible','off','userdata',[]);
    hFileMat = uicontrol('visible','off','userdata',[],'Value',0);
    hAemFileMat = uicontrol('visible','off');
    hEstFileMat = uicontrol('visible','off');
    
    nouse = 0;
    hPreProList = [hLowPassFilterText hLowFiltRadio,hLowFiltOrderText,hLowFiltOrder,hLowFiltTypeText,...
                hLowFiltType,hLowFiltFPassText,hLowFiltFPass,hLowFiltFStopText,hLowFiltFStop,...                                   %10
                hLowFiltRPassText,hLowFiltRPass,hLowFiltRStopText,hLowFiltRStop,hHighPassFiltText,...
                hHighPassFiltRadio,hHighPassFiltOrderText,hHighPassFiltOrder,hHighPassFiltTypeText,hHighPassFiltType,...           %20
                hHighPassFiltFPassText,hHighPassFiltFPass,hHighPassFiltFStopText,hHighPassFiltFStop,hHighPassFiltRPassText,...
                hHighPassFiltRPass,hHighPassFiltRStopText,hHighPassFiltRStop,hStopFiltOrderText,hStopFiltRadio,...                 %30
                hStopFiltOrder,hStopFiltTypeText,hStopFiltType,hStopFiltFPassText,hStopFiltFPass,...
                hStopFiltFStopText,hStopFiltFStop,hLowFiltAxes,hHighFiltAxes,hStopFiltAxes,...                                     %40
                hPreTrigEdit,hPostTrigEdit,hUseAllConditionsRadio,hUseOnlyConditionsRadio,hUseOnlyEdit,...
                hArtifactsStartpointEdit, hArtifactsEndpointEdit,hFileMenu,hFileMatrixMenu,hFileOpenFileMatrixMenu,...              %50
                hFileSaveFileMatrixMenu,hFileAddFile2FileMatrixMenu,hFileUseFileMatrixMenu,hOpenRawFilesButton,hSamplingRateLabelText,...
                hSamplingRateText,hDataFormatMenu,hDataFormatEGIMenu,hDataFormatNeuroscanMenu,hDataFormatBTIMenu,...                %60
                hPreTrigText,hPreTrigEdit,hPostTrigText,hPostTrigEdit,hUseAllConditionsRadio,...
				hUseOnlyConditionsRadio,hUseOnlyEdit,hArtStartPointText,hArtEndPointText,hArtifactsStartpointEdit,...               %70
				hArtifactsEndpointEdit,hWholeIntervall,hFindBadChan,hFindBadChanTrial,hCalcWithoutAR...
				hCalcWithAR,hRemArtArChan,hChangeRawTaw,hRun,hCloseAll,...                                                          %80
				hRestart,hStopFiltText,hSegmentationText,hEventText,hArtifactsText,...
                hDataFormatText,hAutoSearchAmpFilesRadio,hUseSpecAmpFilesRadio,hUseSpecAmpFilesButton,nouse,...                     %90
                hNChanText,hNChanLabelText,hRedoIfFileExists,hCreateEditingBatchfiles,nouse,...     
                hOneStepAllFiles,hAllStepsOneFile,hFileFormatText,hNFilesText,hFileMat,...                                          %100
                hDefPath,hLowPassFiltConfigureButton,hHighPassFiltConfigureButton,hStopFilterConfigureButton,nouse,...
                hAemFileMat,hEstFileMat,hContinueIfError,nouse,nouse];                                                              %110
     
    set(hPreProMenuFig,'userdata',hPreProList);
    PrePro('DisableFilterChoice');
    PrePro('ToggleTotalIntervallArtifacts');
    PrePro('ToggleAmpFileMethod');
    
%============================================================================
%=========== EnableLowPass ==================================================
%============================================================================
elseif strcmp(action,'EnableLowPass'),

    hList = get(hPreProMenuFig,'userdata');
    LowPassStatus =  get(hList(2),'Value');
    coeffcell = get(hList(2),'userdata');
    if ~isempty(varargin);StartStatus = 1;else;StartStatus = 0; end
    if LowPassStatus
		set(hList(3),'Enable','on');
		set(hList(4),'Enable','on');
		set(hList(5),'Enable','on');
		set(hList(6),'Enable','on');
		set(hList(7),'Enable','on');
		set(hList(8),'Enable','on');
		set(hList(9),'Enable','on');
		set(hList(10),'Enable','on');
		set(hList(11),'Enable','on');
		set(hList(12),'Enable','on');
		set(hList(13),'Enable','on');
		set(hList(14),'Enable','on');
		set(hList(102),'Enable','on');
    else
		set(hList(3),'Enable','off');
		set(hList(4),'Enable','off');
		set(hList(5),'Enable','off');
		set(hList(6),'Enable','off');
		set(hList(7),'Enable','off');
		set(hList(8),'Enable','off');
		set(hList(9),'Enable','off');
		set(hList(10),'Enable','off');
		set(hList(11),'Enable','off');
		set(hList(12),'Enable','off');
		set(hList(13),'Enable','off');
		set(hList(14),'Enable','off');
		set(hList(102),'Enable','off');
    end
    
    if isempty(coeffcell) & ~StartStatus
        PrePro('LaunchGetLowFiltCoeff');
    end
        

%============================================================================
%=========== EnableHighPass =================================================
%============================================================================
elseif strcmp(action,'EnableHighPass'),
    
    hList = get(hPreProMenuFig,'userdata');
    HighPassStatus =  get(hList(16),'Value');
    coeffcell = get(hList(16),'userdata');
    if ~isempty(varargin);StartStatus = 1;else;StartStatus = 0; end
    if HighPassStatus
		set(hList(17),'Enable','on');
		set(hList(18),'Enable','on');
		set(hList(19),'Enable','on');
		set(hList(20),'Enable','on');
		set(hList(21),'Enable','on');
		set(hList(22),'Enable','on');
		set(hList(23),'Enable','on');
		set(hList(24),'Enable','on');
		set(hList(25),'Enable','on');
		set(hList(26),'Enable','on');
		set(hList(27),'Enable','on');
		set(hList(28),'Enable','on');
		set(hList(103),'Enable','on');
    else
		set(hList(17),'Enable','off');
		set(hList(18),'Enable','off');
		set(hList(19),'Enable','off');
		set(hList(20),'Enable','off');
		set(hList(21),'Enable','off');
		set(hList(22),'Enable','off');
		set(hList(23),'Enable','off');
		set(hList(24),'Enable','off');
		set(hList(25),'Enable','off');
		set(hList(26),'Enable','off');
		set(hList(27),'Enable','off');
		set(hList(28),'Enable','off');
		set(hList(29),'Enable','off');
		set(hList(103),'Enable','off');
    end
    if isempty(coeffcell) & ~StartStatus
        PrePro('LaunchGetHighFiltCoeff');
    end
    
%============================================================================
%=========== EnableStop =====================================================
%============================================================================
elseif strcmp(action,'EnableStop'),
    
     
    hList = get(hPreProMenuFig,'userdata');
    StopStatus =  get(hList(30),'Value');
    coeffcell = get(hList(30),'userdata');
    if ~isempty(varargin);StartStatus = 1;else;StartStatus = 0; end
    if StopStatus
		set(hList(29),'Enable','on');
		set(hList(31),'Enable','on');
		set(hList(32),'Enable','on');
		set(hList(33),'Enable','on');
		set(hList(34),'Enable','on');
		set(hList(35),'Enable','on');
		set(hList(36),'Enable','on');
		set(hList(37),'Enable','on');
		set(hList(104),'Enable','on');
    else
		set(hList(29),'Enable','off');
		set(hList(31),'Enable','off');
		set(hList(32),'Enable','off');
		set(hList(33),'Enable','off');
		set(hList(34),'Enable','off');
		set(hList(35),'Enable','off');
		set(hList(36),'Enable','off');
		set(hList(37),'Enable','off');
		set(hList(104),'Enable','off');
    end
    
    if isempty(coeffcell) & ~StartStatus
        PrePro('LaunchGetStopFiltCoeff');
    end
    
%============================================================================
%=========== ToggleTotalIntervallArtifacts =====================================================
%==========================================================================

elseif strcmp(action,'ToggleTotalIntervallArtifacts'),
    
    hList = get(hPreProMenuFig,'userdata');
    TotIntervallArtifactStatus =  get(hList(72),'Value');
    if ~TotIntervallArtifactStatus
        set(hList(68),'Enable','on');
        set(hList(69),'Enable','on');
        set(hList(70),'Enable','on');
        set(hList(71),'Enable','on');
    else
        set(hList(68),'Enable','off');
        set(hList(69),'Enable','off');
        set(hList(70),'Enable','off');
        set(hList(71),'Enable','off');
    end
    
    
    
%==========================================================================
%=========== ToggleAmpFileMethod ==========================================
%==========================================================================

elseif strcmp(action,'ToggleAmpFileMethod'),
    
    hList = get(hPreProMenuFig,'userdata');
    ToggleAmpFileMethod =  get(hList(87),'Value');
    if ToggleAmpFileMethod
        set(hList(88),'Value',0);
        set(hList(89),'Enable','off');
    else
        set(hList(88),'Value',1);
        set(hList(89),'Enable','on');   
        pathcell = get(hList(89),'userdata');
        if isempty(pathcell)
            PrePro('ChooseAmpFiles');
        end
    end 
    
%==========================================================================
%=========== DataFormatEGI,DataFormatNeuroscan,DataFormatBTI ==========================================
%==========================================================================

elseif strcmp(action,'DataFormatEGI') | ...
        strcmp(action,'DataFormatNeuroscan') | ...
        strcmp(action,'DataFormatBTI') 
        
    
    hList = get(hPreProMenuFig,'userdata');    
    
    if strcmp(action,'DataFormatEGI')
        set(hList(58),'checked','on')
        set(hList(59),'checked','off')
        set(hList(60),'checked','off')
    elseif strcmp(action,'DataFormatNeuroscan')
        set(hList(58),'checked','off')
        set(hList(59),'checked','on')
        set(hList(60),'checked','off')
    elseif strcmp(action,'DataFormatBTI') 
        set(hList(58),'checked','off')
        set(hList(59),'checked','off')
        set(hList(60),'checked','on')
    end
    
%==========================================================================
%=========== ToggleAmpFileMethod2 ==========================================
%==========================================================================

elseif strcmp(action,'ToggleAmpFileMethod2'),
    
    hList = get(hPreProMenuFig,'userdata');
    ToggleAmpFileMethod =  get(hList(88),'Value');
    if ToggleAmpFileMethod
        set(hList(87),'Value',0);
        set(hList(89),'Enable','on'); 
        pathcell = get(hList(89),'userdata');
        if isempty(pathcell)
            PrePro('ChooseAmpFiles');
        end
    else
        set(hList(87),'Value',1);
        set(hList(89),'Enable','off');
    end 
    
%==========================================================================
%=========== ToggleAmpFileMethod ==========================================
%==========================================================================    

elseif strcmp(action,'ChooseAmpFiles')
    
    
    hList = get(hPreProMenuFig,'userdata');
	DefFilePath=SetDefPath(1,'*.Gain',[],0);
	[GainFile,GainPath,GainFilePath]=ReadFilePath([],DefFilePath,'Please choose the over all gain file:');
	if GainFile==0; GainFile=[]; GainPath=[]; GainFilePath=[]; return;end
	SetDefPath(2,GainPath,[],0);
	DefFilePath=SetDefPath(1,'*.Zero',[],0);
	[ZeroFile,ZeroPath,ZeroFilePath]=ReadFilePath([],DefFilePath','Please choose the over all zero file:');
	if ZeroFile==0; ZeroFile=[]; ZeroPath=[]; ZeroFilePath=[]; return;end
    
    set(hList(89),'userdata',{GainFilePath;ZeroFilePath});
        

%============================================================================
%=========== EnableFilterChoice =============================================
%============================================================================
elseif strcmp(action,'EnableFilterChoice'),
    
    hList = get(hPreProMenuFig,'userdata');
	set(hList(2),'Enable','on');
	set(hList(16),'Enable','on');
	set(hList(30),'Enable','on');
    
	set(hList(61),'Enable','on');
	set(hList(62),'Enable','on');
	set(hList(63),'Enable','on');
	set(hList(64),'Enable','on');
	set(hList(65),'Enable','on');
	set(hList(67),'Enable','on');
	set(hList(68),'Enable','on');
	set(hList(69),'Enable','on');
	set(hList(70),'Enable','on');
	set(hList(71),'Enable','on');
	set(hList(72),'Enable','on');
	set(hList(73),'Enable','on');
	set(hList(74),'Enable','on');
	set(hList(75),'Enable','on');
	set(hList(76),'Enable','on');
	set(hList(77),'Enable','on');
	set(hList(78),'Enable','on');
	set(hList(79),'Enable','on');
    set(hList(1),'Enable','on');
	set(hList(15),'Enable','on');
	set(hList(44),'Enable','on');
	set(hList(82),'Enable','on');
	set(hList(83),'Enable','on');
	set(hList(84),'Enable','on');
	set(hList(85),'Enable','on');
	set(hList(86),'Enable','on');
	set(hList(87),'Enable','on');
	set(hList(88),'Enable','on');
	set(hList(89),'Enable','on');
    set(hList(93),'Enable','on');
    set(hList(94),'Enable','on');
    set(hList(96),'Enable','on');
    set(hList(97),'Enable','on');
    set(hList(108),'Enable','on');
    PrePro('ToggleTotalIntervallArtifacts');
    PrePro('SetSpecConditionVec');
    PrePro('ToggleAmpFileMethod');
    
%============================================================================
%=========== DisableFilterChoice ============================================
%============================================================================
elseif strcmp(action,'DisableFilterChoice'),
    
   
    hList = get(hPreProMenuFig,'userdata');
	set(hList(2),'Enable','off');
	set(hList(16),'Enable','off');
	set(hList(30),'Enable','off'); 
    
	set(hList(61),'Enable','off');
	set(hList(62),'Enable','off');
	set(hList(63),'Enable','off');
	set(hList(64),'Enable','off');
	set(hList(65),'Enable','off');
	set(hList(67),'Enable','off');
	set(hList(68),'Enable','off');
	set(hList(69),'Enable','off');
	set(hList(70),'Enable','off');
	set(hList(71),'Enable','off');
	set(hList(72),'Enable','off');
	set(hList(73),'Enable','off');
	set(hList(74),'Enable','off');
	set(hList(75),'Enable','off');
	set(hList(76),'Enable','off');
	set(hList(77),'Enable','off');
	set(hList(78),'Enable','off');
	set(hList(79),'Enable','off');
    
    set(hList(1),'Enable','off');
	set(hList(15),'Enable','off');
	set(hList(44),'Enable','off');
	set(hList(82),'Enable','off');
	set(hList(83),'Enable','off');
	set(hList(84),'Enable','off');
	set(hList(85),'Enable','off');
	set(hList(86),'Enable','off');
	set(hList(87),'Enable','off');
	set(hList(88),'Enable','off');
	set(hList(89),'Enable','off');
    set(hList(93),'Enable','off');
    set(hList(94),'Enable','off');
    set(hList(96),'Enable','off');
    set(hList(97),'Enable','off');
    set(hList(108),'Enable','off');
    PrePro('ToggleTotalIntervallArtifacts');
    PrePro('SetSpecConditionVec');
%============================================================================
%=========== OpenFileMatrix =================================================
%============================================================================
elseif  strcmp(action,'OpenFileMatrix') 
    
    hPreProList=get(hPreProMenuFig,'Userdata'); 
    hFileMenu = get(hPreProList(49),'children');
    BatchFileDefPath=get(hPreProList(101),'Userdata');
    if isempty(BatchFileDefPath)
         [BatchFileDefPath]=SetDefPath(1,[],[],0);
    end	
    [NFiles,FileMat,NonUse,BatchFilePath]=ReadFileNames([],BatchFileDefPath,'Please choose file(s):');
    if NFiles==0; return; end
    [BatchFile,BatchPath]=SepFilePath(BatchFilePath);
    set(hPreProList(101),'Userdata',BatchPath);
    set(hPreProList(100), 'Value',NFiles,'Userdata',FileMat);
    set(hFileMenu(3),'Enable','on'); %SaveFileMat
    set(hFileMenu(2),'Enable','on')	%AddFileName2FileMat
    set(hFileMenu(1),'Enable','on')	%UseFileMat
   
    PrePro('CheckFileMatrix');
    
%============================================================================
%=========== ClosePreProMenuFig =================================================
%============================================================================
elseif  strcmp(action,'ClosePreProMenuFig')     
    
    try
        hPreProList=get(hPreProMenuFig,'Userdata');
        MenuPos = get(hPreProMenuFig,'position');
        utilpath = strrep(which('PrePro.m'),'PrePro.m','PreProMenuPos.mat');
        save(utilpath,'MenuPos');
        hPreProList=get(hPreProMenuFig,'Userdata');
        %delete(hList(93));
        delete(hPreProMenuFig);
    catch
        delete(gcf);
    end
    
%============================================================================
%=========== SaveFileMatrix =================================================
%============================================================================

elseif  strcmp(action,'SaveFileMatrix') 
    
    hPreProList=get(hPreProMenuFig,'Userdata'); 
    FileMat=get(hPreProList(100),'Userdata')
    NFiles=get(hPreProList(100),'Value');
    PrePro('FileMatrixInfo');
    [SaveFile,SavePath,SaveFilePath]=WriteFilePath('FileMatrix.txt','Save file matrix to file:');
    if SaveFile==0; return; end
    fid=fopen(SaveFilePath,'wt','b');
    for FileIndex=1:NFiles
        fprintf(fid,[FileMat(FileIndex,:),'\n']);
    end
    fclose(fid);
    
%============================================================================
%=========== AddFile2FileMatrix =============================================
%============================================================================
elseif  strcmp(action,'AddFile2FileMatrix') 
    
    hPreProList=get(hPreProMenuFig,'Userdata'); 
    FileMatOld=get(hPreProList(100),'Userdata')
    NFilesOld=get(hPreProList(100),'Value');
    [NFiles,FileMat]=ReadFileNames([],'*','Please choose file(s) to add:');
    if NFiles==0; return; end
    NFiles=NFiles+NFilesOld;
    FileMat=char(FileMatOld,FileMat);
    set(hPreProList(100),'Userdata',FileMat,'Value',NFiles);
    PrePro('FileMatrixInfo');
    
%============================================================================
%=========== CheckFileMatrix ==================================================
%============================================================================
elseif  strcmp(action,'CheckFileMatrix') 
    
	  
    hPreProList=get(hPreProMenuFig,'Userdata'); 
 
    NFiles  = get(hPreProList(100), 'Value');
    FileMat = get(hPreProList(100), 'Userdata');
    SampRate = [];
    NChan = [];
    FileFormat = [];
    UseFileMatStatus = 1;
    disp('checking for equal formats and sampling rates:')
    
	for FileInd=1:NFiles
        
		[NoUse,NoUse,NetFilePath]=GetFileNameOfMat(FileMat,FileInd);
        FileFormatTmp = NetFilePath(max(findstr(NetFilePath,'.'))+1:end);
%         if FileInd ==1
%             if strcmp(FileFormat,'RAW') | strcmp(FileFormat,'raw')
%                 FileFormat = 'RAW';
%             elseif strcmp(FileFormat,'CNT') | strcmp(FileFormat,'cnt')
%                 FileFormat = 'CNT';
%             elseif strcmp(FileFormat,'xx') | strcmp(FileFormat,'xx')
%                 FileFormat = 'BTI';
%             else
%                 FileFormat = 'unrecognized';
%             end
%         end
        if strcmp(FileFormatTmp,'RAW') | strcmp(FileFormatTmp,'raw')
            FileFormatTmp = 'RAW';
        elseif strcmp(FileFormatTmp,'CNT') | strcmp(FileFormatTmp,'cnt')
            FileFormatTmp = 'CNT';
        elseif strcmp(FileFormatTmp,'xx') | strcmp(FileFormatTmp,'xx')
            FileFormatTmp = 'BTI';
        else
            FileFormatTmp = 'unrecognized';
        end
        
        if ~isempty(FileFormat)
			 if ~strcmp(FileFormatTmp,FileFormat) | strcmp(FileFormatTmp,'unrecognized')
				uiwait(errordlg('It is not possible to use the batch file because of different or unknown file formats !'));
                PrePro('DisableFilterChoice');
                UseFileMatStatus = 0;
                break;
			 end
         end
		FileFormat=FileFormatTmp;
              
        
        if strcmp(FileFormat,'RAW')
            
            [NoUse,NoUse,NoUse,NoUse, ...
            NoUse, NoUse, NoUse, NoUse, NoUse, NoUse, NoUse, ...
            SampRateTmp,NChanTmp]= ReadRAWHeader(NetFilePath);

            disp([NetFilePath,' : ',num2str(SampRateTmp)]);
            if ~isempty(SampRate)
                 if SampRateTmp~=SampRate
                    uiwait(errordlg('It is not possible to use the batch file because of different sampling rates !'));
                    PrePro('DisableFilterChoice');
                    UseFileMatStatus = 0;
                    break;
                 end
            end
             if ~isempty(NChan)
                 if NChanTmp~=NChan
                    uiwait(errordlg('It is not possible to use the batch file because of different number of channels !'));
                    PrePro('DisableFilterChoice');
                    UseFileMatStatus = 0;
                    break;
                 end
            end
            SampRate=SampRateTmp;
            NChan = NChanTmp;
            
        elseif strcmp(FileFormat,'CNT')
            try
                f=ReadNeuroScanStruct(NetFilePath);
                SampRateTmp=f.header.rate;
                NChanTmp=f.header.nchannels;
            catch
                uiwait(errordlg(['Error reading neuroscan header of file: ',NetFilePath,'. File may be corrupt!']));
                UseFileMatStatus = 0;
                break;
            end
                
            if ~isempty(SampRate)
                 if SampRateTmp~=SampRate
                    uiwait(errordlg('It is not possible to use the batch file because of different sampling rates !'));
                    PrePro('DisableFilterChoice');
                    UseFileMatStatus = 0;
                    break;
                 end
            end
             if ~isempty(NChan)
                 if NChanTmp~=NChan
                    uiwait(errordlg('It is not possible to use the batch file because of different number of channels !'));
                    PrePro('DisableFilterChoice');
                    UseFileMatStatus = 0;
                    break;
                 end
            end
            SampRate=SampRateTmp;
            NChan = NChanTmp;
            
        elseif strcmp(FileFormat,'BTI')
            
        end
        
        
    end
    if UseFileMatStatus==1; 
        
        set(hPreProList(98),'String',FileFormat);
        set(hPreProList(99),'String',num2str(NFiles));
        PrePro('UseFileMatrix')
        Message=char('Set "Use File Matrix" status "on".');
        hPlot3dStartMsg=msgbox(Message,'Info','help'); 
        hPlot3dStartMsgChild=get(hPlot3dStartMsg,'Children');
        set(hPlot3dStartMsgChild(length(hPlot3dStartMsgChild)),'Visible','off');
        pause(1);
        close(hPlot3dStartMsg);
        PrePro('FileMatrixInfo')
        set(hPreProList(56),'userdata',SampRate,'String',num2str(SampRate),'Enable','on');
        set(hPreProList(91),'String',num2str(NChan),'Enable','on');
        PrePro('EnableFilterChoice');
        
         
        if strcmp(FileFormat,'RAW')
            PrePro('DataFormatEGI')
        elseif strcmp(FileFormat,'CNT')
            PrePro('DataFormatNeuroscan')
        elseif strcmp(FileFormat,'BTI')
            PrePro('DataFormatBTI') 
        end
        
        
    end
            
	
    
%============================================================================
%=========== FileMatrixInfo =================================================
%============================================================================

elseif  strcmp(action,'FileMatrixInfo') 
    
    hPreProList=get(hPreProMenuFig,'Userdata'); 
    
    NFiles  = get(hPreProList(100), 'Value');
    FileMat = get(hPreProList(100), 'Userdata');
    fprintf(1,'\n'); clc;
    if NFiles==1
        Message=char(['The actual file matrix contains the following file:']);
        fprintf(1,'The actual file matrix contains the following file:\n\n');
    else
        Message=char(['The actual file matrix contains the following ',int2str(NFiles),' files:']);
        fprintf(1,'The actual file matrix contains the following %g files:\n\n',NFiles);
    end
    Message=char(Message,' ');
    Message=char(Message,FileMat);
    Message=char(Message,'');
    Message=char(Message,['Total number of files: ',int2str(NFiles)]);
    hmsgbox=msgbox(Message,'Info','help'); 
    set(hmsgbox,'Units','Normal');
    MsgBoxPos=get(hmsgbox,'Position');
    MsgBoxPos(1:2)=[0.1 0];
    set(hmsgbox,'Position',MsgBoxPos);
    pause(.001)
    disp(FileMat)
    
%============================================================================
%=========== UseFileMatrix =================================================
%============================================================================

elseif  strcmp(action,'UseFileMatrix') 
    
    hPreProList=get(hPreProMenuFig,'Userdata'); 
    
   
            
            
            
%============================================================================
%=========== LaunchGetLowFiltCoeff ==========================================
%============================================================================

elseif  strcmp(action,'LaunchGetLowFiltCoeff') 
    
    
    
    hPreProList=get(hPreProMenuFig,'Userdata'); 
    SampRate = get(hPreProList(56),'userdata');
    ch_LowPassFilt      = 1;
    ch_HighPassFilt     = 0;
    ch_StopFilt         = 0;
    
    
    %low:
	LowFiltRPStop   = str2num(get(hPreProList(14),'String'));
	LowFiltRPass    = str2num(get(hPreProList(12),'String'));
	LowFiltFStop    = str2num(get(hPreProList(10),'String'));
	LowFiltFPass    = str2num(get(hPreProList(8),'String'));
	LowFiltType     = get(hPreProList(6),'String');
	LowFiltOrder    = str2num(get(hPreProList( 4),'String'));
	%high:
	HighFiltRPStop  = str2num(get(hPreProList(28),'String'));
	HighFiltRPass   = str2num(get(hPreProList(26),'String'));
	HighFiltFStop   = str2num(get(hPreProList(24),'String'));
	HighFiltFPass   = str2num(get(hPreProList(22),'String'));
	HighFiltType    = get(hPreProList(20),'String');
	HighFiltOrder   = str2num(get(hPreProList(18),'String'));
    %stop
    StopFiltFStop   = str2num(get(hPreProList(37),'String'));
 	StopFiltFPass   = str2num(get(hPreProList(35),'String'));
 	StopFiltType    = get(hPreProList(33),'String');
 	StopFiltOrder   = str2num(get(hPreProList(36),'String'));
    
    
    %def freqs mat
    HighDefFreqsMat=[SampRate HighFiltFPass HighFiltFStop];
	HighDefRipMat=[HighFiltRPass HighFiltRPStop];
	LowDefFreqsMat=[SampRate LowFiltFPass LowFiltFStop]; 
	LowDefRipMat=[LowFiltRPass LowFiltRPStop];
    StopDefFreqsMat=[SampRate StopFiltFPass StopFiltFStop];
	StopDefRipMat=[3 5];
    
	
	
    [ch_LowPassFilt,LowB,LowA,ch_HighPassFilt,HighB,HighA,ch_StopFilt,StopB,StopA,LowFreqsMat,HighFreqsMat,StopFreqsMat,LowRipMat,...
        HighRipMat,StopRipMat,LowFiltType,HighFiltType,StopFiltType,LowFiltOrder,HighFiltOrder,StopFiltOrder]...
    = GetHighLowStopFiltCoeff(SampRate,HighDefFreqsMat,HighDefRipMat,LowDefFreqsMat,LowDefRipMat,...
	StopDefFreqsMat,StopDefRipMat,ch_LowPassFilt,ch_HighPassFilt,ch_StopFilt,1);


    %def freqs mat
    LowFiltFPass = LowFreqsMat(2);
    LowFiltFStop = LowFreqsMat(3);
    LowFiltRPass = LowRipMat(1);
    LowFiltRStop = LowRipMat(2);
    
    
     %low:
	set(hPreProList(14),'String',num2str(LowFiltRPStop));
	set(hPreProList(12),'String',num2str(LowFiltRPass));
	set(hPreProList(10),'String',num2str(LowFiltFStop));
	set(hPreProList(8),'String',num2str(LowFiltFPass));
	set(hPreProList(6),'String',LowFiltType);
	set(hPreProList( 4),'String',num2str(LowFiltOrder));
	

%============================================================================
%=========== LaunchGetHighFiltCoeff =========================================
%============================================================================

elseif  strcmp(action,'LaunchGetHighFiltCoeff') 
    
    hPreProList=get(hPreProMenuFig,'Userdata'); 
    SampRate = get(hPreProList(56),'userdata');
    ch_LowPassFilt      = 0;
    ch_HighPassFilt     = 1;
    ch_StopFilt         = 0;
    
    
    %low:
	LowFiltRPStop   = str2num(get(hPreProList(14),'String'));
	LowFiltRPass    = str2num(get(hPreProList(12),'String'));
	LowFiltFStop    = str2num(get(hPreProList(10),'String'));
	LowFiltFPass    = str2num(get(hPreProList(8),'String'));
	LowFiltType     = get(hPreProList(6),'String');
	LowFiltOrder    = str2num(get(hPreProList( 4),'String'));
	%high:
	HighFiltRPStop  = str2num(get(hPreProList(28),'String'));
	HighFiltRPass   = str2num(get(hPreProList(26),'String'));
	HighFiltFStop   = str2num(get(hPreProList(24),'String'));
	HighFiltFPass   = str2num(get(hPreProList(22),'String'));
	HighFiltType    = get(hPreProList(20),'String');
	HighFiltOrder   = str2num(get(hPreProList(18),'String'));
    %stop
    StopFiltFStop   = str2num(get(hPreProList(37),'String'));
 	StopFiltFPass   = str2num(get(hPreProList(35),'String'));
 	StopFiltType    = get(hPreProList(33),'String');
 	StopFiltOrder   = str2num(get(hPreProList(36),'String'));
    
    
    
    %def freqs mat
    HighDefFreqsMat=[SampRate HighFiltFPass HighFiltFStop];
	HighDefRipMat=[HighFiltRPass HighFiltRPStop];
	LowDefFreqsMat=[SampRate LowFiltFPass LowFiltFStop]; 
	LowDefRipMat=[LowFiltRPass LowFiltRPStop];
    StopDefFreqsMat=[SampRate StopFiltFPass StopFiltFStop];
	StopDefRipMat=[3 5];
    
	
	 [ch_LowPassFilt,LowB,LowA,ch_HighPassFilt,HighB,HighA,ch_StopFilt,StopB,StopA,LowFreqsMat,HighFreqsMat,StopFreqsMat,LowRipMat,...
        HighRipMat,StopRipMat,LowFiltType,HighFiltType,StopFiltType,LowFiltOrder,HighFiltOrder,StopFiltOrder]...
    = GetHighLowStopFiltCoeff(SampRate,HighDefFreqsMat,HighDefRipMat,LowDefFreqsMat,LowDefRipMat,...
	StopDefFreqsMat,StopDefRipMat,ch_LowPassFilt,ch_HighPassFilt,ch_StopFilt,1);


    %def freqs mat
    HighFiltFPass = HighFreqsMat(2);
    HighFiltFStop = HighFreqsMat(3);
    HighFiltRPass = HighRipMat(1);
    HighFiltRStop = HighRipMat(2);
    
    
	%high:
	set(hPreProList(28),'String',num2str(HighFiltRPStop));
	set(hPreProList(26),'String',num2str(HighFiltRPass));
	set(hPreProList(24),'String',num2str(HighFiltFStop));
	set(hPreProList(22),'String',num2str(HighFiltFPass));
	set(hPreProList(20),'String',HighFiltType);
	set(hPreProList(18),'String',num2str(HighFiltOrder));
    
%============================================================================
%=========== LaunchGetStopFiltCoeff =========================================
%============================================================================

elseif  strcmp(action,'LaunchGetStopFiltCoeff') 
    
    hPreProList=get(hPreProMenuFig,'Userdata'); 
    SampRate = get(hPreProList(56),'userdata');
    ch_LowPassFilt  = 0;
    ch_HighPassFilt = 0;
    ch_StopFilt     = 1;
    
    
    %low:
	LowFiltRPStop   = str2num(get(hPreProList(14),'String'));
	LowFiltRPass    = str2num(get(hPreProList(12),'String'));
	LowFiltFStop    = str2num(get(hPreProList(10),'String'));
	LowFiltFPass    = str2num(get(hPreProList(8),'String'));
	LowFiltType     = get(hPreProList(6),'String');
	LowFiltOrder    = str2num(get(hPreProList( 4),'String'));
	%high:
	HighFiltRPStop  = str2num(get(hPreProList(28),'String'));
	HighFiltRPass   = str2num(get(hPreProList(26),'String'));
	HighFiltFStop   = str2num(get(hPreProList(24),'String'));
	HighFiltFPass   = str2num(get(hPreProList(22),'String'));
	HighFiltType    = get(hPreProList(20),'String');
	HighFiltOrder   = str2num(get(hPreProList(18),'String'));
    %stop
    StopFiltFStop   = str2num(get(hPreProList(37),'String'));
 	StopFiltFPass   = str2num(get(hPreProList(35),'String'));
 	StopFiltType    = get(hPreProList(33),'String');
 	StopFiltOrder   = str2num(get(hPreProList(31),'String'));
    

    %def freqs mat
    StopDefFreqsMat=[SampRate StopFiltFPass StopFiltFStop];
	StopDefRipMat=[3 5];
    HighDefFreqsMat=[SampRate HighFiltFPass HighFiltFStop];
	HighDefRipMat=[HighFiltRPass HighFiltRPStop];
	LowDefFreqsMat=[SampRate LowFiltFPass LowFiltFStop]; 
	LowDefRipMat=[LowFiltRPass LowFiltRPStop];
    
	
	 [ch_LowPassFilt,LowB,LowA,ch_HighPassFilt,HighB,HighA,ch_StopFilt,StopB,StopA,LowFreqsMat,HighFreqsMat,StopFreqsMat,LowRipMat,...
        HighRipMat,StopRipMat,LowFiltType,HighFiltType,StopFiltType,LowFiltOrder,HighFiltOrder,StopFiltOrder]...
    = GetHighLowStopFiltCoeff(SampRate,HighDefFreqsMat,HighDefRipMat,LowDefFreqsMat,LowDefRipMat,...
	StopDefFreqsMat,StopDefRipMat,ch_LowPassFilt,ch_HighPassFilt,ch_StopFilt,1);


    %def freqs mat
    StopFiltFPass = StopFreqsMat(2);
    StopFiltFStop = StopFreqsMat(3);
    
    
	%stop:  
	set(hPreProList(37),'String',num2str(StopFiltFStop));
	set(hPreProList(35),'String',num2str(StopFiltFPass));
	set(hPreProList(33),'String',StopFiltType);
	set(hPreProList(31),'String',num2str(StopFiltOrder));

%============================================================================
%=========== Restart =========================================
%============================================================================

elseif  strcmp(action,'Restart') 
    
    deffilepath = strrep(which('emegs2d.m'),'emegs2d.m',['emegs2dUtil',filesep,'ViewDefault',filesep,'PreProViewDefTmp.ppr']);
    try
        %PrePro('SaveViewDefaultFile',deffilepath);
    catch
    end
            
    PrePro('CloseAll');
    clear all;
    
    PrePro;
    deffilepath = strrep(which('emegs2d.m'),'emegs2d.m',['emegs2dUtil',filesep,'ViewDefault',filesep,'PreProViewDefTmp.ppr']);
    try
        %PrePro('ReadViewDefaultFile',deffilepath);
    catch
    end
    
    
%============================================================================
%=========== CloseAll =========================================
%============================================================================

elseif  strcmp(action,'CloseAll')   
    
    close(findobj('tag','PreProMenuFig'));
 
%============================================================================
%=========== CloseAllEditAEM =========================================
%============================================================================

elseif  strcmp(action,'CloseAllEditAEM')   
    
    close(findobj('tag','PreProMenuFig'));
    EditAEM;
    
%============================================================================
%=========== SetSpecConditionVec ============================================
%============================================================================

elseif  strcmp(action,'SetSpecConditionVec')

    hPreProList=get(hPreProMenuFig,'Userdata'); 
    DefColor = [0.9137254901960784 0.9137254901960784 0.8470588235294118];
    if gcbo == hPreProList(43)
        if get(hPreProList(43),'Value')==1
            SpecConditionVec = [];
            set(hPreProList(44),'Value',0);
            set(hPreProList(45),'Enable','off');
            set(hPreProList(45),'BackgroundColor',DefColor);
        else
            set(hPreProList(44),'Value',1);
            SpecConditionVec = str2num(get(hPreProList(45),'String'))
            set(hPreProList(45),'Enable','on');
            set(hPreProList(45),'BackgroundColor',[1 1 1]);
        end
    else
        if get(hPreProList(44),'Value')==1
            SpecConditionVec = str2num(get(hPreProList(45),'String'))
            set(hPreProList(43),'Value',0);
            set(hPreProList(45),'Enable','on');
            set(hPreProList(45),'BackgroundColor',[1 1 1]);
        else
            set(hPreProList(43),'Value',1);
            SpecConditionVec = [];
            set(hPreProList(45),'Enable','off');
            set(hPreProList(45),'BackgroundColor',DefColor);
        end
    end
    set(hPreProList(43),'userdata',SpecConditionVec);
    

    
    
%============================================================================
%=========== Run =========================================
%============================================================================

elseif  strcmp(action,'SetPreTrig')   
    
    
    hPreProList=get(hPreProMenuFig,'Userdata'); 
    set(hPreProList(46),'String',get(hPreProList(41),'String'));
    set(hPreProList(47),'String',get(hPreProList(42),'String'));
    
%============================================================================
%=========== Run =========================================
%============================================================================

elseif  strcmp(action,'SetPostTrig')   
    
    
    hPreProList=get(hPreProMenuFig,'Userdata'); 
    set(hPreProList(46),'String',get(hPreProList(41),'String'));
    set(hPreProList(47),'String',get(hPreProList(42),'String'));
 
%============================================================================
%=========== Run =========================================
%============================================================================     
  elseif  strcmp(action,'EnableCalcWithAR')   
    
    
    hPreProList=get(hPreProMenuFig,'Userdata'); 
    if get(hPreProList(76),'Value')==1
        set(hPreProList(75),'Value',1);
        set(hPreProList(73),'Value',1);
        set(hPreProList(74),'Value',1);
    end
 
%============================================================================
%=========== Run =========================================
%============================================================================

elseif  strcmp(action,'Run')   
    
    hPreProList=get(hPreProMenuFig,'Userdata'); 
    
    if strcmp(get(hPreProList(58),'checked'),'on')
        DataFormat = 'RAW';
    elseif strcmp(get(hPreProList(59),'checked'),'on')
        DataFormat = 'CNT';
    elseif strcmp(get(hPreProList(60),'checked'),'on')
        DataFormat = 'BTI';
    end
    SampRate = get(hPreProList(56),'userdata');
    NChan = str2num(get(hPreProList(91),'String'));
    PreTrig = str2num(get(hPreProList(41),'String'));
    PostTrig = str2num(get(hPreProList(42),'String'));
    ArtifactTotalIntervallStatus = get(hPreProList(72),'Value');
    ArtifactStart = str2num(get(hPreProList(46),'String'));
    ArtifactStop = str2num(get(hPreProList(47),'String'));
    if ArtifactTotalIntervallStatus
        TimeStatusVec = [];
    else
        TimeStatusVec = zeros(1,PreTrig+PostTrig);
        TimeStatusVec(1,PreTrig-ArtifactStart+1:(PostTrig-ArtifactStop)+PreTrig) = 1;
    end
    LowPassStatus =  get(hPreProList(2),'Value');
    if LowPassStatus
        LowCoeffCell =  get(hPreProList(2),'Userdata');
        LowA = LowCoeffCell{1};
        LowB = LowCoeffCell{2};
    else
        LowA =[];
        LowB = [];
    end
    HighPassStatus =  get(hPreProList(16),'Value');
    if HighPassStatus
        HighCoeffCell =  get(hPreProList(16),'Userdata');
        HighA = HighCoeffCell{1};
        HighB = HighCoeffCell{2};
    else
        HighA =[];
        HighB = [];
    end
    StopStatus =  get(hPreProList(30),'Value');
    if StopStatus
        StopCoeffCell =  get(hPreProList(30),'Userdata');
        StopA = StopCoeffCell{1};
        StopB = StopCoeffCell{2};
    else
        StopA =[];
        StopB = [];
    end
    StopFiltFStop   = str2num(get(hPreProList(37),'String'));
 	StopFiltFPass   = str2num(get(hPreProList(35),'String'));
 	StopFiltType    = get(hPreProList(33),'String');
 	StopFiltOrder   = str2num(get(hPreProList(31),'String'));
	LowFiltRPStop   = str2num(get(hPreProList(14),'String'));
	LowFiltRPass    = str2num(get(hPreProList(12),'String'));
	LowFiltFStop    = str2num(get(hPreProList(10),'String'));
	LowFiltFPass    = str2num(get(hPreProList(8),'String'));
	LowFiltType     = get(hPreProList(6),'String');
	LowFiltOrder    = str2num(get(hPreProList( 4),'String'));
	HighFiltRPStop  = str2num(get(hPreProList(28),'String'));
	HighFiltRPass   = str2num(get(hPreProList(26),'String'));
	HighFiltFStop   = str2num(get(hPreProList(24),'String'));
	HighFiltFPass   = str2num(get(hPreProList(22),'String'));
	HighFiltType    = get(hPreProList(20),'String');
	HighFiltOrder   = str2num(get(hPreProList(18),'String'));
    StopFreqsMat=[SampRate StopFiltFPass StopFiltFStop];
	StopRipMat=[3 5];
    HighFreqsMat=[SampRate HighFiltFPass HighFiltFStop];
	HighRipMat=[HighFiltRPass HighFiltRPStop];
	LowFreqsMat=[SampRate LowFiltFPass LowFiltFStop]; 
	LowRipMat=[LowFiltRPass LowFiltRPStop];
    UseSpecConVecStatus  = get(hPreProList(44),'Value');
    SpecCondVec = str2num(get(hPreProList(45),'String'));
    RemoveARChannelsStatus =  get(hPreProList(78),'Value');
    CalcWithARStatus =  get(hPreProList(76),'Value');
    CalcWithoutARStatus =  get(hPreProList(75),'Value');
    FindBadChanStatus =  get(hPreProList(73),'Value');
    FindBadChanTrialStatus =  get(hPreProList(74),'Value');
    ChangeRawTawStatus =  get(hPreProList(78),'Value');
    NFiles = get(hPreProList(100), 'Value');
    FileMat = get(hPreProList(100),'Userdata');
    UseOverAllGainFileStatus = get(hPreProList(88),'Value');
    SkipStepStatus = get(hPreProList(93), 'Value');
    if UseOverAllGainFileStatus
        pathcell =  get(hPreProList(89),'userdata');
        GainFilePath = pathcell{1};
        ZeroFilePath = pathcell{2};
    else
        GainFilePath = [];
        ZeroFilePath = [];
    end
    AllForOneStatus = get(hPreProList(97),'Value');
    CreateBatchfileStatus = get(hPreProList(94),'Value');
    ContinueIfError = get(hPreProList(108),'Value');
        
    
    %Clear AemFileMat and EstFileMat
    %-------------------------------------
    set(hPreProList(106),'userdata',[]);
    set(hPreProList(107),'userdata',[]);
    
    %Extended options
    %----------------------------
    MaxMemory = 20;
    TRStatus=1;
    ch_ChooseChannelInd=0;
    ChanStatusVec=ones(NChan,1);
    PlotStatus=0;
    ch_AddSubZeros=0;
    NZPoints=[];
    MaxMemory=100;
    ch_CalcAvgRef = 0;
    ch_UseSpecChan = [];
    ch_CalcBaseline = 1;
    ch_ChooseTimeInd = 1;
    LFlatWin = 8;
    ch_CalcFlaMat = 0;
    ch_UseAWE = 0;
    AWELimesFac = 3;
    BatchStatus = 1;
    OldZeroVersion = 0;
    NGainZeroString = [];
    NStep = [];
    NDefTrials =[];
    SimpleTrig = [];
    IntTrig = [];
    DSample = [];
    DMeanSampleStatus = [];
    MinGoodChan = [];
    AlternPath = [];
    FreStart = [];
    FreEnd = [];
    ReTrig = 1;
    NetVersion = [];
    BaseStartPoint = 1;
    BaseEndPoint = PreTrig;
    
    NNetFiles  = size(FileMat,1);
    RAWFileMat = FileMat;
    
    clc;
    disp( '  ____  __  __  ____  ___  ___                                              ')
	disp( ' | __ )|  \/  || ___)| __ / __)                                             ')
	disp( ' | __) |      || __) | _ |\__ \                                             ')
	disp( ' |____)|_|\/|_||____)|___|/___/                                             ')
    fprintf(1,['\n']);
    fprintf(1,['Start preprocessing of ',num2str(NFiles),' file(s) ...\n']);
    
    if ~AllForOneStatus
        
        
        fprintf(1,['Completing one step for all files before continuing...\n']);
        fprintf(1,['-----------------------------------------------------\n\n']);
        pause(1);
        
        %1. remove empty average reference channels
        %----------------------------------------------
        if RemoveARChannelsStatus & strcmp(DataFormat,'RAW')
            [NRaw2NM1RawFileMat]=TestRawFiles(RAWFileMat,20,1,0);
        end

        %2. change file format RAW->TAW
        %----------------------------------------------
        TRStatus=1;
        if ChangeRawTawStatus & strcmp(DataFormat,'RAW')
            [TAWFileMat,TRStatus]=TransRawTaw(RAWFileMat,TRStatus,20,[],SkipStepStatus);
        else
            TAWFileMat = RAWFileMat;
        end

        %3. filter low and highpass
        %----------------------------------------------
        if  (LowPassStatus | HighPassStatus) 
            if strcmp(DataFormat,'RAW')
                [FilterTAWFileMat]=FilterNetFile(...
                        TAWFileMat,LowPassStatus,LowB,LowA,...
                        HighPassStatus,HighB,HighA,LowFreqsMat,HighFreqsMat,...
                        ch_ChooseChannelInd,ChanStatusVec,PlotStatus,ch_AddSubZeros,NZPoints,TRStatus,MaxMemory,...
						[],[],SkipStepStatus);
            elseif strcmp(DataFormat,'CNT')
                [FilterTAWFileMat]=FiltNeuroscanFiles(TAWFileMat,LowPassStatus,LowFreqsMat(2),LowFiltOrder, ...
                           HighPassStatus,HighFreqsMat(2),HighFiltOrder,StopStatus,StopFreqsMat(2),StopFiltOrder,1,SkipStepStatus)
            elseif strcmp(DataFormat,'BTI')
                FilterTAWFileMat = TAWFileMat;
            end
        else
            FilterTAWFileMat = TAWFileMat;
        end

        %4. filter stopband
        %----------------------------------------------
        if StopStatus & strcmp(DataFormat,'RAW')
            [FilterStopTAWFileMat]=FilterStopNetFile(...
                        FilterTAWFileMat,StopFiltOrder,[StopFiltFPass StopFiltFStop],...
                        ch_ChooseChannelInd,ChanStatusVec,PlotStatus, ...
                        ch_AddSubZeros,NZPoints,TRStatus,MaxMemory,SkipStepStatus);  
        else
            FilterStopTAWFileMat = FilterTAWFileMat;
        end

        %5. calibrate and segment  
        %----------------------------------------------  
        if strcmp(DataFormat,'RAW')
            [FilterEGISFileMat,NetFileMat,CondFileMat]=TransNetGeoHist(...
                        FilterStopTAWFileMat,TRStatus,...
                        PreTrig,PostTrig,ReTrig,GainFilePath,ZeroFilePath,OldZeroVersion,...
                        NGainZeroString,SpecCondVec,NStep,NDefTrials,SimpleTrig,DSample,...
                        DMeanSampleStatus,IntTrig,NetVersion,SkipStepStatus);
        elseif strcmp(DataFormat,'CNT')
            [FilterEGISFileMat,ConFileMat] = Neuroscan2Egis(FilterStopTAWFileMat,PreTrig,PostTrig,0,1,...
                0,[],[],0,[],[],0,[],[],1,SkipStepStatus);
        elseif strcmp(DataFormat,'BTI')
        end
   
                        
        %6. calc edit parameters (no avg. ref)
        %---------------------------------------------- 
        ch_CalcAvgRef = 0;
        if CalcWithoutARStatus
                [AEMFilePathMat]=CalcAutoEditMat(FilterEGISFileMat,TimeStatusVec,ch_CalcAvgRef,ch_UseSpecChan,...
                            ch_CalcBaseline,BaseStartPoint,BaseEndPoint,ch_ChooseTimeInd,LFlatWin,...
                            ch_CalcFlaMat,ch_UseAWE,MinGoodChan,AlternPath,FreStart,FreEnd,SkipStepStatus);
        end
    
                        
        %7. Find bad channels
        %----------------------------------------------
        if FindBadChanStatus
            FindBadChan(AEMFilePathMat,AWELimesFac,BatchStatus,SkipStepStatus,0);
        end

     
        %8. Find bad trials
        %----------------------------------------------
        AWELimesFac = 2.5;   
        if FindBadChanTrialStatus
            [AWEFileMat]=FindBadChanTrial(AEMFilePathMat,AWELimesFac,BatchStatus,SkipStepStatus,0);
        end

    
        
        %9. recalc edit parameters with avg. ref
        %----------------------------------------------
        ch_CalcAvgRef = 1;
        ch_UseSpecChan = 1;
        ch_ChooseTimeInd = 0;
        ch_CalcFlaMat = 1;
        ch_UseAWE = 1;
        if CalcWithARStatus & ~strcmp(DataFormat,'BTI')
            [AEMFilePathMat]=CalcAutoEditMat(FilterEGISFileMat,TimeStatusVec,ch_CalcAvgRef,ch_UseSpecChan,...
                            ch_CalcBaseline,BaseStartPoint,BaseEndPoint,ch_ChooseTimeInd,LFlatWin,...
                            ch_CalcFlaMat,ch_UseAWE,MinGoodChan,AlternPath,FreStart,FreEnd,SkipStepStatus);
        end
        set(hPreProList(106),'userdata',AEMFilePathMat);
        [EstFileMat]=FileNameExt2Mat(AEMFilePathMat,['.',num2str(NChan+1),'est'],7);
        set(hPreProList(107),'userdata',EstFileMat);
        
        if CreateBatchfileStatus
            PrePro('CreateEditingBatchfiles');
        end
        
        fprintf(1,'\n');
        fprintf(1,['-----------------------------------------------------\n']);
        fprintf(1,['Preprocessing done.\n']);
        
       

    else
        
            
        fprintf(1,['Completing all steps for one file before continuing...\n']);
        fprintf(1,['-----------------------------------------------------\n\n']);
        pause(1);
        
        NNetFiles  = size(FileMat,1);
        RAWFileMat = FileMat;
        
        
        for FileInd = 1: NNetFiles
                        
            
            if ContinueIfError
            
                [RAWFile,RAWPath,RAWFileMat] = GetFileNameOfMat(FileMat,FileInd);
                fprintf(1,['Processing ',num2str(FileInd),'. file: ',RAWFile,' ...\n']);
                
                try
                    
                    %1. remove empty average reference channels
                    %----------------------------------------------
                    if RemoveARChannelsStatus & strcmp(DataFormat,'RAW')
                        [NRaw2NM1RawFileMat]=TestRawFiles(RAWFileMat,20,1,0);
                    end
			
                    %2. change file format RAW->TAW
                    %----------------------------------------------
                    TRStatus=1;
                    if ChangeRawTawStatus & strcmp(DataFormat,'RAW')
                        [TAWFileMat,TRStatus]=TransRawTaw(RAWFileMat,TRStatus,20,[],SkipStepStatus);
                    else
                        TAWFileMat = RAWFileMat;
                    end
			
                    %3. filter low and highpass
                    %----------------------------------------------
                    if  (LowPassStatus | HighPassStatus) 
                        if strcmp(DataFormat,'RAW')
                            [FilterTAWFileMat]=FilterNetFile(...
                                    TAWFileMat,LowPassStatus,LowB,LowA,...
                                    HighPassStatus,HighB,HighA,LowFreqsMat,HighFreqsMat,...
                                    ch_ChooseChannelInd,ChanStatusVec,PlotStatus,ch_AddSubZeros,NZPoints,TRStatus,MaxMemory,...
									[],[],SkipStepStatus);
                        elseif strcmp(DataFormat,'CNT')
                            [FilterTAWFileMat]=FiltNeuroscanFiles(TAWFileMat,LowPassStatus,LowFreqsMat(2),LowFiltOrder, ...
                                       HighPassStatus,HighFreqsMat(2),HighFiltOrder,StopStatus,StopFreqsMat(2),StopFiltOrder,1,SkipStepStatus);
                        elseif strcmp(DataFormat,'BTI')
                            FilterTAWFileMat = TAWFileMat;
                        end
                    else
                        FilterTAWFileMat = TAWFileMat;
                    end
			
                    %4. filter stopband
                    %----------------------------------------------
                    if StopStatus & strcmp(DataFormat,'RAW')
                        [FilterStopTAWFileMat]=FilterStopNetFile(...
                                    FilterTAWFileMat,StopFiltOrder,[StopFiltFPass StopFiltFStop],...
                                    ch_ChooseChannelInd,ChanStatusVec,PlotStatus, ...
                                    ch_AddSubZeros,NZPoints,TRStatus,MaxMemory,SkipStepStatus);  
                    else
                        FilterStopTAWFileMat = FilterTAWFileMat;
                    end
			
                    %5. calibrate and segment  
                    %----------------------------------------------  
                    if strcmp(DataFormat,'RAW')
                        [FilterEGISFileMat,NetFileMat,CondFileMat]=TransNetGeoHist(...
                                    FilterStopTAWFileMat,TRStatus,...
                                    PreTrig,PostTrig,ReTrig,GainFilePath,ZeroFilePath,OldZeroVersion,...
                                    NGainZeroString,SpecCondVec,NStep,NDefTrials,SimpleTrig,DSample,...
                                    DMeanSampleStatus,IntTrig,NetVersion,SkipStepStatus);
                    elseif strcmp(DataFormat,'CNT')
                        [FilterEGISFileMat,ConFileMat] = Neuroscan2Egis(FilterStopTAWFileMat,PreTrig,PostTrig,0,1,...
                            0,[],[],0,[],[],0,[],[],1,SkipStepStatus);
                    elseif strcmp(DataFormat,'BTI')
                    end
               
                                    
                    %6. calc edit parameters (no avg. ref)
                    %---------------------------------------------- 
                    ch_CalcAvgRef = 0;
                    if CalcWithoutARStatus
                            [AEMFilePathMat]=CalcAutoEditMat(FilterEGISFileMat,TimeStatusVec,ch_CalcAvgRef,ch_UseSpecChan,...
                                        ch_CalcBaseline,BaseStartPoint,BaseEndPoint,ch_ChooseTimeInd,LFlatWin,...
                                        ch_CalcFlaMat,ch_UseAWE,MinGoodChan,AlternPath,FreStart,FreEnd,SkipStepStatus);
                    end
                
                                    
                    %7. Find bad channels
                    %----------------------------------------------
                    if FindBadChanStatus
                        FindBadChan(AEMFilePathMat,AWELimesFac,BatchStatus,SkipStepStatus,0);
                    end
			
                 
                    %8. Find bad trials
                    %----------------------------------------------
                    AWELimesFac = 2.5;   
                    if FindBadChanTrialStatus
                        [AWEFileMat]=FindBadChanTrial(AEMFilePathMat,AWELimesFac,BatchStatus,SkipStepStatus,0);
                    end
			
                
                    
                    %9. recalc edit parameters with avg. ref
                    %----------------------------------------------
                    ch_CalcAvgRef = 1;
                    ch_UseSpecChan = 1;
                    ch_ChooseTimeInd = 0;
                    ch_CalcFlaMat = 1;
                    ch_UseAWE = 1;
                    if CalcWithARStatus & ~strcmp(DataFormat,'BTI')
                        [AEMFilePathMat]=CalcAutoEditMat(FilterEGISFileMat,TimeStatusVec,ch_CalcAvgRef,ch_UseSpecChan,...
                                        ch_CalcBaseline,BaseStartPoint,BaseEndPoint,ch_ChooseTimeInd,LFlatWin,...
                                        ch_CalcFlaMat,ch_UseAWE,MinGoodChan,AlternPath,FreStart,FreEnd,SkipStepStatus);
                    end
                    
                    OldAEMFilePathMat = get(hPreProList(106),'userdata');
                    [EstFileMat]=FileNameExt2Mat(AEMFilePathMat,['.',num2str(NChan+1),'est'],7);
                    AEMFilePathMat = char(OldAEMFilePathMat,AEMFilePathMat);
                    set(hPreProList(106),'userdata',AEMFilePathMat);
                    OldEstFileMat = get(hPreProList(107),'userdata');
                    EstFileMat = char(OldEstFileMat,EstFileMat);
                    set(hPreProList(107),'userdata',EstFileMat);
            
                    
                catch
                    
                    disp(['WARNING: An error occured while processing the ',num2str(FileInd),'. file: ',RAWFile,' ...']);
                    disp(['The error message was:']);
                    disp(lasterr);
                    disp('Continuing with next file...');
                end

            else
                
                [RAWFile,RAWPath,RAWFileMat] = GetFileNameOfMat(FileMat,FileInd);
                fprintf(1,['Processing ',num2str(FileInd),'. file: ',RAWFile,' ...\n']);
                
                    
                %1. remove empty average reference channels
                %----------------------------------------------
                if RemoveARChannelsStatus & strcmp(DataFormat,'RAW')
                    [NRaw2NM1RawFileMat]=TestRawFiles(RAWFileMat,20,1,0);
                end
		
                %2. change file format RAW->TAW
                %----------------------------------------------
                TRStatus=1;
                if ChangeRawTawStatus & strcmp(DataFormat,'RAW')
                    [TAWFileMat,TRStatus]=TransRawTaw(RAWFileMat,TRStatus,20,[],SkipStepStatus);
                else
                    TAWFileMat = RAWFileMat;
                end
		
                %3. filter low and highpass
                %----------------------------------------------
                if  (LowPassStatus | HighPassStatus) 
                    if strcmp(DataFormat,'RAW')
                        [FilterTAWFileMat]=FilterNetFile(...
                                TAWFileMat,LowPassStatus,LowB,LowA,...
                                HighPassStatus,HighB,HighA,LowFreqsMat,HighFreqsMat,...
                                ch_ChooseChannelInd,ChanStatusVec,PlotStatus,ch_AddSubZeros,NZPoints,TRStatus,MaxMemory,...
								[],[],SkipStepStatus);
                    elseif strcmp(DataFormat,'CNT')
                        [FilterTAWFileMat]=FiltNeuroscanFiles(TAWFileMat,LowPassStatus,LowFreqsMat(2),LowFiltOrder, ...
                                   HighPassStatus,HighFreqsMat(2),HighFiltOrder,StopStatus,StopFreqsMat(2),StopFiltOrder,1,SkipStepStatus);
                    elseif strcmp(DataFormat,'BTI')
                        FilterTAWFileMat = TAWFileMat;
                    end
                else
                    FilterTAWFileMat = TAWFileMat;
                end
		
                %4. filter stopband
                %----------------------------------------------
                if StopStatus & strcmp(DataFormat,'RAW')
                    [FilterStopTAWFileMat]=FilterStopNetFile(...
                                FilterTAWFileMat,StopFiltOrder,[StopFiltFPass StopFiltFStop],...
                                ch_ChooseChannelInd,ChanStatusVec,PlotStatus, ...
                                ch_AddSubZeros,NZPoints,TRStatus,MaxMemory,SkipStepStatus);  
                else
                    FilterStopTAWFileMat = FilterTAWFileMat;
                end
		
                %5. calibrate and segment  
                %----------------------------------------------  
                if strcmp(DataFormat,'RAW')
                    [FilterEGISFileMat,NetFileMat,CondFileMat]=TransNetGeoHist(...
                                FilterStopTAWFileMat,TRStatus,...
                                PreTrig,PostTrig,ReTrig,GainFilePath,ZeroFilePath,OldZeroVersion,...
                                NGainZeroString,SpecCondVec,NStep,NDefTrials,SimpleTrig,DSample,...
                                DMeanSampleStatus,IntTrig,NetVersion,SkipStepStatus);
                elseif strcmp(DataFormat,'CNT')
                    [FilterEGISFileMat,ConFileMat] = Neuroscan2Egis(FilterStopTAWFileMat,PreTrig,PostTrig,0,1,...
                        0,[],[],0,[],[],0,[],[],1,SkipStepStatus);
                elseif strcmp(DataFormat,'BTI')
                end
           
                                
                %6. calc edit parameters (no avg. ref)
                %---------------------------------------------- 
                ch_CalcAvgRef = 0;
                if CalcWithoutARStatus
                        [AEMFilePathMat]=CalcAutoEditMat(FilterEGISFileMat,TimeStatusVec,ch_CalcAvgRef,ch_UseSpecChan,...
                                    ch_CalcBaseline,BaseStartPoint,BaseEndPoint,ch_ChooseTimeInd,LFlatWin,...
                                    ch_CalcFlaMat,ch_UseAWE,MinGoodChan,AlternPath,FreStart,FreEnd,SkipStepStatus);
                end
            
                                
                %7. Find bad channels
                %----------------------------------------------
                if FindBadChanStatus
                    FindBadChan(AEMFilePathMat,AWELimesFac,BatchStatus,SkipStepStatus,0);
                end
		
             
                %8. Find bad trials
                %----------------------------------------------
                AWELimesFac = 2.5;   
                if FindBadChanTrialStatus
                    [AWEFileMat]=FindBadChanTrial(AEMFilePathMat,AWELimesFac,BatchStatus,SkipStepStatus,0);
                end
		
            
                
                %9. recalc edit parameters with avg. ref
                %----------------------------------------------
                ch_CalcAvgRef = 1;
                ch_UseSpecChan = 1;
                ch_ChooseTimeInd = 0;
                ch_CalcFlaMat = 1;
                ch_UseAWE = 1;
                if CalcWithARStatus & ~strcmp(DataFormat,'BTI')
                    [AEMFilePathMat]=CalcAutoEditMat(FilterEGISFileMat,TimeStatusVec,ch_CalcAvgRef,ch_UseSpecChan,...
                                    ch_CalcBaseline,BaseStartPoint,BaseEndPoint,ch_ChooseTimeInd,LFlatWin,...
                                    ch_CalcFlaMat,ch_UseAWE,MinGoodChan,AlternPath,FreStart,FreEnd,SkipStepStatus);
                end
                
                OldAEMFilePathMat = get(hPreProList(106),'userdata');
                [EstFileMat]=FileNameExt2Mat(AEMFilePathMat,['.',num2str(NChan+1),'est'],7);
                AEMFilePathMat = char(OldAEMFilePathMat,AEMFilePathMat);
                set(hPreProList(106),'userdata',AEMFilePathMat);
                OldEstFileMat = get(hPreProList(107),'userdata');
                EstFileMat = char(OldEstFileMat,EstFileMat);
                set(hPreProList(107),'userdata',EstFileMat);
            
            end
            
        end
        if CreateBatchfileStatus
            PrePro('CreateEditingBatchfiles');
        end
        
        fprintf(1,'\n');
        fprintf(1,['-----------------------------------------------------\n']);
        fprintf(1,['Preprocessing done.\n']);
        
        
        
    end
        
%============================================================================
%=========== AllForOne OneForAll =========================================
%============================================================================     
elseif  strcmp(action,'AllForOne') | strcmp(action,'OneForAll')
        
    hPreProList=get(hPreProMenuFig,'Userdata'); 
    if strcmp(action,'AllForOne') 
        set(hPreProList(96),'Value',0);
        set(hPreProList(97),'Value',1);
    else
        set(hPreProList(96),'Value',1);
        set(hPreProList(97),'Value',0);
    end
    
%============================================================================
%=========== CreateEditingBatchfiles =========================================
%============================================================================     
elseif  strcmp(action,'CreateEditingBatchfiles') 
        
    hPreProList=get(hPreProMenuFig,'Userdata'); 
        
    [AemArFileMat]=get(hPreProList(106),'userdata');
    [EstFileMat]=get(hPreProList(107),'userdata');
    fprintf(1,['Paths of created *.AEM.AR-files:']);
    for i =1: size(AemArFileMat,1)
        fprintf(1,'%c',AemArFileMat(i,:));
        fprintf(1,'\n');
    end
    fprintf(1,['Paths of created *.Xest-files:']);
    for i =1: size(EstFileMat,1)
        fprintf(1,'%c',EstFileMat(i,:));
        fprintf(1,'\n');
    end
%============================================================================
%=========== AutoViewDefaultFile =========================================
%============================================================================     
elseif  strcmp(action,'AutoViewDefaultFile')      
        
    hPreProList=get(hPreProMenuFig,'Userdata'); 
    
    
    
%============================================================================
%=========== ReadViewDefaultFile =========================================
%============================================================================     
elseif  strcmp(action,'ReadViewDefaultFile')   
      
    if ~isempty(varargin)
         viewdeffile = varargin{1};
         [viewdeffilename,viewdeffilepath] = SepFilePath(viewdeffile);
    else
        basepath = strrep(which('emegs2d.m'),'emegs2d.m',['emegs2dUtil',filesep,'ViewDefault',filesep]);
        [viewdeffilename,viewdeffilepath] = uigetfile([basepath,'*.ppr'],'Please choose view default file:');
        if isequal(viewdeffilename,0)| isequal(viewdeffilepath,0)
            return
        end
        viewdeffile = [viewdeffilepath,viewdeffilename] ;
    end

    load(viewdeffile,'-mat','SampRate','PreTrig','PostTrig','ArtifactStart','ArtifactStop','LowPassStatus','HighPassStatus',...
        'StopStatus','StopFiltFStop','StopFiltFPass','StopFiltType','StopFiltOrder','LowFiltRPStop',...
        'LowFiltRPass','LowFiltFStop','LowFiltFPass','LowFiltType','LowFiltOrder','HighFiltRPStop',...
        'HighFiltRPass','HighFiltFStop','HighFiltFPass','HighFiltType','HighFiltOrder','StopDefFreqsMat',...
        'StopDefRipMat','HighDefFreqsMat','HighDefRipMat','LowDefFreqsMat','LowDefRipMat','UseSpecConVecStatus',...
        'SpecConVec','RemoveARChannelsStatus','CalcWithARStatus','CalcWithoutARStatus','FindBadChanStatus',...
        'FindBadChanTrialStatus','ChangeRawTawStatus','NFiles','FileMat','LowCoeffCell',...
        'HighCoeffCell','StopCoeffCell','NChan','SampRate','AllForOneStatus','DataFormat','CreateBatchfileStatus','ContinueIfError');
        
    hPreProList=get(hPreProMenuFig,'Userdata'); 
    
    
    set(hPreProList(108),'Value',ContinueIfError);
    
    set(hPreProList(97),'Value',AllForOneStatus);
    set(hPreProList(96),'Value',~AllForOneStatus);
    
    set(hPreProList(91),'String',num2str(NChan));
    set(hPreProList(56),'String',num2str(SampRate));
    
    set(hPreProList(100),'Value',NFiles);
    set(hPreProList(100),'Userdata',FileMat);  
    set(hPreProList(56),'userdata',SampRate);
    PrePro('EnableFilterChoice');
    
	set(hPreProList(14),'String',num2str(LowFiltRPStop));
	set(hPreProList(12),'String',num2str(LowFiltRPass));
	set(hPreProList(10),'String',num2str(LowFiltFStop));
	set(hPreProList(8),'String',num2str(LowFiltFPass));
	set(hPreProList(6),'String',LowFiltType);
    set(hPreProList(2),'Value',LowPassStatus);
	set(hPreProList(2),'userdata',LowCoeffCell);
    PrePro('EnableLowPass',1);
    
 	set(hPreProList(36),'String',num2str(StopFiltOrder));
    set(hPreProList(37),'String',num2str(StopFiltFStop));
 	set(hPreProList(35),'String',num2str(StopFiltFPass));
 	set(hPreProList(33),'String',StopFiltType);
    set(hPreProList(30),'Value',StopStatus);
	set(hPreProList(30),'userdata',StopCoeffCell);
    PrePro('EnableStop',1);
    
	set(hPreProList( 4),'String',num2str(LowFiltOrder));
	set(hPreProList(28),'String',num2str(HighFiltRPStop));
	set(hPreProList(26),'String',num2str(HighFiltRPass));
	set(hPreProList(24),'String',num2str(HighFiltFStop));
	set(hPreProList(22),'String',num2str(HighFiltFPass));
	set(hPreProList(20),'String',HighFiltType);
	set(hPreProList(18),'String',num2str(HighFiltOrder));
    set(hPreProList(16),'Value',HighPassStatus);
	set(hPreProList(16),'userdata',HighCoeffCell);
    PrePro('EnableHighPass',1);
    
    
    set(hPreProList(41),'String',num2str(PreTrig));
    PrePro('SetPreTrig');
    set(hPreProList(42),'String',num2str(PostTrig));
    PrePro('SetPostTrig');
    
    set(hPreProList(46),'String',num2str(ArtifactStart));
    set(hPreProList(47),'String',num2str(ArtifactStop));
    set(hPreProList(45),'String',num2str(SpecConVec));
    set(hPreProList(44),'Value',UseSpecConVecStatus);
    PrePro('SetSpecConditionVec')
    
    set(hPreProList(78),'Value',RemoveARChannelsStatus);
    set(hPreProList(76),'Value',CalcWithARStatus);
    set(hPreProList(75),'Value',CalcWithoutARStatus);
    set(hPreProList(73),'Value',FindBadChanStatus);
    set(hPreProList(74),'Value',FindBadChanTrialStatus);
    
    set(hPreProList(78),'Value',ChangeRawTawStatus); 
    
    if strcmp(DataFormat,'RAW')
        set(hPreProList(58),'checked','on');
        set(hPreProList(59),'checked','off');
        set(hPreProList(60),'checked','off');
    elseif strcmp(DataFormat,'CNT')
        set(hPreProList(58),'checked','off');
        set(hPreProList(59),'checked','on');
        set(hPreProList(60),'checked','off');
    elseif strcmp(DataFormat,'BTI')
        set(hPreProList(58),'checked','off');
        set(hPreProList(59),'checked','off');
        set(hPreProList(60),'checked','on');
    end
    
    set(hPreProList(94),'Value',CreateBatchfileStatus);
    
%============================================================================
%=========== SaveViewDefaultFile =========================================
%============================================================================     
elseif  strcmp(action,'SaveViewDefaultFile')      
    
     hPreProList=get(hPreProMenuFig,'Userdata'); 
    
  
    CreateBatchfileStatus = get(hPreProList(94),'Value');
    SampRate = get(hPreProList(56),'userdata');
    PreTrig = str2num(get(hPreProList(41),'String'));
    PostTrig = str2num(get(hPreProList(42),'String'));
    ArtifactStart = str2num(get(hPreProList(46),'String'));
    ArtifactStop = str2num(get(hPreProList(47),'String'));
    LowPassStatus =  get(hPreProList(2),'Value');
    HighPassStatus =  get(hPreProList(16),'Value');
    StopStatus =  get(hPreProList(30),'Value');
    StopFiltFStop   = str2num(get(hPreProList(37),'String'));
 	StopFiltFPass   = str2num(get(hPreProList(35),'String'));
 	StopFiltType    = get(hPreProList(33),'String');
 	StopFiltOrder   = str2num(get(hPreProList(36),'String'));
	LowFiltRPStop   = str2num(get(hPreProList(14),'String'));
	LowFiltRPass    = str2num(get(hPreProList(12),'String'));
	LowFiltFStop    = str2num(get(hPreProList(10),'String'));
	LowFiltFPass    = str2num(get(hPreProList(8),'String'));
	LowFiltType     = get(hPreProList(6),'String');
	LowFiltOrder    = str2num(get(hPreProList( 4),'String'));
	HighFiltRPStop  = str2num(get(hPreProList(28),'String'));
	HighFiltRPass   = str2num(get(hPreProList(26),'String'));
	HighFiltFStop   = str2num(get(hPreProList(24),'String'));
	HighFiltFPass   = str2num(get(hPreProList(22),'String'));
	HighFiltType    = get(hPreProList(20),'String');
	HighFiltOrder   = str2num(get(hPreProList(18),'String'));
    StopDefFreqsMat=[SampRate StopFiltFPass StopFiltFStop];
	StopDefRipMat=[3 5];
    HighDefFreqsMat=[SampRate HighFiltFPass HighFiltFStop];
	HighDefRipMat=[HighFiltRPass HighFiltRPStop];
	LowDefFreqsMat=[SampRate LowFiltFPass LowFiltFStop]; 
	LowDefRipMat=[LowFiltRPass LowFiltRPStop];
	LowCoeffCell = get(hPreProList(2),'userdata');
	HighCoeffCell = get(hPreProList(16),'userdata');
	StopCoeffCell = get(hPreProList(30),'userdata');
    UseSpecConVecStatus  = get(hPreProList(44),'Value');
    SpecConVec = num2str(get(hPreProList(45),'String'));
    RemoveARChannelsStatus =  get(hPreProList(78),'Value');
    CalcWithARStatus =  get(hPreProList(76),'Value');
    CalcWithoutARStatus =  get(hPreProList(75),'Value');
    FindBadChanStatus =  get(hPreProList(73),'Value');
    FindBadChanTrialStatus =  get(hPreProList(74),'Value');
    ChangeRawTawStatus =  get(hPreProList(78),'Value');
    NChan = str2num(get(hPreProList(91),'String'));
    SampRate = str2num(get(hPreProList(56),'String'));
    AllForOneStatus = get(hPreProList(97),'Value');
    ContinueIfError = get(hPreProList(108),'Value');
    
    NFiles = get(hPreProList(100), 'Value');
    FileMat = get(hPreProList(100),'Userdata');
    if strcmp(get(hPreProList(58),'checked'),'on')
        DataFormat = 'RAW';
    elseif strcmp(get(hPreProList(59),'checked'),'on')
        DataFormat = 'CNT';
    elseif strcmp(get(hPreProList(60),'checked'),'on')
        DataFormat = 'BTI';
    end
    
    if ~isempty(varargin)
         viewdeffile = varargin{1};
         [viewdeffilename,viewdeffilepath] = SepFilePath(viewdeffile);
    else
        basepath = strrep(which('emegs2d.m'),'emegs2d.m',['emegs2dUtil',filesep,'ViewDefault',filesep]);
        [viewdeffilename,viewdeffilepath] = uiputfile([basepath,'*.ppr'],'Please name new view default file:');
        if isequal(viewdeffilename,0)| isequal(viewdeffilepath,0)
            return
        end
        viewdeffile = [viewdeffilepath,viewdeffilename] ;
        if isempty(findstr(viewdeffile,'.mat')) & isempty(findstr(viewdeffile,'.ppr'))
           viewdeffile =[viewdeffile,'.ppr'];
        end
        if ~isempty(findstr(viewdeffile,'.mat'))
           viewdeffile =strrep(viewdeffile,'.mat','.ppr');
        end
    end
    
    save(viewdeffile,'SampRate','PreTrig','PostTrig','ArtifactStart','ArtifactStop','LowPassStatus','HighPassStatus',...
        'StopStatus','StopFiltFStop','StopFiltFPass','StopFiltType','StopFiltOrder','LowFiltRPStop',...
        'LowFiltRPass','LowFiltFStop','LowFiltFPass','LowFiltType','LowFiltOrder','HighFiltRPStop',...
        'HighFiltRPass','HighFiltFStop','HighFiltFPass','HighFiltType','HighFiltOrder','StopDefFreqsMat',...
        'StopDefRipMat','HighDefFreqsMat','HighDefRipMat','LowDefFreqsMat','LowDefRipMat','UseSpecConVecStatus',...
        'SpecConVec','RemoveARChannelsStatus','CalcWithARStatus','CalcWithoutARStatus','FindBadChanStatus',...
        'FindBadChanTrialStatus','ChangeRawTawStatus','NFiles','FileMat','LowCoeffCell','HighCoeffCell',...
        'StopCoeffCell','NChan','SampRate','AllForOneStatus','DataFormat','CreateBatchfileStatus','ContinueIfError');
    
%============================================================================
%=========== unrecognized action  ===========================================
%============================================================================
else
  	disp(sprintf('PrePro: action string ''%s'' not recognized, no action taken.',action))
end	





return;
