function [ParaMat,PicName,VarName] = ReadIAPSParaMat(FilePath,NPic,DefaultPath,filterSpec)
%	ReadIAPSParaMat.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  

if nargin<4;filterSpec=[];end;
if nargin<3;DefaultPath=[];end
if nargin<2;NPic=[];end
if nargin<1;FilePath=[];end

if isempty(filterSpec); filterSpec='*ParaMat*'; end
NVar=206;
File=[];
Path=[];
[File,Path,FilePath]=ReadFilePath(FilePath,filterSpec,'Open IAPSParaMat file:');
fid=fopen(FilePath,'r');
if fid<3
	fprintf('Can not find the file:\n\n');
	PrintFilePath(FilePath); 
	fprintf('  !!\n\n\n');
	FilePath=[];
	return;
end

fprintf('Start reading data from file\n\n'); 
PrintFilePath(FilePath);
fprintf('\n\n'); 
VarName=char(fscanf(fid,'%s',1));
VarName=char(fscanf(fid,'%s',1));
for i=1:NVar-1	
	VarName=char(VarName,fscanf(fid,'%s',1));
end
ParaMat=zeros(NVar,NPic);
for i=1:NPic
	if i==1
		PicName=char(fscanf(fid,'%s',1));
	else
		PicName=char(PicName,fscanf(fid,'%s',1));
	end
 	ParaMat(:,i)=fscanf(fid,'%g',[NVar,1]);
end
fprintf('End reading data from file...\n\n'); 
fclose(fid);	
ParaMat=ParaMat';	
return;
