function [Data,File,Path,FilePath,SizeData] = ReadMfx(FilePath,String,offset,origin,DefaultPath,filterSpec,SizeData)
%	ReadMfx.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.    

if nargin<7;SizeData=[];end;
if nargin<6;filterSpec=[];end;
if nargin<5;DefaultPath=[];end
if nargin<4;origin=[];end
if nargin<3;offset=[];end
if nargin<2;String=[];end
if nargin<1;FilePath=[];end

NChan=8;
offset=2584;

if isempty(offset); offset=0; end
if isempty(origin); origin=-1; end
if isempty(filterSpec); filterSpec='*.mfx*'; end

Data=[];
File=[];
Path=[];
[DefPath]=SetDefPath(1,filterSpec);
[File,Path,FilePath]=ReadFilePath(FilePath,DefPath,String);
SetDefPath(2,Path);
if File==0; Data=[]; File=[]; Path=[]; FilePath=[]; SizeData=[]; return; end
fid=fopen(FilePath,'r','b');
if fid<3
	fprintf('Can not find the file:\n\n');
	PrintFilePath(FilePath); 
	fprintf('  !!\n\n\n');
	FilePath=[];
	return;
end

fprintf('Start reading data from file\n\n'); 
PrintFilePath(FilePath);
fprintf('\n\n'); 

if isempty(origin); origin=-1; end
if isempty(offset); offset=0; end

fseek(fid,offset,origin);
[Data,Count]=fread(fid,'int16');
NPoints=Count/NChan;
Data=reshape(Data,NChan,NPoints);
fprintf('End reading data from file...\n\n'); 
fclose(fid);	
SizeData=[NChan,NPoints];
return;
