function  [File,Path,FilePath,GenderVal,MovieFunction,NCycle,
 	NPicPerCycle,SortByValStatus,SortByAroStatus,SortByRGBHSVStatus,
 	ColorBlackWhite,BrightStatus,UseRandPermStatus,UseExtraRatingStatus,
 	StartPic,CorrectValAroStatus,SizeMovieLogMat,MovieLogMat]=ReadMovieLogFile(FilePath);
 	
%	ReadMovieLogFile.m
 	
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.     

if nargin<1 | isempty(FilePath)
	PathTmp=what('Geo');
	if length(PathTmp)~=0
		Path=getfield(PathTmp,'path');
		if strcmp(Path(length(Path)),FileSep); Path=Path(1:length(Path)-1); end
		FileMask=[Path,FileSep,'*MovLog*'];
	else
		FileMask=['*MovLog*'];
	end
	[File,Path]=uigetfile(FileMask,'Look for MovLog file:');
	if File==0; return; end
	FilePath=[Path,File];
else
	[File,Path]=SepFilePath(FilePath);
end
fid=fopen(FilePath,'r');
if fid==-1; return; end
fprintf('Read movie log file:\n')
fprintf(FilePath);
GenderVal=fscanf(fid,'%g',1); 			
MovieFunction=fscanf(fid,'%g',1);		
NCycle=fscanf(fid,'%g',1);				
NPicPerCycle=fscanf(fid,'%g',1);		
SortByValStatus=fscanf(fid,'%g',1);		
SortByAroStatus=fscanf(fid,'%g',1);		
SortByRGBHSVStatus=fscanf(fid,'%g',1);	
ColorBlackWhite=fscanf(fid,'%g',1); 	
BrightStatus=fscanf(fid,'%g',1);		
UseRandPermStatus=fscanf(fid,'%g',1);	
UseExtraRatingStatus=fscanf(fid,'%g',1);	
StartPic=fscanf(fid,'%g',1);
CorrectValAroStatus=fscanf(fid,'%g',1);	
NonUse=fscanf(fid,'%g',87);
SizeMovieLogMat=fscanf(fid,'%g',[1 2]);
MovieLogMat=fscanf(fid,'%g',SizeMovieLogMat);
fclose(fid);
return;
