function[Header,File,Path,FilePath]=ReadNetData(FilePath,Header,DispHeader)

%	ReadNetData.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.      

if nargin<3; DispHeader=1; end;
if nargin<2; Header=[]; end;
if nargin<1; FilePath=[]; end;
if ~isempty(Header); File=[]; Path=[];FilePath=[]; return; end;

[File,Path,FilePath]=ReadFilePath(FilePath,'*.RAW*','Choose NetStation RAW file:');
if File==0; return; end
global Header
global LHeader
global Version
global Year
global Month
global Day
global Hour
global Minute
global Sec
global MSec
global SampRate
global NChan
global NGain
global Bits
global Range
global NPoints
global NEvents
global EventCodes


fprintf('\n')
clc;
fprintf('Start reading data file...\n\n');
fprintf(FilePath);
fprintf('\n\n');

fid=fopen(FilePath,'r','b');
Version=fread(fid,1,'long');
Year=fread(fid,1,'short');
Month=fread(fid,1,'short');
Day=fread(fid,1,'short');
Hour=fread(fid,1,'short');
Minute=fread(fid,1,'short');
Sec=fread(fid,1,'short');
MSec=fread(fid,1,'long');
SampRate=fread(fid,1,'short');
NChan=fread(fid,1,'short');
Gain=fread(fid,1,'short');
Bits=fread(fid,1,'short');
Range=fread(fid,1,'short');
NPoints=fread(fid,1,'long');
NEvents=fread(fid,1,'short');
EventCodes=fread(fid,[NEvents,4],'char')
Tell1=ftell(fid);
LHeader=Tell1;
fseek(fid,0,-1);
Header=fread(fid,LHeader,'int8');
if DispHeader
	Version
	Year
	Month
	Day
	Hour
	Minute
	Sec
	MSec
	SampRate
	NChan
	NGain
	Bits
	Range
	NPoints
	NEvents
	fprintf('EventCodes = \n\n')
	disp(setstr(EventCodes))
	LHeader
	pause
end	
	
fprintf('End reading data header...\n');

pause(1)

%Read trigger channel
global All
All=fread(fid,[NChan+NEvents,NPoints],'int16');
fclose(fid);
size(All)
global StdAll1
StdAll1=std(All(:,1:5000)');
return
for i=0:10
	plot((All(1:10,i.*100+1:(i+1).*100))')
	pause
	clf;
end
return
TrigChan=[NChan+NEvents];
SpecChan=[127];
TrigVecInd=0;
for i=2:NPoints
	if All(TrigChan,i)>0.5 & All(TrigChan,i-1)<0.5
		TrigVecInd=TrigVecInd+1;
		TrigVec(TrigVecInd)=i;
	end
end
TrigVec=TrigVec
TrigVec=[];
TrigVecInd=0;
for i=1:NPoints-1
	if All(TrigChan,i)>0.5 & All(TrigChan,i+1)<0.5
		TrigVecInd=TrigVecInd+1;
		TrigVec(TrigVecInd)=i;
	end
end
TrigVec=TrigVec
pause
PraeStim=200;
PostStim=200;

for i=1:length(TrigVec) 
	if ((TrigVec(i)-PraeStim)>=1)  &  ((TrigVec(i)+PostStim)<=NPoints)
		plot(All(SpecChan,:))
		MaxAbs=max(abs(All(SpecChan,:)));
		hold on
		plot(All(TrigChan,:).*MaxAbs,'--w')
		axis([(TrigVec(i)-PraeStim) (TrigVec(i)+PostStim) -MaxAbs MaxAbs])
		pause
	end
end
return;
