function[GainChanVec,ZeroChanVec,
		GainYear,GainMonth,GainDay,GainHour,GainMinute,GainSec,GainMSec,
		ZeroYear,ZeroMonth,ZeroDay,ZeroHour,ZeroMinute,ZeroSec,ZeroMSec]=ReadNetGainZeroWera(NChan,GainFilePath,ZeroFilePath);

%	ReadNetGainZeroWera.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.     

if nargin<3; ZeroFilePath=[]; end
if nargin<2; GainFilePath=[]; end
if nargin<1; NChan=129; end
GainFid=-1;

[GainFile,GainPath,GainFilePath]=ReadFilePath(GainFilePath,'*.GAIN',['Choose the gain file:  (press Cancel if all gain == 1)']);

if GainFile~=0 
	GainFid=fopen(GainFilePath,'r','b');
	if GainFid==-1; GainFile=0; end
end
if GainFid==-1
	[GainFile,GainPath,GainFilePath]=ReadFilePath([],'*.GAIN',['Choose the gain file:  (press Cancel if all gain == 1)']);
	if GainFile~=0 
		GainFid=fopen(GainFilePath,'r','b');
		if GainFid==-1; GainFile=0; end
	end
end

if GainFile==0

	fprintf('Set all gains==1 !!!')
	pause(.5)
	fprintf('\n');clc;
	GainChanVec=ones(NChan,1);
	GainYear=0;
	GainMonth=0;
	GainDay=0;
	GainHour=0;
	GainMinute=0;
	GainSec=0;
	GainMSec=0;
	
else

	Line=fgetl(GainFid);
	Line=fgetl(GainFid);
	Line=fgetl(GainFid);
	Tmp=findstr(Line,'/');
	GainYear=str2num(Line(Tmp-6:Tmp-5));
	GainMonth=str2num(Line(Tmp-4:Tmp-3));
	GainDay=str2num(Line(Tmp-2:Tmp-1));
	GainHour=str2num(Line(Tmp+1:Tmp+2));
	GainMinute=str2num(Line(Tmp+4:Tmp+5));
	GainSec=str2num(Line(Tmp+7:Tmp+8));
	GainMSec=str2num(Line(Tmp+10:Tmp+12));
	GainChanVec=zeros(NChan,1);
	for ChanInd=1:NChan
		Line=fgetl(GainFid);
		Tmp=findstr(Line,':');
		GainChanVec(ChanInd)=str2num(Line(Tmp+1:length(Line)));
	end
	fclose(GainFid);
end

%=====================================================================
ZeroFid=-1;
[ZeroFile,ZeroPath,ZeroFilePath]=ReadFilePath(ZeroFilePath,'*.ZERO',['Choose the zero file:  (press Cancel if all zero == 0)']);
if ZeroFile~=0 
	ZeroFid=fopen(ZeroFilePath,'r','b');
	if ZeroFid==-1; ZeroFile=0; end
end
if ZeroFid==-1
	[ZeroFile,ZeroPath,ZeroFilePath]=ReadFilePath([],'*.ZERO',['Choose the zero file:  (press Cancel if all zero == 0)']);
	if ZeroFile~=0 
		ZeroFid=fopen(ZeroFilePath,'r','b');
		if ZeroFid==-1; ZeroFile=0; end
	end
end

if ZeroFile==0
	fprintf('Set all zeros==0 !!!');
	pause(.5)
	fprintf('\n');clc;
	ZeroChanVec=ones(NChan,1);
	ZeroYear=0;
	ZeroMonth=0;
	ZeroDay=0;
	ZeroHour=0;
	ZeroMinute=0;
	ZeroSec=0;
	ZeroMSec=0;
else
	Line=fgetl(ZeroFid)
	Line=fgetl(ZeroFid)
	Line=fgetl(ZeroFid)
	Tmp=findstr(Line,'/')
	ZeroYear=str2num(Line(Tmp-6:Tmp-5))
	ZeroMonth=str2num(Line(Tmp-4:Tmp-3))
	ZeroDay=str2num(Line(Tmp-2:Tmp-1))
	ZeroHour=str2num(Line(Tmp+1:Tmp+2))
	ZeroMinute=str2num(Line(Tmp+4:Tmp+5))
	ZeroSec=str2num(Line(Tmp+7:Tmp+8))
	ZeroMSec=str2num(Line(Tmp+10:Tmp+12))
	ZeroChanVec=zeros(NChan,1);
	for ChanInd=1:NChan
		Line=fgetl(ZeroFid);
        if isempty(Line)
            break;
        end
		Tmp=findstr(Line,':');
		ZeroChanVec(ChanInd)=str2num(Line(Tmp+1:length(Line)));
	end
	fclose(ZeroFid);
end
return;
