function [PicFilePath,SaveFilePath]=RenameBmp(PicFilePath)

%	RenameBmp.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  

if nargin<1;PicFilePath=[]; end;
	
if isempty(PicFilePath)
	[PicFile,PicPath]=uigetfile('*', 'Please choose a pic file:');
	PicFilePath=[PicPath,PicFile];
end

NPic=1;
fid=fopen(PicFilePath,'r');
line = fgetl(fid);
PicStr=char(line);
while 1
   line = fgetl(fid);
   if ~isstr(line), break, end
   PicStr=char(PicStr,line);
   NPic=NPic+1;
   disp(line)
end
fclose(fid);
NewPath='Paul:Movies:ValAroPos:ValAroPosBmp:';
OldPath='Paul:Movies:ValAroPos:ValAroPos1Pics:';
for i=1:NPic
	if i<10
		OldFile=['000',int2str(i),'.jpg'];
	elseif i>9 & i<100
		OldFile=['00',int2str(i),'.jpg'];
	elseif i>99 & i<1000
		OldFile=['0',int2str(i),'.jpg'];
	end
	NewFile=[deblank(PicStr(i,:)),'.jpg'];
	OldFilePath=['"' OldPath,OldFile '"']
	CopyResult=applescript('acopy', 'itemName', OldFilePath,'folderName',['"' NewPath '"'])
	OldFilePath=['"' NewPath,OldFile '"']
	NewFile=['"' NewFile '"']
	RenameResult = applescript('arename', 'itemName', OldFilePath, 'newName', NewFile);
end
