%   RenameJpgFastWords.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION. 


NCond=4
NBlock=32
NBlockPerCond=NBlock./NCond
NPics=32
NPicPerBlock=36
                                                                     
ExtraPics=NPicPerBlock-NPics
NSecPerPic=1/3
TotTime=NBlock*NPicPerBlock*NSecPerPic/60
ExtraRandVec1=randperm(NPics);
ExtraRandVec2=randperm(12);
ExtraRandVec=[ExtraRandVec1,ExtraRandVec2];
	
NewPath='Paul:Movies:FastWords:FastWordsfMRI:Movie3Hz:';
InhaPath='Paul:Movies:FastWords:InhaWordJPG:';
InhaBasePath='Paul:Movies:FastWords:InhaBaseWordJPG:';
FunkPath='Paul:Movies:FastWords:FunkWordJPG:';
FunkBasePath='Paul:Movies:FastWords:FunkBaseWordJPG:';
PseuPath='Paul:Movies:FastWords:PseuWordJPG:';
PseuBasePath='Paul:Movies:FastWords:PseuBaseWordJPG:';
StriPath='Paul:Movies:FastWords:StriWordJPG:';
StriBasePath='Paul:Movies:FastWords:StriBaseWordJPG:';

ReadRand=1

if ReadRand
	BlockVec=ReadAscii(['Paul:Movies:FastWords:FastWordsfMRI:Stats:BlockRandFastWordsfMRI'])
	RandMat=ReadAscii(['Paul:Movies:FastWords:FastWordsfMRI:Stats:PicRandFastWordsfMRI'])
	size(RandMat)
else
	a=1;b=1;c=1;
	asq=inf;
	while asq>3
		BlockVec=[1 3 2 4];
		for i=2:NBlockPerCond
			Tmp=BlockVec(length(BlockVec));
			while Tmp(1)==BlockVec(length(BlockVec));
				Tmp=randperm(NCond);
			end
			BlockVec=[BlockVec,Tmp];
		end
		a12=0;a13=0;a14=0;a21=0;a23=0;a24=0;a31=0;a32=0;a34=0;a41=0;a42=0;a43=0;
		for i=2:NBlock
			if BlockVec(i-1)==1 & BlockVec(i)==2
 				a12=a12+1;
			elseif BlockVec(i-1)==1 & BlockVec(i)==3
 				a13=a13+1;
			elseif BlockVec(i-1)==1 & BlockVec(i)==4
 				a14=a14+1;
			elseif BlockVec(i-1)==2 & BlockVec(i)==1
 				a21=a21+1;
			elseif BlockVec(i-1)==2 & BlockVec(i)==3
 				a23=a23+1;
			elseif BlockVec(i-1)==2 & BlockVec(i)==4
 				a24=a24+1;
			elseif BlockVec(i-1)==3 & BlockVec(i)==1
 				a31=a31+1;
			elseif BlockVec(i-1)==3 & BlockVec(i)==2
 				a32=a32+1;
			elseif BlockVec(i-1)==3 & BlockVec(i)==4
 				a34=a34+1;
			elseif BlockVec(i-1)==4 & BlockVec(i)==1
 				a41=a41+1;
			elseif BlockVec(i-1)==4 & BlockVec(i)==2
 				a42=a42+1;
			elseif BlockVec(i-1)==4 & BlockVec(i)==3
 				a43=a43+1;
			end
 		end
		avec=[a12,a13,a14,a21,a23,a24,a31,a32,a34,a41,a42,a43];
		avec=avec-mean(avec);
		asq=sum(avec.^2);
 	end
	a12
	a13
	a14
	a21
	a23
	a24
	a31
	a32
	a34
	a41
	a42
	a43
	asq
	BlockVec=BlockVec
	SaveAscii(BlockVec,['Paul:Movies:FastWords:FastWordsfMRI:Stats:BlockRandFastWordsfMRI'])	
	RandMat=zeros(NBlockPerCond,NPicPerBlock);
	for i=1:NBlockPerCond
		RandMat(i,1:NPics)=randperm(NPics);
		RandMat(i,NPics+1:NPicPerBlock)=ExtraRandVec((i-1).*ExtraPics+1:i.*ExtraPics);
	end
	SaveAscii(RandMat,['Paul:Movies:FastWords:FastWordsfMRI:Stats:PicRandFastWordsfMRI'])
end
% 
% RandBaseVec=[BlockVec]
% CountInhaBase=0;
% CountFunkBase=0;
% CountPseuBase=0;
% CountStriBase=0;
% RandBaseVec=[BlockVec,1 2 3 4]
% for PicInd=1:NPicPerBlock
% 	if RandBaseVec(PicInd)==1		%Inhalt
% 		Path=InhaBasePath;
% 		Str='InhaBase'
% 		CountInhaBase=CountInhaBase+1;
% 		Count=CountInhaBase;
% 	elseif RandBaseVec(PicInd)==2	%Funktion
% 		Path=FunkBasePath;
% 		Str='FunkBase'
% 		CountFunkBase=CountFunkBase+1;
% 		Count=CountFunkBase;
% 	elseif RandBaseVec(PicInd)==3	%Pseudo
% 		Path=PseuBasePath;
% 		Str='PseuBase'
% 		CountPseuBase=CountPseuBase+1;
% 		Count=CountPseuBase;
% 	elseif RandBaseVec(PicInd)==4	%String
% 		Path=StriBasePath;
% 		Str='StriBase'
% 		CountStriBase=CountStriBase+1;
% 		Count=CountStriBase;
% 	end
%  	OldFile=AddZeros2CountStr(Count,2);
% 	OldFile=[Str,OldFile,'.jpg'];
% 	OldFilePath=['"' Path,OldFile '"'];
% 	CopyResult=applescript('acopy','itemName',OldFilePath,'folderName',['"' NewPath '"']);
% 	NewFile=AddZeros2CountStr(PicInd,3)
% 	NewFile=[NewFile,'.jpg'];
% 	CopyFilePath=['"' NewPath,OldFile '"'];
% 	NewFile=['"' NewFile '"'];
% 	RenameResult = applescript('arename','itemName',CopyFilePath,'newName',NewFile);
% 	fprintf('Picture: %g of %g; \n',PicInd,NPicPerBlock);
% 	fprintf('Result of acopy:  '); fprintf(CopyResult); fprintf('\n');
% 	fprintf('Copied File:  '); fprintf(OldFile); fprintf('\n');
% 	fprintf('Result of arename:  '); fprintf(RenameResult); fprintf('\n');
% 	fprintf('Renamed File:  '); fprintf(NewFile); fprintf('\n');
% end
% return
NPic=NBlock*NPicPerBlock
BlockIndStart=1
PicIndTmp=(BlockIndStart+1-1).*NPicPerBlock
InhaBlockInd=0;
FunkBlockInd=0;
PseuBlockInd=0;
StriBlockInd=0;

for BlockInd=BlockIndStart:NBlock
	if BlockVec(BlockInd)==1		%Inhalt
		Path=InhaPath;
		Str='Inha'
		InhaBlockInd=InhaBlockInd+1;
		BlockIndTmp=InhaBlockInd;
	elseif BlockVec(BlockInd)==2	%Funktion
		Path=FunkPath;
		Str='Funk'
		FunkBlockInd=FunkBlockInd+1;
		BlockIndTmp=FunkBlockInd;
	elseif BlockVec(BlockInd)==3	%Pseudo
		Path=PseuPath;
		Str='Pseu'
		PseuBlockInd=PseuBlockInd+1;
		BlockIndTmp=PseuBlockInd;
	elseif BlockVec(BlockInd)==4	%String
		Path=StriPath;
		Str='Stri'
		StriBlockInd=StriBlockInd+1;
		BlockIndTmp=StriBlockInd;
	end
	%PicMatTmp=PicMat(PicIndVec,:)
	for PicInd=1:NPicPerBlock
		PicIndTmp=PicIndTmp+1;
		OldFile=AddZeros2CountStr(RandMat(BlockIndTmp,PicInd),2);
		OldFile=[Str,OldFile,'.jpg'];
		OldFilePath=['"' Path,OldFile '"'];
		CopyResult=applescript('acopy','itemName',OldFilePath,'folderName',['"' NewPath '"']);
		NewFile=AddZeros2CountStr(PicIndTmp,3);
		NewFile=[NewFile,'.jpg'];
		CopyFilePath=['"' NewPath,OldFile '"'];
		NewFile=['"' NewFile '"'];
		RenameResult = applescript('arename','itemName',CopyFilePath,'newName',NewFile);
		fprintf('Total picture: %g of %g; \n',PicIndTmp,NPic);
		fprintf('Picture in block: %g of %g; \n',PicInd,NPicPerBlock);
		fprintf('Block: %g of %g; \n',BlockInd,NBlock);
		fprintf('Result of acopy:  '); fprintf(CopyResult); fprintf('\n');
		fprintf('Copied File:  '); fprintf(OldFile); fprintf('\n');
		fprintf('Result of arename:  '); fprintf(RenameResult); fprintf('\n');
		fprintf('Renamed File:  '); fprintf(NewFile); fprintf('\n');
	end
end
