%   RenameJpgGiessen.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.

NCond=5
NBlockPerCond=20
if NBlockPerCond<10
	NBlockPerCondStr=['0',int2str(NBlockPerCond)];
else
                                                                      
	NBlockPerCondStr=int2str(NBlockPerCond);
end
NPicPerBlock=9
if NPicPerBlock<10
	NPicPerBlockStr=['0',int2str(NPicPerBlock)];
else
	NPicPerBlockStr=int2str(NPicPerBlock);
end
NSecPerPic=4/3
Baseline=12
AroValStr='Neut'
% CondVec=[1]
% for BlockInd=1:NBlockPerCond
% 	RandVec=randperm(NCond)
% 	if RandVec(1)==CondVec(length(CondVec))
% 		Tmp=RandVec(2);
% 		RandVec(2)=RandVec(1);
% 		RandVec(1)=Tmp;
% 	end
% 	CondVec=[CondVec,RandVec];
% end
% CondVec=CondVec
% SaveFilePath=['Paul:Movies:Giessen:ValAro',NPicPerBlockStr,':BlockOrder']
% SaveAscii(CondVec,SaveFilePath)

% RandVec=randperm(NCond*NBlockPerCond)+1
% CondVec=[1,ones(1,NBlockPerCond),2*ones(1,NBlockPerCond),3*ones(1,NBlockPerCond),4*ones(1,NBlockPerCond),5*ones(1,NBlockPerCond)]
% CondVec(2:51)=CondVec(RandVec)

TotTime=Baseline/60+NCond*NBlockPerCond*NPicPerBlock*NSecPerPic/60

BasePath=['Paul:Movies:Giessen:ValAro',NPicPerBlockStr];
AroValStrTmp='NVLA'
OldPath=['Paul:Users:Peter:',AroValStrTmp,'Pics1:']

ReadRand=1
RandFile=['Paul:Movies:Giessen:ValAro',NPicPerBlockStr,':Order:Rand',AroValStr,NPicPerBlockStr,'x',NBlockPerCondStr]
if ReadRand
	RandMat=ReadAscii(RandFile)
else
	Vec100=[1:100];
	IndVec=[1:NPicPerBlock];
	RandMat=zeros(NBlockPerCond,NPicPerBlock);
	for BlockInd=1:NBlockPerCond
		RandVec=randperm(NPicPerBlock);
		if BlockInd>1
			IndVec=IndVec+NPicPerBlock;
			Tmp=find(IndVec>100);
			IndVec(Tmp)=IndVec(Tmp)-100;
		end
		RandMat(BlockInd,:)=IndVec(RandVec);
	end
	SaveAscii(RandMat,RandFile)
end
for i=1:100; 
	a(i)=length(find(RandMat==i)); 
end; 
plot(a)
axis([1 100 0 max(a)+1])

for BlockInd=1:NBlockPerCond
	if BlockInd<10
		BlockIndStr=['0',int2str(BlockInd)];
	else
		BlockIndStr=int2str(BlockInd);
	end
	NewFolder=[AroValStr,BlockIndStr];
	[MkDirStatus,MkDirMsg]=mkdir(BasePath,NewFolder);
	NewPathTmp=[BasePath,filesep,NewFolder,filesep];
	for PicInd=1:NPicPerBlock
		PicIndTmp=RandMat(BlockInd,PicInd);
		PicIndTmp=9+PicIndTmp*2+1; %Hallo; +1 if neutral
		if PicIndTmp<10
			OldFile=['000' int2str(PicIndTmp) '.jpg'];
		elseif PicIndTmp>9 & PicIndTmp<100
			OldFile=['00' int2str(PicIndTmp) '.jpg'];
		elseif PicIndTmp>99 & PicIndTmp<1000
			OldFile=['0' int2str(PicIndTmp) '.jpg'];
		elseif PicIndTmp>999 & PicIndTmp<10000
			OldFile=[int2str(PicIndTmp) '.jpg'];
		end
		OldFilePath=['"' OldPath,OldFile '"'];
		CopyResult=applescript('acopy','itemName',OldFilePath,'folderName',['"' NewPathTmp '"']);
		if PicInd<10
			NewFile=['00' int2str(PicInd) '.jpg'];
		elseif PicInd>9 & PicInd<100
			NewFile=['0' int2str(PicInd) '.jpg'];
		elseif PicInd>99 & PicInd<1000
			NewFile=[int2str(PicInd) '.jpg'];
		end
		CopyFilePath=['"' NewPathTmp,OldFile '"'];
		NewFile=['"' NewFile '"'];
		RenameResult = applescript('arename','itemName',CopyFilePath,'newName',NewFile);
		fprintf('Picture: %g of %g; \n',PicInd,NPicPerBlock);
		fprintf('Result of acopy:  '); fprintf(CopyResult); fprintf('\n');
		fprintf('Copied File:  '); fprintf(OldFile); fprintf('\n');
		fprintf('Result of arename:  '); fprintf(RenameResult); fprintf('\n');
		fprintf('Renamed File:  '); fprintf(NewFile); fprintf('\n');
	end
end
