function[OutFileMat]=ScadsFac(InFileMat,Fac,Ext)

%	ScadsFac

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.   

if nargin<3; Ext=[]; end;
if nargin<2; Fac=0.0683; end;
if nargin<1; InFileMat=[]; end;
%==================================================================
% Bits=10; Range=366; Fac1=Range./(2.^Bits);
% Bits=16; Range=1600; Fac2=Range./(2.^Bits);
% Fac=Fac2./Fac1;

[DefFilePath]=SetDefPath(1,'*');
[NFiles,InFileMat,NonUse,BatchFilePath]=ReadFileNames(InFileMat,DefFilePath,'Choose Avg files:');
[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
SetDefPath(2,BatchPath);
if NFiles==0; OutFileMat=[]; return; end
for FileIndex=1:NFiles
	[File,Path,FilePath]=GetFileNameOfMat(InFileMat,FileIndex);
	[AvgMat,File,Path,FilePath,NTrialAvgVec,StdMat,...
	SampRate,AvgRef,Version,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra]=ReadAvgFile(FilePath);
    AvgMat=AvgMat.*Fac;
	StdMat=StdMat.*Fac;
	MedMedRawVec=MedMedRawVec.*Fac;
	MedMedAvgVec=MedMedAvgVec.*Fac;
	OutFilePath=[FilePath,Ext];
	SaveAvgFile(OutFilePath,AvgMat,NTrialAvgVec,StdMat,SampRate,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra);
	if FileIndex==1
		OutFileMat=char(OutFilePath);
	else
		OutFileMat=char(OutFileMat,OutFilePath);
	end
end
return;
