function [NewFileMat]=ShortenFileNames(FileMat,Str)

%   ShortenFileNames.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<2; Str=[]; end
if nargin<1; FileMat=[]; end

[Str]=IfEmptyInputString('Enter "ShortenString":',[],Str,'l20',1); %'.f.msi'
if isempty(Str); return; end
NStr=length(Str);
   
DefDataFilePath=SetDefPath(1,'*');	
if isempty(FileMat)
	[NFiles,FileMat,VersionString,BatchFilePath]=ReadFileNames([],DefDataFilePath,'Choose one file of target directory:',[],[],[],[],1);
	if NFiles==0; return; end
	[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
	[File,Path]=SepFilePath(deblank(FileMat));
	Tmp=dir(Path);
	NFiles=size(Tmp,1);
	FileMat=char([Path,Tmp(1).name]);
	for i=2:NFiles
		FileMat=char(FileMat,[Path,Tmp(i).name]);
	end
	disp(FileMat)
else
	[NFiles,FileMat,VersionString,BatchFilePath]=ReadFileNames([],DefDataFilePath,'Choose files to rename:');
	if NFiles==0; return; end
	[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
end
SetDefPath(2,BatchPath);

NFileMatStr=size(FileMat,2);
NewFileMat=FileMat;
for FileInd=1:NFiles
	OldFilePath=deblank(FileMat(FileInd,:));
	[File,Path]=SepFilePath(OldFilePath);
	NStrFile=length(File);
	if NStrFile>NStr
		Tmp=findstr(File,Str);
		if ~isempty(Tmp)
			if Tmp(1)==1
				NewFile=File(NStr:NStrFile);
			else
				NewFile=[File(1:Tmp(1)-1),File(Tmp(1)+NStr:NStrFile)];
			end
			NewFilePath=[Path,NewFile];
			arename(OldFilePath,NewFilePath);
			NewFileMat(FileInd,1:length(NewFilePath))=NewFilePath;
			for i=length(NewFilePath)+1:NFileMatStr
				NewFileMat(FileInd,i)=' ';
			end
		end
	end
end
disp(NewFileMat)
return;
