%   Test.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.

	RepMat=[1 2 3 4;0 1 2 3; 1 2 3 4]'
        [NSub,NCond]=size(RepMat)
        Weights=[-1 0 1]
        %Berechnung von Mean square contrast
        SumRepMat = sum(RepMat(:,:))%summierte ueber Vps 
        SumWeights2=sum(Weights.^2)
        L=sum(SumRepMat.*Weights)
        L2=L.^2     
        MScont=L2/(NSub.*SumWeights2)
        
        %Corrections of data matrix for Grand Mean     
        corGM=RepMat-mean(mean(RepMat))
        
        %for row effect    
        rowef=mean(corGM,2)  
        for CondInd=1:NCond
            corGMR(1:NSub,CondInd)=corGM(1:NSub,CondInd)-rowef;
        end  
        corGMR
        
        corGMR=corGM-mean(corGM,2)*ones(1,NCond)
        pause
        %for column effect 
        colef = mean(corGMR,1)
        for SubInd =1:NSub
            corGMRC(SubInd,1:NCond)=corGMR(SubInd,1:NCond)-colef;
        end
        corGMRC
        corGMRC=corGMR-ones(NSub,1)*mean(corGMR,1)
        pause
        %sum of squares for condition x subjects
        %this is used as error term for calculation of F. one also could
        %calculate seperate error terms for each trend type. see Rosnow &
        %Rosenthal for details. the approach here is sufficient in most cases.
        
        SScs=sum(sum(corGMRC.^2))
        dfcs=NSub.*(NCond-1)
        MScs=SScs./dfcs
        Fcont=MScont./MScs
        Tcont=L/sqrt(SScs.*SumWeights2)
        PFN=fcdf(Fcont,1,dfcs)
        if Tcont>=0
            Pcont=tcdf(Tcont,dfcs)
        else
            Pcont=-tcdf(-Tcont,dfcs)
        end
        Pcont=Pcont
        %Calculat effect size r(contrast). Use of df of pooled error term will lead
        %to underestimation of effect size. df has to be divided by factor number
        %of conditions minus one.
        R=sqrt(Fcont/(Fcont+(dfcs/(NCond-1))))