function[TransFileMat,TRStatusOut]=TransRawTaw(FileMat,TRStatus,MaxMemory,Sample,SkipStepStatus);

%   TransRawTaw

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<5; SkipStepStatus = 0;end
if nargin<4; Sample=[]; end;
if nargin<3; MaxMemory=10; end;
if nargin<2; TRStatus=[]; end;
if nargin<1; FileMat=[]; end;

[TRStatus]=IfEmptyInputSpecVal(TRStatus,[-1 1],1,...
'Please insert in which way you want to change the files:\n',...
'RAW => TAW                   [ 1]',...
'TAW => RAW                   [-1]');

if TRStatus==1
	[NFiles,FileMat]=ReadFileNames(FileMat,'*.RAW','Choose NetStation RAW file:',[],[],0);
	TRStatusOut=-1;
elseif TRStatus==-1
	[NFiles,FileMat]=ReadFileNames(FileMat,'*.TAW','Choose NetStation TAW file:',[],[],0);
	TRStatusOut=1;
end
if TRStatus==1; PutExt='TAW'; elseif TRStatus==-1; PutExt='RAW'; end
[TransFileMat]=FileNameExt2Mat(FileMat,PutExt,3);
	
for FileIndex=1:NFiles
	
	if 	TRStatus==1			%RAW =>TAW
	
		[RAWFile,RAWPath,RAWFilePath]=GetFileNameOfMat(FileMat,FileIndex);
		if RAWFile==0; return; end;
		[TAWFile,TAWPath,TAWFilePath]=GetFileNameOfMat(TransFileMat,FileIndex);

		RAWFid=fopen(RAWFilePath,'r','b');
		TAWFid=fopen(TAWFilePath,'r','b');
		if TAWFid~=-1; fclose(TAWFid); 
            if SkipStepStatus; 
                fprintf(1,'changing of file format skipped: changed file exists ! \n');
                fclose(RAWFid);
                pause(0.5);
                continue;
            end;
            TAWFid=fopen(TAWFilePath,'r+','b');
        else;
            TAWFid=fopen(TAWFilePath,'w','b');
        end
		fseek(RAWFid,22,-1);
		NChan=fread(RAWFid,1,'short');
		fseek(RAWFid,6,0);
		NPoints=fread(RAWFid,1,'long');
		NEvents=fread(RAWFid,1,'short');
		NTotChan=NChan+NEvents;
		fseek(RAWFid,NEvents.*4,0);
		LHeader=ftell(RAWFid);
		LRawFile=LHeader+NTotChan.*NPoints.*2;
		fseek(RAWFid,0,-1);
		Header=[];
		Header=fread(RAWFid,LHeader,'int8');
		fwrite(TAWFid,Header,'int8');	
		MaxSizePoints=floor(MaxMemory.*1000000./(NTotChan.*8));
		NLoops=max([1,floor((NPoints./MaxSizePoints))]);
		RestPoints=NPoints-NLoops.*MaxSizePoints;

		if NLoops==1
			[DataMat,Count]=fread(RAWFid,[NTotChan,NPoints],'int16');
			Count=fwrite(TAWFid,DataMat','int16');
			if Count~=NTotChan.*NPoints; error('Count~=NTotChan.*NPoints in TransRawTaw'); end
		else
			fseek(TAWFid,LHeader,-1);
			fseek(RAWFid,LHeader,-1);
			DataMat=[];
			ZeroVec=zeros(NPoints-MaxSizePoints,1);
			for LoopInd=1:NLoops
				fprintf(1,'Changing file format from *.RAW to *.TAW: %g of %g total loops done !',LoopInd,NLoops);
				fprintf('\n');
				DataMat=fread(RAWFid,[NTotChan,MaxSizePoints],'int16');
				SeekStatus=fseek(TAWFid,LHeader+(LoopInd-1).*MaxSizePoints.*2,-1);
				
				for ChanInd=1:NTotChan
					fwrite(TAWFid,DataMat(ChanInd,:),'int16');
					if ChanInd~=NTotChan
						SeekStatus=fseek(TAWFid,(NPoints-MaxSizePoints).*2,0);
						if SeekStatus==-1;
							fwrite(TAWFid,ZeroVec,'int16');
						end 				
					end
				end
			end
			if RestPoints>0
				DataMat=[];
				DataMat=fread(RAWFid,[NTotChan,RestPoints],'int16');
				fseek(TAWFid,LHeader+NLoops.*MaxSizePoints.*2,-1);
				for ChanInd=1:NTotChan
					fwrite(TAWFid,DataMat(ChanInd,:),'int16');
					if ChanInd~=NTotChan
						SeekStatus=fseek(TAWFid,(NPoints-RestPoints).*2,0);
						if SeekStatus==-1; error('seekerror'); end
					end
				end
			end
		end
	
	elseif TRStatus==-1
		
		[TAWFile,TAWPath,TAWFilePath]=GetFileNameOfMat(FileMat,FileIndex);

		if TAWFile==0; return; end;
		[RAWFile,RAWPath,RAWFilePath]=GetFileNameOfMat(TransFileMat,FileIndex);

		TAWFid=fopen(TAWFilePath,'r','b');
		RAWFid=fopen(RAWFilePath,'r','b');
		if RAWFid~=-1; fclose(RAWFid); RAWFid=fopen(RAWFilePath,'r+','b'); else; RAWFid=fopen(RAWFilePath,'w','b'); end		
		fseek(RAWFid,22,-1);
		NChan=fread(TAWFid,1,'short');
		fseek(TAWFid,6,0);
		NPoints=fread(TAWFid,1,'long');
		NEvents=fread(TAWFid,1,'short');
		NTotChan=NChan+NEvents;
		fseek(TAWFid,NEvents.*4,0);
		LHeader=ftell(TAWFid);
		LTawFile=LHeader+NTotChan.*NPoints.*2;
		fseek(TAWFid,0,-1);
		Header=[];
		Header=fread(TAWFid,LHeader,'int8');
		fwrite(RAWFid,Header,'int8');		
		MaxSizePoints=floor(MaxMemory.*1000000./(NTotChan.*2));
		NLoops=floor((NPoints./MaxSizePoints));
		RestPoints=NPoints-NLoops.*MaxSizePoints;

		if NLoops==1
			DataMat=fread(TAWFid,[NPoints,NTotChan],'int16');
			fwrite(RAWFid,DataMat','int16');
		else
			ZeroVec=zeros(NTotChan.*MaxSizePoints,1);
			for LoopInd=1:NLoops
				fprintf('\n');
				fprintf(1,'%g of %g total loops done !',LoopInd,2.*NLoops);
				fwrite(RAWFid,ZeroVec,'int16');
			end
			ZeroVec=zeros(NTotChan.*RestPoints,1);
			if RestPoints>0
				fwrite(RAWFid,ZeroVec,'int16');
			end
			fseek(TAWFid,LHeader,-1);
			fseek(RAWFid,LHeader,-1);
			for LoopInd=1:NLoops
				fprintf('\n');
				fprintf(1,'%g of %g total loops done !',LoopInd+NLoops,2.*NLoops);
				DataMat=fread(TAWFid,[MaxSizePoints,NTotChan],'int16');
				fwrite(RAWFid,DataMat','int16');
			end
			if RestPoints>0
				DataMat=fread(TAWFid,[RestPoints,NTotChan],'int16');
				fwrite(RAWFid,DataMat','int16');
			end
		end
	end

	%fseek(TAWFid,LHeader+(NTotChan-1).*NPoints.*2,-1);
	%DataVec=fread(TAWFid,NPoints,'int16');	
	%plot(DataVec)
	
	fclose(RAWFid);
	fclose(TAWFid);

end
return;
