function [] = WriteMat2At(Mat,FilePath,ShiftDimOrder,SampRate,AvgRefStatus,EegMegStatus,NChanExtra)

%	WriteMat2At.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION. 

if nargin<7; NChanExtra=0; end
if nargin<6; EegMegStatus=1; end
if nargin<5; AvgRefStatus=1; end
if nargin<4; SampRate=125; end
if nargin<3; ShiftDimOrder=[]; end
if nargin<2; FilePath=[]; end
if nargin<1; Mat=[]; end
if isempty(Mat) | length(size(Mat))~=3
	return; 
else
	[NTrials,NChan,NPoints]=size(Mat);
end
if ~isempty(ShiftDimOrder)
	Mat=shiftdim(Mat,ShiftDimOrder);
end
fprintf(1,'Write %g trials containing %g sensors and %g points to file:\n\n',NTrials,NChan,NPoints);
Message=char(['Write ' int2str(NTrials) ' trials containing ' int2str(NChan) ' channels and ' int2str(NPoints) ' points to file:']);
Message=char(Message,[]);
Message=char(Message,FilePath);
hmsgbox=msgbox(Message,'Info:','help');
pause(.001);
for TrialInd=1:NTrials
	fprintf(1,'%g\n',TrialInd)	
	TrialFilePath=[FilePath,int2str(TrialInd)];
	SaveAvgFile(TrialFilePath,squeeze(Mat(TrialInd,:,:)),ones(NChan,1),zeros(NChan,NPoints),SampRate,1,1,EegMegStatus,NChanExtra);
end
return;

	
