function  [File,Path,FilePath]=WriteMovieLogFile(FilePath,...
	GenderVal,MovieFunction,NCycle,NPicPerCycle,SortByValStatus,...
	SortByAroStatus,SortByRGBHSVStatus,ColorBlackWhite,BrightStatus,...
	UseRandPermStatus,UseExtraRatingStatus,StartPic,SizeMovieLogMat,MovieLogMat);
	
%	WriteMovieLogFile.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.   

if nargin<15; File=0; return; end
if isempty(FilePath)
	PathTmp=what('Geo');
	if length(PathTmp)~=0
		Path=getfield(PathTmp,'path');
		if strcmp(Path(length(Path)),FileSep); Path=Path(1:length(Path)-1); end
		FileMask=[Path,FileSep,'*MovLog*'];
	else
		FileMask=['*MovLog*'];
	end
	[File,Path]=uiputfile(FileMask,'Write MovLog to file:');
	if File==0; return; end
	FilePath=[Path,File];
end
fid=fopen(FilePath,'w');
if fid==-1; return; end
Message=char('Save MovLog to file:');
Message=char(Message,' ');
Message=char(Message,FilePath);
hmsgbox=msgbox(Message,'Info:','help');
fprintf(fid,'%g\n',GenderVal); 
fprintf(fid,'%g\n',MovieFunction); 
fprintf(fid,'%g\n',NCycle); 
fprintf(fid,'%g\n',NPicPerCycle); 
fprintf(fid,'%g\n',SortByValStatus); 
fprintf(fid,'%g\n',SortByAroStatus); 
fprintf(fid,'%g\n',SortByRGBHSVStatus); 
fprintf(fid,'%g\n',ColorBlackWhite); 
fprintf(fid,'%g\n',BrightStatus); 
fprintf(fid,'%g\n',UseRandPermStatus); 
fprintf(fid,'%g\n',UseExtraRatingStatus);
fprintf(fid,'%g\n',StartPic);		 
fprintf(fid,'%g\n',zeros(88,1));
fprintf(fid,'%g\n',SizeParaParaMat);
fprintf(fid,'%g\n',MovieLogMat);
fclose(fid);	
return;
