function emegs
%   emegs - opens the launchpad that allows to start
%   all emegs-modules. Each modul can be launched as well by 
%   typing the following commands:
%   
%   prepro                  -   preprocessing
%   editaem                 -   artifact detection
%   emegsavg                -   averaging
%   emegs2d                 -   visualization, statistics, source localization
%   eeg2spm                 -   EEG/MEG SPM
%   waveapp                 -   Wavelet
%   emegs2d;gensynthdata    -   synthetic data
%
%   See also EMEGS2D, EMEGS3D, EMEGSAVG, PREPRO, EDITAEM, WAVEAPP, GENSYNTHDATA.

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004  Markus Junghfer & Peter Peyk
%                   Contributors: Andrea de Cesarei, Thomas Gruber,                   
%                   Olaf Hauk, Andreas Keil, Nathan Weisz.  
%   
%   All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.   



clc;
home;
fprintf(1,'\n');
disp( '  ____  __  __  ____  ___  ___                                              ')
disp( ' | __ )|  \/  || ___)| __ / __)   Electro Magneto EncephaloGraphy Software ')
disp( ' | __) |      || __) | _ |\__ \   ------------------------------------------')
disp( ' |____)|_|\/|_||____)|___|/___/   http://www.uni-konstanz.de/win/emegs/     ')
%=======================
% figure
%=======================
h = figure(...
'units','normalized',...
'position',[0.3           0.3         0.32      0.4],...
'color',[0           0        0.38],...
'Name','EMEGS launchpad',...
'Numbertitle','off',...
'Resize','on',...
'Menubar','none',...
'units','characters',...
'tag','emegslaunchpad');


%=======================
% logo axes
%=======================
axes(...
'units','normalized',...
'position',[0.03     0.57         0.94      0.4],...
'color',[0 0 0.38],...
'XColor',[0 0 0.38],...
'YColor',[0 0 0.38]);
pic = imread([strrep(which('emegs.m'),'emegs.m','logo.jpg')],'jpg');
image(pic);
axis off;

%=======================
% copyright text
%=======================
uicontrol(...
'units','normalized',...
'style','text',...
'position',[0.475    0.6     0.42   0.25],...
'backgroundcolor',[1  1  1],...
'foregroundcolor',[0.7 0.7 0.7],...
'Value',0,...
'tag','frame1',...
'HorizontalAlignment','left',...
'FontSize',7,...
'FontUnits','normalized',...
'FontName','MSSerif',...
'String',{' Copyright 2004'; ...
          'Markus Junghfer & Peter Peyk';...
          ''; ...
          'Implemented programs from:'; ...              
          'Olaf Hauk, Andreas Keil, Thomas Gruber'; ...
          'Andrea de Cesarei and Nathan Weisz'; ...
          ''; ...
          'http://www.uni-konstanz.de/win/emegs'}, ...
'HorizontalAlignment','left');

%=======================
% white background frame
%=======================
uicontrol(...
'units','normalized',...
'style','frame',...
'position',[0.03     0.03         0.94      0.5],...
'backgroundcolor',[1  1  1],...
'foregroundcolor',[0  0  0],...
'Value',0,...
'tag','frame1',...
'String',{''},...
'HorizontalAlignment','center');

%=======================
% synthetic data button
%=======================
uicontrol(...
'units','normalized',...
'style','pushbutton',...
'position',[0.54664     0.18799     0.38612    0.070496],...
'backgroundcolor',[0.92549     0.91373     0.84706],...
'foregroundcolor',[0  0  0],...
'Callback','emegs2d;gensynthdata;closelaunchpad;',...
'Value',0,...
'tag','',...
'String','synthetic data',...
'HorizontalAlignment','center');

%=======================
% EEG/MEG SPM button
%=======================
uicontrol(...
'units','normalized',...
'style','pushbutton',...
'position',[0.54664     0.30287     0.38612    0.070496],...
'backgroundcolor',[0.92549     0.91373     0.84706],...
'foregroundcolor',[0  0  0],...
'Callback','emegs2spm;closelaunchpad;',...
'Value',0,...
'tag','',...
'String','emegs2spm',...
'HorizontalAlignment','center');


%=======================
% wavelet button
%=======================
uicontrol(...
'units','normalized',...
'style','pushbutton',...
'position',[0.54664     0.41514     0.38612    0.070496],...
'backgroundcolor',[0.92549     0.91373     0.84706],...
'foregroundcolor',[0  0  0],...
'Callback','WaveApp;closelaunchpad;',...
'Value',0,...
'tag','',...
'String','wavelet',...
'HorizontalAlignment','center');

%=======================
% visualization button
%=======================
uicontrol(...
'units','normalized',...
'style','pushbutton',...
'position',[0.062907    0.065274     0.38612    0.088773],...
'backgroundcolor',[0.92549     0.91373     0.84706],...
'foregroundcolor',[0  0  0],...
'Callback','launchemegs2d;closelaunchpad;',...
'Value',0,...
'tag','',...
'String','visualization, statistics',...
'HorizontalAlignment','center');

%=======================
% HELP button
%=======================
uicontrol(...
'units','normalized',...
'style','pushbutton',...
'position',[0.74664    0.065274     0.18612    0.088773],...
'backgroundcolor',[0.92549     0.91373     0.84706],...
'foregroundcolor',[1  0  0],...
'Callback','launchemegshelp;',...
'Value',0,...
'tag','',...
'String','HELP',...
'HorizontalAlignment','center');

%=======================
% Quit button
%=======================
uicontrol(...
'units','normalized',...
'style','pushbutton',...
'position',[0.54664     0.065274     0.14612    0.088773],...
'backgroundcolor',[0.92549     0.91373     0.84706],...
'foregroundcolor',[1  0  0],...
'Callback','quitemegs;',...
'Value',0,...
'tag','',...
'String','QUIT',...
'HorizontalAlignment','center');

%=======================
% averaging button
%=======================
uicontrol(...
'units','normalized',...
'style','pushbutton',...
'position',[0.062907     0.18799     0.38612    0.070496],...
'backgroundcolor',[0.92549     0.91373     0.84706],...
'foregroundcolor',[0  0  0],...
'Callback','EmegsAvg;closelaunchpad;',...
'Value',0,...
'tag','',...
'String','averaging',...
'HorizontalAlignment','center');

%=======================
% artifact detection button
%=======================
uicontrol(...
'units','normalized',...
'style','pushbutton',...
'position',[0.062907     0.30287     0.38612    0.070496],...
'backgroundcolor',[0.92549     0.91373     0.84706],...
'foregroundcolor',[0  0  0],...
'Callback','EditAEM;closelaunchpad;',...
'Value',0,...
'tag','',...
'String','artifact detection',...
'HorizontalAlignment','center');

%=======================
% preprocessing button
%=======================
uicontrol(...
'units','normalized',...
'style','pushbutton',...
'position',[0.060738     0.41514     0.38612    0.070496],...
'backgroundcolor',[0.92549     0.91373     0.84706],...
'foregroundcolor',[0  0  0],...
'Callback','PrePro;closelaunchpad;',...
'Value',0,...
'tag','',...
'String','preprocessing',...
'HorizontalAlignment','center');


