function AnovaToAvgFiles(factor,validfactor,validbetweenfactor,TotResults,outpath)

%   Writes point- and channelwise results from repeated measures ANOVA
%   to disk using the SCADS-format. Files can be loaded and plotted 
%   using EMEGS2D and EMEGS3D.
%
%   See also RMANOVA, CALCRMANOVA, SAVEAVGFILE, READAVGFILE.

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer, Peter Peyk, Andreas Keil, Olaf Hauk,                  
%   Thomas Gruber & Andrea de Cesarei.  All Rights Reserved.  
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.   

if nargin<1;
    strrep(which('emegs3d.m'),'emegs3d.m','RMANOVA.mat')
    if ~exist(strrep(which('emegs3d.m'),'emegs3d.m','RMANOVA.mat'))
        try
            [infilename,infilepath]=uigetfile('*.mat','Please choose ANOVA result file:');
            load([infilepath,infilename],'TotResults','factor','validfactor','validbetweenfactor');
        catch;
        end;
    else
        load(strrep(which('emegs3d.m'),'emegs3d.m','RMANOVA.mat'),'TotResults','factor','validfactor','validbetweenfactor');
    end
    outpath = pwd;
end

global hPlot3dMenuFig hPlot2dMenuFig 
hPlot2dList=get(hPlot2dMenuFig,'Userdata');
hPlot3dList=get(hPlot3dMenuFig,'Userdata'); 
Plot2dNListHdr=get(hPlot2dList(51),'Userdata');
ActFileNo = 1;
hSetEegMegStatus=hPlot2dList(110);
EegMegStatusString=get(hSetEegMegStatus,'String');
if strcmp(EegMegStatusString,'EEG')
    EegMegStatus = 1;
else
    EegMegStatus = 2;
end
NTrialAvgVec=get(hPlot2dList(Plot2dNListHdr+(ActFileNo-1).*50+5),'Userdata');
StdChanTimeMat=get(hPlot2dList(Plot2dNListHdr+(ActFileNo-1).*50+6),'Userdata');
SampRate=get(hPlot2dList(60),'Userdata'); 
sampleresult = TotResults{1,1};
NChan = size(TotResults,1);
NPoints = size(TotResults,2);
MedMedRawVec = [];
MedMedAvgVec = [];
NChanExtra = 0;



for v=1:size(sampleresult{1,2},1)
       
     %F-Value
     if ~isempty(validfactor) & ~isempty(validfactor{1})
         if v>size(validfactor,1) 
             F_filename = [validbetweenfactor{1,1},'-F.at.ar'];
         else
            F_filename = [validfactor{sampleresult{1,2}{v,1},1},'-F.at.ar'];
        end
     else
        F_filename = [validbetweenfactor{1,1},'-F.at.ar'];
     end
     AvgMat = zeros(NChan,NPoints);
     for e=1:NChan
         for f =1:NPoints
             AvgMat(e,f)=TotResults{e,f}{1,2}{v,8};
         end
     end
     FilePath = [outpath,filesep,F_filename];
     saveavgfile(FilePath,AvgMat,NTrialAvgVec,StdChanTimeMat,SampRate,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra);       
             
     %p-Value 
     if ~isempty(validfactor) & ~isempty(validfactor{1})
         if v>size(validfactor,1)
             P_filename = [validbetweenfactor{1,1},'-p(F).at.ar'];
         else
            P_filename = [validfactor{sampleresult{1,2}{v,1},1},'-p(F).at.ar'];
        end
     else
        P_filename = [validbetweenfactor{1,1},'-p(F).at.ar'];
     end
      AvgMat = zeros(NChan,NPoints);
     for e=1:NChan
         for f =1:NPoints
             AvgMat(e,f)=1-TotResults{e,f}{1,2}{v,9};
         end
     end
     FilePath = [outpath,filesep,P_filename];
     saveavgfile(FilePath,AvgMat,NTrialAvgVec,StdChanTimeMat,SampRate,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra);
     
end






%interactions
for w=2:size(sampleresult,1)
    
    for v=1:size(sampleresult{w,2},1)
        outstring='';
        if sampleresult{w,2}{v,1}(1)<=size(validfactor,1)
            outstring=[outstring validfactor{sampleresult{w,2}{v,1}(1),1}];
        else
            outstring=[outstring validbetweenfactor{sampleresult{w,2}{v,1}(1)-size(validfactor,1),1}];
        end
        
        for t=2:size(sampleresult{w,2}{1},2)
            if sampleresult{w,2}{v,1}(t)>size(validfactor,1)
                outstring=[outstring '-x-' validbetweenfactor{sampleresult{w,2}{v,1}(t)-size(validfactor,1),1}];
            else
                outstring=[outstring '-x-' validfactor{sampleresult{w,2}{v,1}(t),1}];
            end
        end
        
        %F-Value
         F_filename = [outstring,'-F.at.ar'];
         AvgMat = zeros(NChan,NPoints);
         for e=1:NChan
             for f =1:NPoints
                 AvgMat(e,f)=TotResults{e,f}{w,2}{v,8};
             end
         end
         FilePath = [outpath,filesep,F_filename];
         saveavgfile(FilePath,AvgMat,NTrialAvgVec,StdChanTimeMat,SampRate,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra);       
                 
         %p-Value
         P_filename = [outstring,'-p(F).at.ar'];
          AvgMat = zeros(NChan,NPoints);
         for e=1:NChan
             for f =1:NPoints
                 AvgMat(e,f)=1-TotResults{e,f}{w,2}{v,9};
             end
         end
         FilePath = [outpath,filesep,P_filename];
         saveavgfile(FilePath,AvgMat,NTrialAvgVec,StdChanTimeMat,SampRate,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra);
        
    end
end





return

