function [DataMat,SaveFilePath,SizeDataMat,NDim,Version,SampRate,AvgRef,StartF0,EndF0,DeltaF0,NTap,SigmaM,...
        EegMegStatus,NChanExtra,AmpPhaseStatus,NTrials]=AvgWaveletData(FileMat,SaveFilePath,chWeight)
        
%   [DataMat,SaveFilePath,SizeDataMat,NDim,Version,SampRate,AvgRef,StartF0,EndF0,DeltaF0,NTap,SigmaM,
%        EegMegStatus,NChanExtra,AmpPhaseStatus,NTrials]=AvgWaveletData(FileMat,SaveFilePath,chWeight)
%   
%   AvgWaveletData averages wavelet data files given in FileMat. SaveFilePath can
%   contain an output path, chWeight allows weighting of each datafile.
%
%   See also WAVEAPP, DIFFWAVELETDATA.

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer, Peter Peyk, Andreas Keil, Olaf Hauk,
%   Thomas Gruber & Andrea de Cesarei.                        
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<3;chWeight=[];end;
if nargin<2;SaveFilePath=[];end;
if nargin<1;FileMat=[];end;

if isequal(SaveFilePath,0)
    return
end
if isempty(FileMat)	
    FileExt='*.*wa*'; 
    String='Choose a wavelet file (*.*wa*):';
    DefFilePath=SetDefPath(1,FileExt);
    [NFiles,FileMat,VersionString,BatchFilePath]=ReadFileNames(FileMat,DefFilePath,String);
    if NFiles<2; return; end
else
    NFiles=size(FileMat,1);
end

fprintf('\n\n');
chWeight=IfEmptyInputSpecVal(chWeight,[1 2],2,...
    'Use',...
    'no weighting                [1]',...
    'trial number weighting      [2]');
fprintf('\n\n');

for FileIndex=1:NFiles
    [File,Path,FilePath]=GetFileNameOfMat(FileMat,FileIndex);
    if FileIndex==1
        [DataMat,FilePath,SizeDataMat,NDim,Version,SampRate,AvgRef,StartF0,EndF0,DeltaF0,NTap,SigmaM,EegMegStatus,NChanExtra,AmpPhaseStatus,NTrials]=ReadWaveletData(FilePath);
        if isempty(SaveFilePath)
            initFile=['GM.'];
            [File,Path]=SepFilePath(FilePath);
            Tmp1=findstr(File,'.awa');
            Tmp2=findstr(File,'.pwa');
            if ~isempty(Tmp1)
                if length(File)>Tmp1+3
                     initFile=['GM.awa',File(Tmp1+4:end)];
                else
                    initFile='GM.awa';
                end
            elseif ~isempty(Tmp2)
                if length(File)>Tmp2+3
                     initFile=['GM.pwa',File(Tmp2+4:end)];
                else
                    initFile='GM.pwa';
                end
            end    
            [SaveFile,SavePath,SaveFilePath]=WriteFilePath([Path,filesep,initFile],'Choose avg. file name:');
        end 
        if chWeight==1
            NTrials=1;
        elseif chWeight==2
            DataMat=DataMat.*NTrials;
        end
    else
        [DataMatNew,FilePath,SizeDataMatNew,NDimNew,Version,SampRateNew,AvgRefNew,StartF0New,EndF0New,DeltaF0New,NTapNew,SigmaMNew,EegMegStatusNew,NChanExtraNew,AmpPhaseStatusNew,NTrialsNew]=ReadWaveletData(FilePath);
   
        if chWeight==1
            NTrialsNew=1;
        elseif chWeight==2
            DataMatNew=DataMatNew.*NTrialsNew;
        end 
		if NDimNew==NDim
            NTrials=NTrials+NTrialsNew;
            DataMat=DataMat+DataMatNew;
		end
    end
end
DataMat=DataMat./NTrials;
SaveWaveletData(DataMat,SaveFilePath,[],[],[],SampRate,AvgRef,StartF0,EndF0,DeltaF0,NTap,SigmaM,EegMegStatus,NChanExtra,AmpPhaseStatus,NTrials);
if nargout==0; DataMat=[]; end
return
