%   BatchModelFastPicBlockfMEEG


%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  


global ParentDir StatDir DirMat Smooth SmoothStr MaskStr a b c
NDir=size(DirMat,1)
Mask=[MaskStr,'*.img']
NSess=5;

                                                                    
for DirInd=1:5
    Folder=DirMat(DirInd,:)
    if strcmp(Folder(end),filesep)
        Folder=Folder(1:end-1);
    end
    F=spm_get('Files',Folder,Mask);
    NScan=size(F,1)
    NScanVec(DirInd)=NScan;
    eval(['FA',int2str((DirInd)),'=F;'])
end
F=[FA1;FA2;FA3;FA4;FA5];
OnsetVec=cumsum(NScanVec);
OnsetVec=[0,OnsetVec(1:end-1)];
%---------------------------------------------------------------
% batch variables defined here for analysis 'model'
%---------------------------------------------------------------

model(1) = struct( ...
 'types',          4, ...
 'global_effects', {'None'}, ...
 'burst_mode',     0, ...
 'HF_fil',         'none',  ...
 'HF_cut',         [], ...
 'LF_fil',         'none', ...
 'LF_cut',         [], ...
 'int_corr',       'none', ... 
 'now_later',      1, ...
 'stop_writing',   0, ...
 'trial_fcon',     0, ...
 'RT',             1, ...
 'replicated',     0, ...
 'same_time_param',0, ...
 'nsess',          1, ...
 'nscans',         sum(NScanVec), ...
 'files',          {{F}}, ...
 'conditions_nb',  [5], ...     
 'conditions',     [1], ...
 'regressors_nb',  [0], ...
 'regressors',     [], ...
 'parametrics_type', {{'none'}}, ...
 'parametrics',    [], ...
 'stochastics_flag',[0], ...
 'stochastics',    []);

 
conditions(1) = struct( ...
 'names',   {{'Neutral','HighPos','LowPos','HighNeg','LowNeg'}}, ...
 'onsets',{OnsetVec}, ...   
 'types',    {{'epochs','epochs','epochs','epochs','epochs'}}, ...   
 'bf_ep',   [1 2 3 4 5], ...                  
 'volterra',  0, ...
 'variable_dur',0);

%-------------------------------------------
%-------------------------------------------

bf_ep(1) = struct( ...
  'ep_type',4, ...
  'length',NScanVec(1), ...
  'conv',0, ...  
  'deriv',0);

for i=2:5
    bf_ep(i) = bf_ep(1);
    bf_ep(i).length=NScanVec(i)
end

%-------------------------------------------
%-------------------------------------------
CAro=[-2 2 -1 2 -1 0];
CInvAro=-CAro

    contrasts(1) = struct( ...
        'names',  {{...
                'CAro','CInvAro'}}, ...
        'types',   {{'T','T', ...
            }}, ...
        'values',  {{...
                CAro,CInvAro, ...
            }} ...
        ); 