%   BatchModelOneSamplefMEEG.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  


global ParentDir StatDir Folder0 Smooth SmoothStr MaskStr

%---------------------------------------------------------------
% model(1) Low-Off vs High Off
%---------------------------------------------------------------
                                                                    
Mask=[MaskStr,'*.img']
F0=spm_get('Files',Folder0,Mask);
NFiles0=size(F0,1)
%---------------------------------------------------------------
% batch variables defined here for analysis 'model'
%---------------------------------------------------------------

model(1) = struct( ...
 'types',          4, ...
 'global_effects', {'None'}, ...
 'burst_mode',     0, ...
 'HF_fil',         'none',  ...
 'HF_cut',         [], ...
 'LF_fil',         'none', ...
 'LF_cut',         [], ...
 'int_corr',       'none', ... 
 'now_later',      1, ...
 'stop_writing',   0, ...
 'trial_fcon',     0, ...
 'RT',             1, ...
 'replicated',     0, ...
 'same_time_param',0, ...
 'nsess',          1, ...
 'nscans',         [NFiles0], ...
 'files',          {{F0}}, ...
 'conditions_nb',  [1], ...     
 'conditions',     [1], ...
 'regressors_nb',  [0], ...
 'regressors',     [], ...
 'parametrics_type',{{'none'}}, ...
 'parametrics',    [], ...
 'stochastics_flag',[0], ...
 'stochastics',    []);
 
%-------------------------------------------
conditions(1) = struct( ...
 'names',   {{'High'}}, ...
 'onsets',{{0}}, ...   
 'types',    {{'epochs'}}, ...  
 'bf_ep',   [1], ...                  
 'volterra',  0, ...
 'variable_dur',0);

%-------------------------------------------

bf_ep(1) = struct( ...
  'ep_type',4, ...
  'length',NFiles0, ...
  'conv',0, ...  
  'deriv',0);

%contrasts(1) = struct('names',{{'CLow','CHigh','CHighGTLow','CLowGTHigh'}},'types', {{'T','T','T','T'}},'values',{{[1 0 0],[0 1 0],[-1 1 0],[1 -1 0]}});

% %-------------------------------------------
% conditions(1) = struct( ...
%  'names',   {{'Low-High'}}, ...
%  'onsets',{{0}}, ...   
%  'types',    {{'epochs'}}, ...  
%  'bf_ep',   [1], ...                  
%  'volterra',  0, ...
%  'variable_dur',0);
% 
% %-------------------------------------------
%  
% bf_ep(1) = struct( ...
%   'ep_type',4, ...
%   'length',NFiles0, ...
%   'conv',0, ...  
%   'deriv',0);
% 
% 
contrasts(1) = struct('names',{{'CHigh','CLow'}},'types', {{'T','T'}},'values',{{[-1 0],[1 0]}});