function [OutFileMat]=Besa2Scads(InFileMat)

%	Scads2Besa

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.    

if nargin<1; InFileMat=[]; end

[DefFilePath] = SetDefPath(1,'*.avr*');
[NFilesIn,InFileMat,NonUse,BatchFilePath]=ReadFileNames(InFileMat,DefFilePath,'Choose .avr files or batch file:');
[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
SetDefPath(2,BatchPath);

if NFilesIn==0; return; end

for FileInd=1:NFilesIn
	[InFile,InPath,InFilePath]=GetFileNameOfMat(InFileMat,FileInd);
	Nat=findstr(InFile,'.avr');
	if Nat(1)<length(InFile)-3
		OutFile=[InFile(1:Nat(1)-1),InFile(Nat+3:length(InFile)),'.at'];
	else
		OutFile=[InFile(1:Nat(1)-1),'.at'];
	end
	OutFilePath=[InPath,OutFile];
	BesaVersion=1;
	[AvgMat,TSB,DI,SB,SC,NPoints,NChan,SampRate]=ReadAsciiBesa(InFilePath,[],BesaVersion);
	NChan=NChan
	NTrialAvgVec=ones(NChan,1);
	StdChanTimeMat=ones(size(AvgMat));
	MedMedRawVec=ones(10,1);
	MedMedAvgVec=ones(10,1);
	EegMegStatus=2 %MEG
	NChanExtra=0;
	SaveAvgFile(OutFilePath,AvgMat,NTrialAvgVec,StdChanTimeMat,SampRate,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra)
end
return;
