function [OutFilePath,MiCsAvgMat,NTrialAvgVec1,MiCsStdMat,SampRate1,AvgRef1,Version1,MedMedRawVec1,MedMedAvgVec1,EegMegStatus1,NChanExtra1]=
    CalcAppScadsTStat(InFileMat,CalcBaseStatus,MinBase,MaxBase,SaveStatus,OutFilePath,AddFileExt,TStatus,AbsStatus,FlipMat)
%	CalcAppScadsTStat.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.   

if nargin<10; FlipMat=[]; end
if nargin<9; AbsStatus=[]; end
if nargin<8; TStatus=[]; end
if nargin<7; AddFileExt=[]; end
if nargin<6; OutFilePath=[]; end
if nargin<5; SaveStatus=[]; end
if nargin<4; MaxBase=[]; end
if nargin<3; MinBase=[]; end
if nargin<2; CalcBaseStatus=[]; end
if nargin<1; InFileMat=[]; end

if isempty(SaveStatus); SaveStatus=1; end
if isempty(AbsStatus); AbsStatus=0; end
if isempty(TStatus); TStatus=2; end

[CalcBaseStatus]=IfEmptyInputBo('Do you want to subtract a baseline ?',[],CalcBaseStatus,1,1);
if CalcBaseStatus & (isempty(MinBase) | isempty(MaxBase))
    fprintf('\n')
    [NPointsBaseStatus]=IfEmptyInputBo('Do you want to use','the whole interval as baseline ?',[],1,0);
    if NPointsBaseStatus; 
        MinBase=[]; MaxBase=[]; 
    else
        [MinBase]=IfEmptyInputVal('Please insert the baseline start point:',[],MinBase,1,0);
        [MaxBase]=IfEmptyInputVal('Please insert the baseline start point:',[],MaxBase,1,0);
    end
end   
[DefFilePath]=SetDefPath(1,'*.app*');
if TStatus==3
    StrTmp='Choose pairs of app files or batch file:'
else
    StrTmp='Choose app files or batch file:'
end
[NFilesIn,InFileMat,NonUse,BatchFilePath]=ReadFileNames(InFileMat,DefFilePath,StrTmp,[],[],[],[],2);
if NFilesIn==0; return; end
if NFilesIn==1; TStatus=1; end
if NFilesIn>2; InFileMat=InFileMat(1:2,:); end
if TStatus==1
    FileExt='.ott'; %One sample t-test
    Message=char('Calculate one sample t-test of file:');
elseif TStatus==2
    FileExt='.ttt'; %Two sample t-test
    Message=char('Calculate two sample t-test of files:');
elseif TStatus==3
    FileExt='.ptt'; %Paired t-test
    Message=char('Calculate paired t-test of files:');
elseif TStatus==4
    FileExt='.stt'; %Symmetry t-test
    Message=char('Calculate symmetry t-test of file:');
end
if CalcBaseStatus
    FileExt=[FileExt,'.b'];
    if isempty(MinBase); MinBase=1; end
    if isempty(MaxBase); 
        CalcBaseStr=['Subtract baseline interval of points ',int2str(MinBase),' - NPoints.'];
    else
        CalcBaseStr=['Subtract baseline interval of points ',int2str(MinBase),' - ',int2str(MaxBase),'.'];
    end
else
    CalcBaseStr='No baseline subtraction.';
end
FileExt=[FileExt,'.at'];
if ~isempty(AddFileExt)
    FileExt=[FileExt,AddFileExt];
end
Tmp=findstr(BatchFilePath,'.app');
if ~isempty(Tmp)
    SaveFilePath=[BatchFilePath(1:Tmp-1),FileExt];
else
    SaveFilePath=[BatchFilePath,FileExt];
end

Message=char(Message,' ');
Message=char(Message,InFileMat(1,:));
if TStatus>1
    Message=char(Message,InFileMat(2,:));
end
Message=char(Message,' ');
Message=char(Message,CalcBaseStr);
Message=char(Message,' ');
Message=char(Message,'Result file of t-test:');
Message=char(Message,SaveFilePath);
hmsgbox=msgbox(Message,'Info:','help'); 
hChildMsgbox=get(hmsgbox,'Children');
hChild2Msgbox=get(hChildMsgbox(2),'Children');
set(hChildMsgbox(length(hChildMsgbox)),'Visible','off');
pause(.01);
fprintf('\n');

if TStatus==1
    
    [AllAvgMat1,Version1,LHeader1,ScaleBins1,NChan1,NPoints1,NTrials1,SampRate1,AvgRefStatus1,File1,Path1,FilePath1,EegMegStatus1,NChanExtra1]=readappdata(InFileMat,'all');
    NTrials2=NTrials1;
    if AbsStatus; 
        AllAvgMat1=abs(AllAvgMat1);
    end
    if CalcBaseStatus
        if isempty(MinBase); MinBase=1; end
        if isempty(MaxBase); MaxBase=NPoints1; end
        fprintf('\n');
        fprintf('AppMat: Subtract baseline interval of points %g - %g\n',MinBase,MaxBase);
        for i=1:NTrials1
            AllAvgMat1(i,:,:)=CalcBaseline(squeeze(AllAvgMat1(i,:,:)),MinBase,MaxBase,CalcBaseStatus);
        end
    else
        fprintf('\n');
        fprintf('AppMat: No baseline subtraction\n\n\n');
    end
    
    MeanAvgMat1=mean(AllAvgMat1,1);
    DiffMat=MeanAvgMat1;
    StdAvgMat1=std(AllAvgMat1,0,1);
    Vari=sqrt(StdAvgMat1.^2./NFilesIn1);
    ZeroVari=Vari==0;
    Vari=Vari+ZeroVari;									%Set Vari=1 if Vari=0
    MiCsAvgMat=MeanAvgMat1./Vari;
    MiCsAvgMat=MiCsAvgMat-MiCsAvgMat.*ZeroVari;			%Set Vari=0 if Vari=0
    
else
    
    [AllAvgMat1,Version1,LHeader1,ScaleBins1,NChan1,NPoints1,NTrials1,SampRate1,AvgRefStatus1,File1,Path1,FilePath1,EegMegStatus1,NChanExtra1]=readappdata(InFileMat(1,:),'all');
    [AllAvgMat2,Version2,LHeader2,ScaleBins2,NChan2,NPoints2,NTrials2,SampRate2,AvgRefStatus2,File2,Path2,FilePath2,EegMegStatus2,NChanExtra2]=readappdata(InFileMat(2,:),'all');
    if NChan1-NChan2; fprintf(1,'Channel numbers do not agree: NChan1=%g; NChan2=%g\n',NChan1,NChan2); return; end
    if NPoints1-NPoints2; fprintf(1,'Numbers of points do not agree: NPoints1=%g; NPoints2=%g\n',NPoints1,NPoints2); return; end
    if SampRate1-SampRate2; fprintf(1,'Sampling rates do not agree: SampRate1=%g; SampRate2=%g\n',SampRate1,SampRate2); return; end
    if AvgRefStatus1-AvgRefStatus2; fprintf(1,'AvgRef stati do not agree: AvgRefStatus1=%g; AvgRefStatus2=%g\n',AvgRefStatus1,AvgRefStatus2); return; end
    if EegMegStatus1-EegMegStatus2; fprintf(1,'EegMeg stati do not agree: EegMegStatus1=%g; EegMegStatus2=%g\n',EegMegStatus1,EegMegStatus2); return; end
    if NChanExtra1-NChanExtra2; fprintf(1,'Number of extra chennels do not agree: NChanExtra1=%g; NChanExtra2=%g\n',NChanExtra1,NChanExtra2); return; end
    
    if AbsStatus; 
        AllAvgMat1=abs(AllAvgMat1);
        AllAvgMat2=abs(AllAvgMat2);
    end
    if CalcBaseStatus
        if isempty(MinBase); MinBase=1; end
        if isempty(MaxBase); MaxBase=NPoints1; end
        fprintf('\n');
        fprintf('AppMat1: Subtract baseline interval of points %g - %g\n',MinBase,MaxBase);
        for i=1:NTrials1
            AllAvgMat1(i,:,:)=CalcBaseline(squeeze(AllAvgMat1(i,:,:)),MinBase,MaxBase,CalcBaseStatus);
        end
        if isempty(MinBase); MinBase=1; end
        if isempty(MaxBase); MaxBase=NPoints2; end
        fprintf('AppMat2: Subtract baseline interval of points %g - %g\n',MinBase,MaxBase);
        for i=1:NTrials2
            AllAvgMat2(i,:,:)=CalcBaseline(squeeze(AllAvgMat2(i,:,:)),MinBase,MaxBase,CalcBaseStatus);
        end
    else
        fprintf('\n');
        fprintf('AppMat1 and AppMat2: No baseline subtraction\n\n\n');
    end
    fprintf('\n\n');
    if TStatus==3 %Paired
        DiffMat=AllAvgMat1-AllAvgMat2;
        SumDiffMat=sum(DiffMat,1);
        SumSquareDiffMat=sum(DiffMat.^2,1);
        SigmaDiff=sqrt((SumSquareDiffMat-SumDiffMat.^2./NFilesIn)./(NFilesIn-1));
        ZeroSigmaDiff=SigmaDiff==0;
        SigmaDiff=SigmaDiff+ZeroSigmaDiff;		                %Set SigmaDiff=1 if SigmaDiff=0
        MiCsAvgMat=(SumDiffMat./NFilesIn)./(SigmaDiff./sqrt(NFilesIn));
        MiCsAvgMat=MiCsAvgMat-MiCsAvgMat.*ZeroSigmaDiff;		%Set SigmaDiff=0 if SigmaDiff=0	
    else    
        MeanAvgMat1=mean(AllAvgMat1,1);
        MeanAvgMat2=mean(AllAvgMat2,1);
        DiffMat=MeanAvgMat1-MeanAvgMat2;
        StdAvgMat1=std(AllAvgMat1,0,1);
        StdAvgMat2=std(AllAvgMat2,0,1);
        Vari=sqrt((StdAvgMat1.^2+StdAvgMat2.^2)./NFilesIn);
        ZeroVari=Vari==0;
        Vari=Vari+ZeroVari;									%Set Vari=1 if Vari=0
        MiCsAvgMat=(MeanAvgMat1-MeanAvgMat2)./Vari;
        MiCsAvgMat=MiCsAvgMat-MiCsAvgMat.*ZeroVari;			%Set Vari=0 if Vari=0
    end
end
MiCsAvgMat=squeeze(MiCsAvgMat);

MeanNTrials=mean([NTrials1,NTrials2]).*ones(NChan1,1);
MedMedRawVec=ones(NTrials1+NTrials2,1);
MedMedAvgVec=ones(NTrials1+NTrials2,1);
if SaveStatus
    [OutFile,OutPath,OutFilePath]=SaveAvgFile(SaveFilePath,MiCsAvgMat,MeanNTrials,DiffMat,SampRate1,MedMedRawVec,MedMedAvgVec,EegMegStatus1,NChanExtra1);
end
close(hmsgbox);
return;
