function [InvCoeff]=CalcApproxVec(InvCoeff,StdVec,WeightVec,EPosSpher,ENames,chUseBetaApprox,chApproxKind);

%	CalcApproxVec.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.   

if nargin<6; chApproxKind=[]; end
if nargin<6; chUseBetaApprox=[]; end
if nargin<5; ENames=[]; end
if nargin<4; EPosSpher=[]; end
if nargin<3; WeightVec=[]; end
if nargin<2; StdVec=[]; end
if nargin<1; return; end

[m,n]=size(InvCoeff);

again=1;
while again
	[chUseBetaApprox]=IfEmptyInputBo(['Do you want to use'],['the beta vector of approximation ?'],chUseBetaApprox,1,1);

	if chUseBetaApprox
		if ~isempty(StdVec) & ~isempty(WeightVec)
			clc;
			[chApproxKind]=IfEmptyInputSpecVal(chApproxKind,[1 2 3],2,...
			['Do you want to\n'],...
			['use the std vector or                                                 [1]'],...
			['use the channel weight vector or                                      [2]'],...
			['use a combination of std and channel weight vector or  				[3]']);
		elseif ~isempty(StdVec) & isempty(WeightVec)
			chApproxKind=1;
		elseif isempty(StdVec) & ~isempty(WeightVec)
			chApproxKind=2;
		end
		if chApproxKind==1
			InvBetaVec=norm_1(StdVec,1);
			[CH_DispStdVec]=IfEmptyInputBo(['Do you want to display the std vector ?'],[],[],0,1);
			if CH_DispStdVec; fprintf('Vector of std:'); disp(InvBetaVec); end
		elseif chApproxKind==2
			InvBetaVec=norm_1(WeightVec,1);
		elseif chApproxKind==3
			StdVec=norm_1(StdVec,1);
			WeightVec=norm_1(WeightVec,1);
			[ChanToStd]=IfEmptyInputValInt(['Please insert the quotient: Channel Weight / Std Vector'],[],[],1,0,100,1);
			InvBetaVec=ChanToStd.*WeightVec+StdVec;
		end
		clc;
		[WeightKind]=IfEmptyInputSpecVal([],[1:4],3,...
		['Do you want to weight\n'],...
		['square root (S/N)  [1]'],...
		['linear             [2]'],...
		['square             [3]'],...
		['.^3                [4]']);
		if WeightKind==1
			WeightPot=.5;
		elseif WeightKind==2
			WeightPot=1;
		elseif WeightKind==3
			WeightPot=2;
		elseif WeightKind==4
			WeightPot=3;
		end
		InvBetaVecTmp=InvBetaVec.^WeightPot;
		InvBetaVecTmp=norm_1(InvBetaVecTmp,1);
		[MinBetaVal]=IfEmptyInputValInt(['Please choose the minimal value of the beta vector:'],['(all values which are smaller will be set to zero)'],[],.2,0,1,1);
		if MinBetaVal<1
			kSmallMinBetaVal=find(InvBetaVecTmp<=MinBetaVal);
			kBigMinBetaVal=find(InvBetaVecTmp>MinBetaVal);
			fprintf(1,'Number of channels which beta value are lower than %g :  %g',MinBetaVal,length(kSmallMinBetaVal)); pause(.5)
			if ~isempty(kSmallMinBetaVal)
				InvBetaVecTmp(kSmallMinBetaVal)=zeros(length(kSmallMinBetaVal),1);
			end
		end
		[MinVal]=IfEmptyInputVal(['Please insert the minimum value'],['to normalize the inverse beta vector:'],[],0,1);
		if ~isempty(kBigMinBetaVal)
			InvBetaVecTmp(kBigMinBetaVal)=norm_1(InvBetaVecTmp(kBigMinBetaVal),4,[],MinVal,1);
		end
		k=find(InvBetaVecTmp==0);
		if ~isempty(k); InvBetaVecTmp(k)=0.0000001.*ones(length(k),1); end
		BetaVec=1./InvBetaVecTmp;
		%The larger the special channel weight the lower the special beta factor	
		CH_PlotApproxVec=[];
	else
		BetaVec=ones(m,1);
		CH_PlotApproxVec=0;
	end
	
	[LambdaApprox]=IfEmptyInputVal(['Please insert the wished Lambda value of Approximation:'],[],[],0.02,1);
	
	LambdaBetaVec=LambdaApprox.*BetaVec;
		
	%[hfig]=Plot2DVal(LambdaBetaVec,EPosSpher,ENames,hfig,[],'Beta - Vector','Electrode:','Value of beta:',1);

	[again]=IfEmptyInputBo('Do you want to change this vector ?',[],[],1,1);
end
%close(hfig);
ApproxVec=LambdaBetaVec.*max(max(abs(InvCoeff)));	

for i=1:m
	InvCoeff(i,i)=InvCoeff(i,i).*ApproxVec(i);
end
return;
	
