function [DataOut,BaseStartPoint,BaseEndPoint,CalcBaseStatus,BaseVec] = CalcBaseline(DataIn,BaseStartPoint,BaseEndPoint,CalcBaseStatus,DefCalcBaseline,BaseVec)

%   CalcBaseline.m
%
%   FUNCTION TO SUBTRACT BASELINE FROM DATA

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.   

if nargin<6; BaseVec=[]; end
if nargin<5; DefCalcBaseline=0; end
if nargin<4; CalcBaseStatus=1; end
if nargin<3; BaseEndPoint=[]; end
if nargin<2; BaseStartPoint=[]; end
if nargin<1; DataIn=[]; CalcBaseStatus=1; end

if ~CalcBaseStatus; DataOut=DataIn; return; end;
[m,n]=size(DataIn);
if isempty(BaseVec)
	if isempty(BaseStartPoint) | isempty(BaseEndPoint)
		fprintf('Which time-intervall you want to use to calculate the baseline?\n\n\n')
		fprintf('Please enter start- and endpoint of baseline-intervall !')
		fprintf('\n\n\n')
		[BaseStartPoint]=IfEmptyInputValInt(['Start [in data-points]'],[],BaseStartPoint,1,1,n);
		[BaseEndPoint  ]=IfEmptyInputValInt(['End   [in data-points]'],[],BaseEndPoint,BaseStartPoint,BaseStartPoint,n);
	end
	if BaseStartPoint==BaseEndPoint
		BaseVec=DataIn(:,BaseStartPoint);
	else
		BaseVec=mean(DataIn(:,BaseStartPoint:BaseEndPoint),2);
	end
end
DataOut=zeros(m,n);
for i=1:n
	DataOut(:,i)=DataIn(:,i)-BaseVec;
end
