function [Coeff] = CalcCoeff(IndexExactMat,LegVec,LengthLegVec)

%	CalcCoeff.m

%
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.     


[m,n]=size(IndexExactMat);
factor=(LengthLegVec-1)./2;
IndexExactMat=IndexExactMat.*factor+(factor+1).*ones(m,n);
IndexUpMat=ceil(IndexExactMat);
IndexDownMat=floor(IndexExactMat);
IndexDiffMat=IndexUpMat-IndexDownMat;

[a,b]=find(IndexUpMat==LengthLegVec+1);
if ~isempty(a)
	for i=1:length(a)
		IndexUpMat(a(i),b(i))=LengthLegVec;
	end
end

Coeff=zeros(m,n);
for i=1:m
	for j=1:n
		Coeff(i,j)=LegVec(IndexDownMat(i,j))+IndexDiffMat(i,j).*(LegVec(IndexUpMat(i,j)) - LegVec(IndexDownMat(i,j)) );
	end
end

return;
