function[GPData,ch_DispChanWeight,CH_TCWVFGPC,MinWeightVal]=...
	CalcGlobalPower(Data,ChanWeightVec,ENames,ch_DispChanWeight,CH_TCWVFGPC,MinWeightVal);
	

%	CalcGlobalPower.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  

if nargin<6; MinWeightVal=[]; end
if nargin<5; CH_TCWVFGPC=[]; end
if nargin<4; ch_DispChanWeight=[]; end
if nargin<3; ENames=[]; end
if nargin<2; ChanWeightVec=[]; end
if nargin<1; return; end
if isempty(Data); return; end;

[NChan,NPoints]=size(Data);

if ~isempty(ChanWeightVec)
	[m,n]=size(ChanWeightVec); if m==1; ChanWeightVec=ChanWeightVec'; end
	MinChanWeightVec=min(ChanWeightVec);
	MaxChanWeightVec=max(ChanWeightVec);
	[ch_DispChanWeight]=IfEmptyInputBo(['Do you want to display the ChanWeightVec ?'],[],ch_DispChanWeight,0,1);
	if ch_DispChanWeight; 
		if ~isempty(ENames)
			fprintf('Electrode          Weight\n\n');
			for i=1:NChan
				fprintf(ENames(i,:))
				fprintf(1,'                        %g\n',ChanWeightVec(i));
			end
			pause(2);
		else
			disp(ChanWeightVec'); 
		end
		ch_DispChanWeight=0;
	end
	[CH_TCWVFGPC]=IfEmptyInputBo(['Take the channel weight vector'],['to calculate the global power ?'],CH_TCWVFGPC,1,1);
else
	CH_TCWVFGPC=0;
end

if CH_TCWVFGPC
	if ~isempty(MinWeightVal); PrintMessageStatus=0; else; PrintMessageStatus=1; end
	[MinWeightVal]=IfEmptyInputValInt(['Please choose the minimal value of all weights:'],['(all weights which are smaller will be set to zero)'],MinWeightVal,.9.*max(ChanWeightVec) ,0,max(ChanWeightVec),1);
	kSmallMinWeight=find(ChanWeightVec<=MinWeightVal);
	if PrintMessageStatus
		fprintf(1,'Number of channels which weight are lower than %g :  %g',MinWeightVal,length(kSmallMinWeight)); pause(1)
	end
	ChanWeightVec(kSmallMinWeight)=zeros(length(kSmallMinWeight),1);
	ChanWeightVec=ChanWeightVec./MaxChanWeightVec;
	for i=1:NPoints
		Data(:,i)=Data(:,i).*ChanWeightVec;
	end
	GPData=(sum(Data.^2))./sum(ChanWeightVec);
	return;
else
	GPData=(sum(Data.^2))./NChan;
end

return;
