function [weight_vec] = CalcPolWeight(point_mat,std_mat,e_names_out,ch_weight)


%	CalcPolWeight.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.         

if nargin<4; ch_weight=[]; end
[m,n]=size(point_mat);
weight_vec=ones(1,m);
clc;
[ch_weight]=IfEmptyInputBo(['Do you want to use weighting ? Y/N'],[],ch_weight,1);
if ~ch_weight; return; end;


%+++++CALCULATE (BASED ON STD DATA) OR INSERT WEIGHTING FACTORS TO SPECIAL POSITIONS 
[m,n]=size(point_mat);
ch_weight=[];
if ~isempty(std_mat)
	clc;
	fprintf('Do you want to\n\n');
	fprintf('weight special polhemus positions by your own or          [1]\n');
	fprintf('weight one special polhemus position with 1 and\n');
	fprintf('calculate all others by their distance to this or         [2]\n');
	fprintf('weight by standard deviation or                           [3]\n');
	fprintf('weight with [1] and [2] or                                [4]\n');
	fprintf('weight with [1] and [3]                                   [5]\n');
	fprintf('weight with [2] and [3]                                   [6]\n');
	fprintf('weight with [1],[2] and [3]                               [7]\n\n');
	[ch_weight]=IfEmptyInputVal(['Please insert your choice:'],[],[],1);
else
	clc;
	fprintf('Do you want to\n\n');
	fprintf('weight special polhemus positions by your own or        [1]\n');
	fprintf('weight one special polhemus position with 1 and\n');
	fprintf('calculate all others by their distance to this or       [2]\n');	
	fprintf('weight with [1] and [2] or                              [3]\n\n');
	[ch_weight]=IfEmptyInputVal(['Please insert your choice:'],[],[],3);
	if ch_weight==3;
		ch_weight=4;
	end
end

%------------------------------------
if ch_weight==1 | ch_weight==4	| ch_weight==5 | ch_weight==7
	[ch_file]=IfEmptyInputBo(['Do you want to use an existing weighting file ?'],[],[],1);
	
	if ch_file
		
		data_file=[];
		[data_file,data_path]=uigetfile('*','Get File: Weighting Data');
		data_file=[data_path,data_file];
		fid=fopen(data_file,'r','b');
		fprintf('Start reading of file:\n');
		fprintf(data_file);
		fprintf('\n\n');
		[weight_1,count]= fread(fid,inf,'float64');
		weight_1=weight_1';
		fprintf('The read in weights are:\n\n')
		disp(weight_1)
		pause(1)
	
	else 
		
		weight_1=ones(1,m);	
		fprintf('\n');
		clc;	
		fprintf('All not special weighted position are weighted with 1 !\n\n');
		for i=1:m
			clc;
			fprintf('\n');
			fprintf(1,'Please insert the wished weight of this %g position named:  ',i)
			fprintf(1,e_names_out(i,:))
			fprintf(1,'\n')
			fprintf(1,'Position of this electrode:  (x= %g, y= %g, z=%g)\n',point_mat(i,:))
			[weight_1(i)]=IfEmptyInputValInt(['Please insert the weight [0<=weight<=1]:'],[],[],1,0,1);
		end 
		[ch_SaveInFile]=IfEmptyInputBo(['Do you want to save all this weighting in file ? Y/N'],[],[],1)
		if ch_SaveInFile
			clc;
			data_file=[];
			[data_file,data_path]=uiputfile('*','Put File: Weighting Data');
			data_file=[data_path,data_file];
			fid=fopen(data_file,'r','b');
			fprintf('Start writing data to file:\n');
			fprintf(data_file);
			fprintf('\n');	
			fid=fopen(data_file,'a','b');
			count = fwrite(fid,weight_1,'float64');
			fclose(fid);
			pause(1)
		end
		clc;
		fprintf('The wished weights are:\n\n')
		disp(weight_1)
		pause(1)
	end	
end 

%------------------------------------
if ch_weight==2 | ch_weight==4 | ch_weight==6 | ch_weight==7
	clc;
	fprintf('\n');
	fprintf('Please insert the number of the electrode-position')
	v1_pos=input('whom you want to give the weight-value 1:');
	fprintf(1,'You have chosen the %g electrode-position named ',v1_pos)
	fprintf(1,e_names_out(v1_pos,:))
	fprintf(1,'\n')
	for i=1:m
		dist(i)=sqrt((point_mat(v1_pos,1)-point_mat(i,1)).^2+...
					 (point_mat(v1_pos,2)-point_mat(i,2)).^2+...
					 (point_mat(v1_pos,3)-point_mat(i,3)).^2);
	end
	weight_2=ones(1,m)-norm_1(dist,1);
	[min_weight]=IfEmptyInputValInt(['Please insert your wished minimum value of all distance-weights:'],[],[],0.9,0,1);
	weight_2=weight_2.*(1-min_weight)+ones(1,m).*min_weight;
end
%------------------------------------
if ch_weight==3 | ch_weight==5 | ch_weight==6 | ch_weight==7
	for i=1:m
		std_vec(i)=sqrt(sum(std_mat(i,:).^2));
	end
	std_vec=ones(1,m)-norm_1(std_vec,1);
	[min_weight]=IfEmptyInputValInt(['Please insert your wished minimum value of all std weights:'],[],[],0.9,0,1);
	weight_3=std_vec.*(1-min_weight)+ones(1,m).*min_weight;
end
%------------------------------------

if ch_weight==1

	weight_vec=weight_1;
	
elseif ch_weight==2

	weight_vec=weight_2;
	
elseif ch_weight==3

	weight_vec=weight_3;
	
elseif ch_weight==4

	weight_vec=weight_1.*weight_2;

elseif ch_weight==5

	weight_vec=weight_1.*weight_3;
	
elseif ch_weight==6

	weight_vec=weight_2.*weight_3;

elseif ch_weight==7

	weight_vec=weight_1.*weight_2.*weight_3;
	
end

%------------------------------------

clc;
fprintf('The calculated and/or wished weights are:\n\n')
disp(weight_vec)
pause

return;
