function [gamma] = CalcScalpGamma(i,ParaVec)


%	CalcScalpGamma.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.        

%DEFINE RADII OF SHELLS
cort_radius= ParaVec(1);
csf_radius= ParaVec(3);
skull_radius= ParaVec(5);
scalp_radius= ParaVec(7);
dipole_radius=ParaVec(9);

% DEFINE CONDUCTIVITY VARIABLES (ohms * meters)
o1 = ParaVec(2); %ocort;      
o2 = ParaVec(4); %ocsf;    
o3 = ParaVec(6); %oskull; 
o4 = ParaVec(8); %oscalp;       

% VARIABLES DEFINING RATIO OF CONDUCTIVITY SHELLS (unitless)
b = cort_radius / scalp_radius;   
c = csf_radius / scalp_radius;    
d = skull_radius / scalp_radius;   

% CONDUCTIVITY	RATIOS (unitless)
k1 = o1 / o2;
k2 = o2 / o3;
k3 = o3 / o4;

% DIPOLE LOCATION RATIO (unitless)	
f = dipole_radius / scalp_radius;   

		
% CALCULATE gamma

	gamma_tmp = (d ^ (2 * i + 1)) * ...                                                 
				((b ^ (2 * i + 1)) * i * (k1 - 1) * (k2 - 1) * (i + 1) +...         
   				(c ^ (2 * i + 1)) * (k1 * i + i + 1) * (k2 * i + i + 1)) *...     
				((k3 * i + i + 1) + (i + 1) * (k3 - 1) * (d ^ (2 * i + 1))) + ... 
				 (i + 1) * (c ^ (2 * i + 1)) *...                                              
				((b ^ (2 * i + 1)) * (k1 - 1) * (k2 * i + k2 + i) +...                
				(c ^ (2 * i + 1)) * (k1 * i + i + 1) * (k2 - 1)) *...                  
				 (i * (k3 - 1) + (k3 * i + k3 + i) * (d ^ (2 * i + 1)));

	gamma =    (((1/(4 * pi * o4 * (scalp_radius^2))) * (((2 * i) + 1)^4) * ...
				(f^(i - 1)) * ((c * d) ^ (2 * i + 1))))  / gamma_tmp;
				 

return;	
	
