function[Mat]=CalcValOfVecToMat(Mat,Vec,Action);

%	CalcValOfVecToMat.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.           


if nargin<3; Action=[]; end
if nargin<2; fprintf('No vector in CalcVecToMat'); return; end
if nargin<1; fprintf('No matrix in CalcVecToMat'); return; end
if ~isempty(Action)
	if Action~=['+'] & Action~=['-'] & Action~=['*'] & Action~=['/'] 
		fprintf('Unknown action in CalcVecToMat.m !'); return;
	end
end
[m,n]=size(Mat);
[o,p]=size(Vec);

if o~=1 & p~=1;  fprintf('No vector in CalcVecToMat'); return; end
if p~=1; Vec=Vec; o=p; end
if o~= n; fprintf(1,'Length of vector in CalcVecToMat (%g) have to be the number of columns of matrix (%g) !',o,n); return; end

fprintf('\n');clc;
[Action]=IfEmptyInputSpecVal(Action,[1 2 3 4 5],1,['Do you want to\n\n'],...
			['add                   [1]'],...
			['subtract              [2]'],...
			['multiplicate or       [3]'],...
			['divide                [4]\n\n'],...
			['the given vector to each row of the given matrix ?\n\n'],...
			['or do you want to "return" ?                [5]']);

if     Action==1; Action=['+'];
elseif Action==2; Action=['-'];
elseif Action==3; Action=['*'];
elseif Action==4; Action=['/'];
elseif Action==5; Action=['#'];
end

if Action==['#']; return; end
if Action==['+'] | Action==['-'] 
	for i=1:n
		eval(['Mat(:,' int2str(i) ')=Mat(:,' int2str(i) ')' Action 'Vec(' int2str(i) ');']);
	end
elseif Action==['*'] | Action==['/'] 
	for i=1:n
		eval(['Mat(:,' int2str(i) ')=Mat(:,' int2str(i) ').' Action 'Vec(' int2str(i) ');']);
	end
end
return;
	


			


	
