%   CompareNets
%	
%   This routine is used to look for the nearest sensors between two
%   configuration files (CartAscii format). For each one of the files in the dest config 
%   (less sensors), the nearest source config sensor is found. No repetitions 
%   are allowed (i.e., at the end the routine returns as many sensors as 
%   the dest file). 
%   After calculations, the program stores in a file an array, with numbers which 
%   identify the number of sensors in the source config which are closest
%   to one of the dest config. 

%   (c) 2004, Andrea De Cesarei
%    THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%    NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%    WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%    OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%    TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%    INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%    OR DOCUMENTATION. 



% asks for source file (more electrodes)
[CartAsciiFile,CartAsciiPath,CartAsciiFilePath]=ReadFilePath([],'*.CartAscii','Choose the source CartAscii file:');
CartAsciiSource=[];
CartAsciiFid=fopen(CartAsciiFilePath, 'r');
buf=fgetl(CartAsciiFid);
i=1;
while ~feof(CartAsciiFid)
    buf=fgetl(CartAsciiFid);
    CartAsciiSource=[ CartAsciiSource; sscanf(buf, '%g')'];
    i=i+1;
end
if size(CartAsciiSource,1)<size(CartAsciiSource,2); CartAsciiSource=CartAsciiSource'; end; 
    
% asks for dest file (less electrodes)
[CartAsciiFile,CartAsciiPath,CartAsciiFilePath]=ReadFilePath([],'*.CartAscii','Choose the destination CartAscii file:');
CartAsciiDest=[];
CartAsciiFid=fopen(CartAsciiFilePath, 'r');
buf=fgetl(CartAsciiFid);
i=1;
while ~feof(CartAsciiFid)
    buf=fgetl(CartAsciiFid);
    CartAsciiDest=[ CartAsciiDest; sscanf(buf, '%g')'];
    i=i+1;
end
if size(CartAsciiDest,1)<size(CartAsciiDest,2); CartAsciiDest=CartAsciiDest'; end; 


% checks whether source and dest are messed 
if length(CartAsciiDest)>length(CartAsciiSource); 
    % disp('Destination config has more sensors than the source.'); 
    % disp('Probably you want to invert their order!'); 
    buf=CartAsciiSource;
    CartAsciiSource=CartAsciiDest;
    CartAsciiDest=buf; 
    clear buf;
    pause
end % if length(CartAsciiDest)>length(CartAsciiSource); 

% calculates matrix of distances
Dist=[];
for i=1:length(CartAsciiDest) % less
    for j=1:length(CartAsciiSource) % more
        diffx=CartAsciiDest(i,1)-CartAsciiSource(j,1);
        diffy=CartAsciiDest(i,2)-CartAsciiSource(j,2);
        diffz=CartAsciiDest(i,3)-CartAsciiSource(j,3);
        diff3d=sqrt(diffx^2+diffy^2+diffz^2);
        Dist(i,j)=diff3d;
    end % for j
end % for i


% for each dest sensor, sorts source sensors based on their distance
min=[];
minCol=[];
minRows=[];
for i=1:length(CartAsciiDest) %less        
        minDist=Dist(i,:);
        minDist=[minDist; 1:length(minDist)]';
        [fake, ind]=sort(minDist(:,1));
        minDist=minDist(ind,:);
        min(:,:,i)=minDist;
        
        minCol=[minCol minDist];
        minRows=[minRows; minDist];
end % for i


matMin=min;
ind=zeros(size(matMin,3),1)+1; % creates an index of ones


rip=100; % fake 

while rip>0
    
for i=1:size(matMin,3)  

    for j=(i+1):size(matMin,3)  

        if matMin(ind(i),2,i)== matMin(ind(j),2,j) 
%             disp('identical sensors...');
            if matMin(ind(i),1,i) > matMin(ind(j),1,j) 
                % disp('i choose the 1st...');
                ind(i)=ind(i)+1;
            else
                % disp('i choose the 2nd...');
                ind(j)=ind(j)+1;
            end % if matMin(ind(i),2,i)== matMin(ind(j),2,j) 
 
        end % if 
    end % for (i+1):matMin
end % for 1:matMin


counter=[];
rip=0;
for k=1:size(matMin,3) 
    counter=[counter; matMin(ind(k),2,k)];
end
for m=1:size(counter)
    for n=(m+1):size(counter)
        if counter(m)==counter(n)
            rip=rip+1;
            break
        end % if
    end % for n
end % for m

end % while rip

 
 counter=[];
rip=0;
for k=1:size(matMin,3) 
    fprintf('%g --> %g (dist = %g)\n', k, matMin(ind(k),2,k), matMin(ind(k),1,k));
    counter=[counter; matMin(ind(k),2,k)];
end
for m=1:size(counter)
    for n=(m+1):size(counter)
        if counter(m)==counter(n)
            rip=rip+1;
        end % if
    end % for n
end % for m

saveascii(counter)