function d=DiagProd(a,b)

%   DiagProd
%
%   diagonal of the product without creating all 
%   the product matrix. Very fast and memory saving.
%   Use:instead of diag(A*B) use diagprod(A,B)


%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      



%rgpm 2-1-1977

[fa,ca]=size(a);
[fb,cb]=size(b);

if ca~=fb,
  disp(' Input data error in DiagProd ');
  error(' Inner dimensions must agree ');
end;
if fa~=cb,
  disp(' Input data error in DiagProd ');
  error(' Outer dimensions must agree ');
end;
d=zeros(fa,1);
for i=1:fa,
  d(i)=a(i,:)*b(:,i);
end;
