function[Header,File,Path,FilePath]=DispEGISHeader(FilePath,Header,filterSpec)

%	DispEGISHeader.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.          

if nargin<3; filterSpec='*'; end;
if nargin<2; Header=[]; end;
if nargin<1; FilePath=[]; end;
if ~isempty(Header); File=[]; Path=[];FilePath=[]; return; end;

[File,Path,FilePath]=ReadFilePath(FilePath,filterSpec,['Get file:']);

global Header
global BytOrd
global HdrVer
global LHeader
global LData
global ExptNam
global RunDate
global RunTime
global SubjID
global Handed
global Sex
global Age
global ExperID
global EdVer
global CalFlag
global NCells
global NChan
global LText
global LComment
global LPad
global BrdGain
global CellID
global LCellHdr
global ChanZero
global ChanGain
global CellID
global CellName
global NTrials
global NPoints
global SampRate
global LSpec

fprintf('\n')
clc;
fprintf('Start reading data file...\n\n');
PrintFilePath(FilePath); 
fprintf('\n\n');

fid=fopen(FilePath,'r');
BytOrd(1:4)=fread(fid,4,'uint8')
HdrVer=fread(fid,1,'int16')
LHeader=fread(fid,1,'int16')
LData=fread(fid,1,'int32')
[ExptNam]=fread(fid,80,'char');
fprintf('ExptNam:');
disp(ExptNam')
RunDate=fread(fid,3,'int16')
RunTime=fread(fid,3,'int16')

SubjID=fread(fid,1,'int16')
Handed=fread(fid,1,'int16')
Sex=fread(fid,1,'int16')
Age=fread(fid,1,'int16')
ExperID=fread(fid,1,'int16')
EdVer=fread(fid,1,'int16')
CalFlag=fread(fid,1,'int16')
NCells=fread(fid,1,'int16')
NChan=fread(fid,1,'int16')
LComment=fread(fid,1,'int16')
LText=fread(fid,1,'int16')
LPad=fread(fid,1,'int16')
BrdGain=fread(fid,1,'int16')
for i=1:NCells
	LCellHdr(i)=fread(fid,1,'int16');
end
[ChanZero]=fread(fid,NChan,'int16');
ChanZero=ChanZero'
[ChanGain]=fread(fid,NChan,'int16');
ChanGain=ChanGain'
pause
Tell1=ftell(fid);
CellName=zeros(80,NCells);
index=0;
Offset=0;
for i=1:NCells
	NCell=i;
	if i>1
		Offset=Tell1+sum(LCellHdr(1:i-1));
		status=fseek(fid,Offset,'bof');
	end
	%status=fseek(fid,2,'cof');
	CellID(i)=fread(fid,1,'int16');
	[CellName(:,i)]=fread(fid,80,'char');	
	NTrials(i)=fread(fid,1,'int16');
	NPoints(i)=fread(fid,1,'int16');
	SampRate(i)=fread(fid,1,'int16');
	LSpec(i)=fread(fid,1,'int16');
	%LSpec(i)=4
	eval(['global LSpecCell' int2str(i)])
	
	eval(['LSpecCell' int2str(i) '= zeros(NTrials(i),LSpec(i)./2);'])
	for j=1:NTrials(i)
		tmp_vec=fread(fid,LSpec(i)./2,'int16')';
		eval(['LSpecCell' int2str(i) '(' int2str(j) ',:) = tmp_vec;']);
	end
	eval(['LSpecCell' int2str(i) ';'])
end
CellID=CellID
fprintf('CellName:\n\n');
disp(CellName')
NTrials=NTrials
NPoints=NPoints
SampRate=SampRate
LSpec=LSpec

CalcLengthData=NChan*sum(NTrials.*NPoints).*2;
NoPointsInCell=NPoints.*NTrials.*NChan;
NoPointsInAllCells=sum(NoPointsInCell);
NoPointsInFile=NoPointsInAllCells+LHeader;
tell1=ftell(fid)
fseek(fid,0,-1);
Header=fread(fid,LHeader,'int8');
fprintf('End reading data file...\n');

fclose(fid);
return;
