function [RefFileMat]=Eps2Sfp(EpsFileMat)

%   Eps2Sfp

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<1; EpsFileMat=[]; end

%==================================================================
DefFileMask='*.eps';
[DefFilePath] = SetDefPath(1,DefFileMask);
[NFiles,EpsFileMat,NonUse,BatchFilePath]=ReadFileNames(EpsFileMat,DefFilePath,'Choose .eps files:');
[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
SetDefPath(2,BatchPath);
RefFileMat=[];
for FileIndex=1:NFiles
	BadEpsFormatStatus=0;
	[EpsFile,EpsPath,EpsFilePath]=GetFileNameOfMat(EpsFileMat,FileIndex);
    SfpFilePath=[EpsFilePath(1:length(EpsFilePath)-3),'sfp'];
    if FileIndex==1
        RefFileMat=char(SfpFilePath);
    else
        RefFileMat=char(RefFileMat,SfpFilePath);
    end
    EpsFid=fopen(EpsFilePath,'r');
    SfpFid=fopen(SfpFilePath,'w');
    LineInd=0;
    while 1
        LineInd=LineInd+1;
        tline=fgetl(EpsFid);
        if ~ischar(tline); break; end
        disp(tline);
        StrInd=0;
        Remainder=tline;
        while 1
            StrInd=StrInd+1;
            [Chopped,Remainder]=strtok(Remainder);
            if ~ischar(Remainder); fprintf(SfpFid,'\n'); break; end
            if StrInd<4
                fprintf(SfpFid,['%s '],Chopped);
            end
            if StrInd>3
                if strcmp(Chopped,'T9')
                    fprintf(SfpFid,'FidLPA');
                elseif strcmp(Chopped,'T10')
                    fprintf(SfpFid,'FidRPA');
                elseif strcmp(Chopped,'Nz')
                    fprintf(SfpFid,'FidNas');
                end
            end
        end
    end
	fclose(EpsFid);
    fclose(SfpFid);
end
