function[]=ExistCalcCoeff(l_iter,m_iter,p_iter,m_spherical,LengthLegVec,LegPath,ParaVec);
%   ExistCalcCoeff.m
%
%   ExistCalcCoeff is called when legendre coefficients are needed for 
%   spherical spline interpolation or source localization purposes.
%   If the coefficient files cannot be found, they are created.
%
%   See also CALCCOSPHIMAT, READORCALCCOEFF, READORCALCPCOEFF.


%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer, Peter Peyk, Andreas Keil, Olaf Hauk,
%   Thomas Gruber & Andrea de Cesarei.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

XVec=linspace(-1,1,LengthLegVec);
LegVec=zeros(LengthLegVec,1);
LegMat=zeros(LengthLegVec,l_iter);
i=0;
ReadWriteStatus=-1; %-1 Not; 0 Calculate and write; +1 Read 
while i<l_iter
	i=i+1;
	LegFile = [LegPath, filesep, 'Leg_',num2str(i),'_',num2str(m_iter),'_',num2str(LengthLegVec)];
	if ReadWriteStatus==-1
   		LegFileFid=fopen(LegFile,'r','b');
		if LegFileFid<0 
			ReadWriteStatus=0; 	%Calculate and write
		else
			ReadWriteStatus=1;		%Read
		end
	end
	if ReadWriteStatus==0
		Message=char(['Calculate legendre coefficients']);
		Message=char(Message,'and save them to file:');			
		Message=char(Message,LegFile);		
		hmsgbox=msgbox(Message,'Info:','help');
		hChildMsgbox=get(hmsgbox,'Children');
		set(hChildMsgbox(3),'Visible','off');
		pause(.01);
		fprintf('\n');
		clc;
		fprintf('Start calculation of:\n')	
     		PrintFilePath(LegFile)     
      		for j=1:LengthLegVec
			[LegVec(j)] = calc_legendre(i, m_iter, XVec(j));
		end
		LegMat(:,i)=LegVec;
		LegFileFid=fopen(LegFile,'w','b');
		fwrite(LegFileFid,LegVec,'float64');
		ReadWriteStatus=-1;
		close(hmsgbox);
	elseif ReadWriteStatus==1
		[LegVec,count] = fread(LegFileFid,inf,'float64');
		if size(LegVec)==[LengthLegVec,1]
			LegMat(:,i)=LegVec;	
			ReadWriteStatus=-1;
		else
			i=i-1;
			ReadWriteStatus=0;
		end
	end
	fclose(LegFileFid);
end

%=================================================================

LegVec=zeros(size(XVec));

ScalpLegFile = [LegPath,filesep,'ScalpLeg_',num2str(l_iter),'_',num2str(m_iter),'_',num2str(LengthLegVec)];
Fid=fopen(ScalpLegFile,'r','b');
if Fid<0	
	fprintf('\n');
	clc;
   fprintf('Start calculation of:\n')	
   PrintFilePath(ScalpLegFile)
   Fid=fopen(ScalpLegFile,'w','b');
	for i=1:l_iter
		[Gamma] = CalcScalpGamma(i,ParaVec);
		LegVec=LegVec+Gamma.*LegMat(:,i)';
	end
	fwrite(Fid,LegVec,'float64');
	fclose(Fid);
end

%=================================================================

LegVec=zeros(size(XVec));

CsdScalpLegFile = [LegPath,filesep,'CsdScalpLeg_',num2str(l_iter),'_',num2str(m_iter),'_',num2str(LengthLegVec)];
Fid=fopen(CsdScalpLegFile,'r','b');
if Fid<0	
	fprintf('\n');
	clc;
	fprintf('Start calculation of:\n')	
	PrintFilePath(CsdScalpLegFile)
	Fid=fopen(CsdScalpLegFile,'w','b');
	for i=1:l_iter
		[CsdGamma] = CalcCsdScalpGamma(i,ParaVec);
		LegVec=LegVec+CsdGamma.*LegMat(:,i)';
	end
	fwrite(Fid,LegVec,'float64');
	fclose(Fid);
end


%=================================================================

LegVec=zeros(size(XVec));

CortLegFile = [LegPath,filesep,'CortLeg_',num2str(l_iter),'_',num2str(m_iter),'_',num2str(LengthLegVec)];
Fid=fopen(CortLegFile,'r','b');
if Fid<0	
	fprintf('\n');
	clc;
	fprintf('Start calculation of:\n')	
	PrintFilePath(CortLegFile)
	Fid=fopen(CortLegFile,'w','b');
	for i=1:l_iter
		[CortGamma] = CalcCortGamma(i,ParaVec);
		LegVec=LegVec+CortGamma.*LegMat(:,i)';
	end
	fwrite(Fid,LegVec,'float64');
	fclose(Fid);
end


%=================================================================

LegVec=zeros(size(XVec));

CsdCortLegFile = [LegPath,filesep,'CsdCortLeg_',num2str(l_iter),'_',num2str(m_iter),'_',num2str(LengthLegVec)];
Fid=fopen(CsdCortLegFile,'r','b');
if Fid<0	
	fprintf('\n');
	clc;
	fprintf('Start calculation of:\n')	
	PrintFilePath(CsdCortLegFile)
	Fid=fopen(CsdCortLegFile,'w','b');
	for i=1:l_iter
		[CsdCortGamma] = CalcCsdCortGamma(i,ParaVec);
		LegVec=LegVec+CsdCortGamma.*LegMat(:,i)';
	end
	fwrite(Fid,LegVec,'float64');
	fclose(Fid);
end

%=================================================================


LegVec=zeros(size(XVec));

PLegFile = [LegPath,filesep,'PLeg_',num2str(p_iter),'_',num2str(m_spherical),'_',num2str(LengthLegVec)];
Fid=fopen(PLegFile,'r','b');
if Fid<0	
	fprintf('\n');
	clc;
	fprintf('Start calculation of:\n')	
	PrintFilePath(PLegFile)
	Fid=fopen(PLegFile,'w','b');
	for i=1:p_iter
		[PGamma] = CalcPGamma(i,m_spherical);
		LegVec=LegVec+PGamma.*LegMat(:,i)';
	end
	fwrite(Fid,LegVec,'float64');
	fclose(Fid);
end

%=================================================================


LegVec=zeros(size(XVec));

CsdPLegFile = [LegPath,filesep,'CsdPLeg_',num2str(p_iter),'_',num2str(m_spherical),'_',num2str(LengthLegVec)];
Fid=fopen(CsdPLegFile,'r','b');
if Fid<0	
	fprintf('\n');
	clc;
	fprintf('Start calculation of:\n')	
	PrintFilePath(CsdPLegFile)
	Fid=fopen(CsdPLegFile,'w','b');
	for i=1:p_iter
		[CsdPGamma] = CalcCsdPGamma(i,m_spherical);
		LegVec=LegVec+CsdPGamma.*LegMat(:,i)';
	end
	fwrite(Fid,LegVec,'float64');
	fclose(Fid);
end

%=================================================================

return;
