function[FileMatOut,MatlabVersionString]=FileNameExt2Mat(FileMatIn,PutExt,NGetExt);

%   FileNameExt2Mat

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<3; NGetExt=0; end
if nargin<2; return; end
[NFiles,LFileMatIn]=size(FileMatIn);
[NoUse,LExt]=size(PutExt);
MatlabVersionString=version;
MainMatlabVersion=str2num(MatlabVersionString(1));

if MainMatlabVersion<5
	LFileMatOut=LFileMatIn-NGetExt+LExt;
	FileMatOut=zeros(NFiles,LFileMatOut);
	if LFileMatOut>=LFileMatIn
		FileMatOut(:,1:LFileMatIn)=FileMatIn;
	else
		FileMatOut=FileMatIn(:,1:LFileMatOut);
	end
	for i=1:NFiles
		LFileIn=FileMatIn(i,1);
		LFileOut=LFileIn-NGetExt+LExt;
		FileMatOut(i,1)=LFileOut;
		FileMatOut(i,LFileOut-LExt+2:LFileOut+1)=PutExt;
	end
	fprintf('\n\n')
	fprintf('File name matrix with new extension:\n\n')
	for i=1:NFiles
		disp(FileMatOut(i,2:FileMatOut(i,1)+1));
	end
else
	for FileIndex=1:NFiles
		FilePath=deblank(FileMatIn(FileIndex,:));
		LFilePath=length(FilePath);
		if FileIndex==1;
			FileMatOut=[FileMatIn(1,1:LFilePath-NGetExt),PutExt];
		else
			FileMatOut=char(FileMatOut,[FileMatIn(FileIndex,1:LFilePath-NGetExt),PutExt]);
		end
	end
end
return;
