function [FiltFileMat]=FiltNeuroscanFiles(FileMat,LowFiltStatus,LowFrequ,LowN, ...
                       HighFiltStatus,HighFrequ,HighN,StopFiltStatus,StopFrequ,StopN,OldStatus,SkipStepStatus)
%   FiltNeuroscanFiles - Filtering of cnt neuroscan data if all data fits
%   in memory.  Use FiltTransNeuroscanFiles for big data sets if all data of one sensor
%   fits in memory.
%
%   See also NEUROSCAN2EGIS.


%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.       



if nargin<12; SkipStepStatus = 0;end
if nargin<11; OldStatus = 0;end
if nargin<10; StopN=6; end
if nargin<9; StopFrequ=[49 51]; end %[LineFrequ-1 LineFrequ+1];
if nargin<8; StopFiltStatus=1; end
if nargin<7; HighN=6; end
if nargin<6; HighFrequ=2; end
if nargin<5; HighFiltStatus=1; end
if nargin<4; LowN=6; end
if nargin<3; LowFrequ=40; end
if nargin<2; LowFiltStatus=1; end
if nargin<1; FileMat=[]; end

[NFiles,FileMat]=ReadFileNames(FileMat,'*.cnt','Choose Neuroscan *.cnt file(s):');
if NFiles==0; return; end
FiltFileMat=FileNameExt2Mat(FileMat,'f.cnt',3);
for FileIndex=1:NFiles
    
    [FiltFile,FiltPath,FiltFilePath]=GetFileNameOfMat(FiltFileMat,FileIndex);
    [OrigFile,OrigPath,OrigFilePath]=GetFileNameOfMat(FileMat,FileIndex);
    
    if OldStatus
        NsStruct=ReadNeuroscanStructPOld(OrigFilePath);
    else
        NsStruct=ReadNeuroscanStruct(OrigFilePath);
    end
    
    NsHeader=NsStruct.header;
    NsEvents=NsStruct.events;
    
    SampRate=NsHeader.rate;
    NChan=NsHeader.nchannels;
    NPoints=NsHeader.numsamples;
    DataStart=NsEvents(1).offset;
    
    if exist(FiltFilePath) & SkipStepStatus
        fprintf(1,'Filtered file already exists: filtering skipped!\n');
        continue;
    end
    fprintf(1,'%c','Copying file:');
    fprintf(1,'\n');
    fprintf(1,'%c',['Orig file: ',OrigFilePath]);
    fprintf(1,'\n');
    fprintf(1,'%c',['Copy file: ',FiltFilePath]);
    fprintf(1,'\n');
    
    [CopyStatus,CopyMsg]=copyfile(OrigFilePath,FiltFilePath,'writable');
    if ~CopyStatus
        hmsgbox=msgbox(CopyMsg,'Info:','help');
    end
    pause(.1)
    OrigFid=fopen(OrigFilePath,'r','l');
    OrigFidSeekStatus=fseek(OrigFid,DataStart,'bof');
    if OrigFidSeekStatus==-1; warning('OrigFid fseek error'); pause; end
    FiltFid=fopen(FiltFilePath,'r+','l');
    FiltFidSeekStatus=fseek(FiltFid,DataStart,'bof');
    if FiltFidSeekStatus==-1; warning('FiltFid fseek error'); pause; end
    
    Nyquist=SampRate./2;
    
    if HighFiltStatus
        [BHigh,AHigh]=butter(HighN,HighFrequ./Nyquist,'high');
    end
    if LowFiltStatus
        [BLow,ALow]=butter(LowN,LowFrequ./Nyquist,'low');
    end
    if StopFiltStatus
        [BLow,ALow]=butter(StopN,StopFrequ./Nyquist,'stop');
    end
    DataMat=zeros(NChan,NPoints);
    for i=1:NPoints
        DataMat(:,i)=fread(OrigFid,NChan,'int16');
    end
    for i=1:NChan
        if HighFiltStatus
            if mod(i,10)==0
                fprintf(1,'filtering highpass ... Frequ: %g Hz; Order: %g; Sensor: %g\n',HighFrequ,HighN,i)
            end
            DataMat(i,:)=filtfilt(BHigh,AHigh,DataMat(i,:));
        end
        if LowFiltStatus
            if mod(i,10)==0
                fprintf(1,'filtering lowpass ... Frequ: %g Hz; Order: %g; Sensor: %g\n',LowFrequ,LowN,i)
            end
            DataMat(i,:)=filtfilt(BLow,ALow,DataMat(i,:));
        end
        if StopFiltStatus
            if mod(i,10)==0
                fprintf(1,'filtering stopband ... Frequ: %g Hz; Order: %g; Sensor: %g\n',StopFrequ,StopN,i)
            end
            DataMat(i,:)=filtfilt(BStop,AStop,DataMat(i,:));
        end
    end
    for i=1:NPoints
        Count=fwrite(FiltFid,DataMat(:,i),'int16');
        if Count~=NChan; warning('Count~=NChan'); pause; end
    end
    fclose(OrigFid);
    fclose(FiltFid);
end
return;
