%	GenSoundEditFile.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION. 
[TimePoints]=IfEmptyInputVal(['Time points:'],[],[],22256);
[Duration]=IfEmptyInputVal(['Duration:'],[],[],0.05);
[Frequ]=IfEmptyInputVal(['Frequency:'],[],[],100);

Data=sin(linspace(0,Frequ.*2.*pi,floor(TimePoints.*Duration)));
[Data] = CalcFrequWin(Data,1);
Data=round(Data.*32766);
plot(Data);

[ch_SaveData]=IfEmptyInputBo(['Do you want to save the data ?'],[],[],1);

if ch_SaveData
	
	[File,Path]=uiputfile('Untitled','Save data to file:');
	FilePath=[Path,File];

	fid=fopen(FilePath,'w','b');
	
	fprintf('Start writing data file...\n');
	fprintf(FilePath); fprintf('\n');

	% save data to ASCII file
	count=fprintf(fid,'%g\t',Data)
	
	fprintf('End writing data file...\n\n');	
	fclose(fid);	
	
end %ch_save_data
return;
