function EcfgFile = GetDefEcfgFile(NChan)

%   GetDefEcfgFile

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

[nouse1,Plot2dFolder]=SepFilePath(which('emegs2d.m'));
EcfgDefaultFilePath = [Plot2dFolder,'emegs2dUtil',filesep,'ViewDefault',filesep,'DefaultEcfg.txt'];
fid = fopen(EcfgDefaultFilePath,'r','b');
if fid==-1
    answer = questdlg('Could not open ''DefaultEcfg.txt''! Choose create to create a default version.','Warning','Create','Cancel','Create');
    if strcmp(answer,'Create')
        fid = fopen(EcfgDefaultFilePath,'wt');
        fprintf(fid,'%s','% This file lists the electrode configuration files in');
        fprintf(fid,'\n');
        fprintf(fid,'%s','% the order you want them to be searched.');
        fprintf(fid,'\n');
        fprintf(fid,'%s','% You can edit this file to use a different configuration without');
        fprintf(fid,'\n');
        fprintf(fid,'%s','% renaming the configuration files.');
        fprintf(fid,'\n');
        fprintf(fid,'64.ecfg\n');
        fprintf(fid,'65.ecfg\n');
        fprintf(fid,'128.ecfg\n');
        fprintf(fid,'129.ecfg\n');
        fprintf(fid,'256.ecfg\n');
        fprintf(fid,'257.ecfg\n');
        fprintf(fid,'148.ecfg\n');
        fprintf(fid,'642.ecfg\n');
        fprintf(fid,'1026.ecfg\n');
        fprintf(fid,'350.ecfg\n');
        fprintf(fid,'14.ecfg\n');
        fprintf(fid,'21.ecfg\n');
        fprintf(fid,'31.ecfg\n');
        fprintf(fid,'33.ecfg\n');
        fprintf(fid,'41.ecfg\n');
        fprintf(fid,'58.ecfg\n');
        fprintf(fid,'63.ecfg\n');
        fprintf(fid,'62.ecfg\n');
        fprintf(fid,'162.ecfg\n');
        fprintf(fid,'197.ecfg\n');
        fclose(fid);
    else
        EcfgFile = [];
        return
    end
end
%take first path with NChan in name
fid=fopen(EcfgDefaultFilePath,'r','b');
EcfgFileMat=[];
LineInd=0;
while 1
	line = fgetl(fid);
	if ~isstr(line), break, end
	%disp(line)
	if isempty(findstr(line,'%'))
		LineInd=LineInd+1;
		EcfgFileMat=char(EcfgFileMat,line);
	end
end
fclose(fid);
%EcfgFileMat = textread(EcfgDefaultFilePath,'%s'); %No headerlines
for r=2:LineInd+1
    if ~isempty(findstr(EcfgFileMat(r,:),num2str(NChan)));
        EcfgFile=deblank(EcfgFileMat(r,:));
        return
    end
end
%else 
msg = 'Could not find any appropriate default electrode configuration file in';
msg = char(msg,'');
msg = char(msg,EcfgDefaultFilePath);
msg = char(msg,'');
msg = char(msg,'Please adjust this default file for your purposes ...');
uiwait(helpdlg(msg,'Info:'));
EcfgFile = [];

return
