function[FileSizeVec]=GetFileSize(FileMat);

%   GetFileSize

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.      

if nargin<1; FileMat=[]; end
[NFiles,FileMat]=ReadFileNames(FileMat,'*','Choose files:');
if NFiles==0; return; end
for FileIndex=1:NFiles
	[NoUse,NoUse,FilePath]=GetFileNameOfMat(FileMat,FileIndex);
	fid=fopen(FilePath);
	fseek(fid,0,1);
	FileSizeVec(FileIndex)=ftell(fid);
	fclose(fid);
end
return;
