%   GrandAvgEgis.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.        

[NFiles,FileMat]=ReadFileNames([],'*.at*','Choose all files to average (grand mean):')
if NFiles<2; error('Minimum number of files is 2 !!!'); end
[File,Path,FilePath]=GetFileNameOfMat(FileMat,1);
[AvgMat,File,Path,FilePath,NTrialAvgVec,StdChanTimeMat,...
SampRate,AvgRef,Version,MedMedRawVec,MedMedAvgVec]=ReadAvgFile(FilePath);
GMAvgMat=AvgMat;
GMNTrialAvgVec=NTrialAvgVec;
GMStdChanTimeMat=StdChanTimeMat;
GMMedMedRawVec=MedMedRawVec;
GMMedMedAvgVec=MedMedAvgVec;

for FileIndex=2:NFiles
	[File,Path,FilePath]=GetFileNameOfMat(FileMat,FileIndex);
	[AvgMat,File,Path,FilePath,NTrialAvgVec,StdChanTimeMat,...
	SampRate,AvgRef,Version,MedMedRawVec,MedMedAvgVec]=ReadAvgFile(FilePath);
	GMAvgMat=GMAvgMat+AvgMat;
	GMNTrialAvgVec=NTrialAvgVec;
	GMStdChanTimeMat=GMStdChanTimeMat+StdChanTimeMat;
	GMMedMedRawVec=GMMedMedRawVec+MedMedRawVec;
	GMMedMedAvgVec=GMMedMedAvgVec+MedMedAvgVec;
end

GMAvgMat=GMAvgMat./NFiles;
GMNTrialAvgVec=GMNTrialAvgVec./NFiles;
GMStdChanTimeMat=GMStdChanTimeMat./NFiles;
GMMedMedRawVec=GMMedMedRawVec./NFiles;
GMMedMedAvgVec=GMMedMedAvgVec./NFiles;

FilePath=[FilePath '.gm'];
SaveAvgFile(FilePath,GMAvgMat, GMNTrialAvgVec, GMStdChanTimeMat,SampRate,GMMedMedRawVec,GMMedMedAvgVec);

return;

return;
