function[StringOut]=IfEmptyInputString(string1,string2,In,Default,ClearStatus);

%    IfEmptyInputString

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
if nargin<5; ClearStatus=0; end
if nargin<4; Default=[]; end
if nargin<3; In=[]; end
if nargin<2; string2=[]; end
if nargin<1; string1=[]; end

if ClearStatus; fprintf('\n');clc; end;
if isempty(In)
	if ~isempty(string1); fprintf(string1); fprintf('\n'); end
	if ~isempty(string2); fprintf(string2); fprintf('\n'); end
	if ~isempty(Default)
		fprintf('(The default is [');fprintf(Default);fprintf('] !)');	
	end 
	StringOut=input(' ','s');
	if isempty(StringOut)
		StringOut=Default;
	end
	clc;
	return;
else
	StringOut=In;
	clc;
	return;
end
