function LaunchExistCalcCoeff(NChan,NPoints)

%   LaunchExistCalcCoeff

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

    %DEFINE RADII OF SHELLS 
    CortRadius = 0.0815; 		%radius of shell 1 (brain or cort)
    CsfRadius=0.0836;			%radius of shell 2 (cerebro-spinal fluid)
    SkullRadius=0.0878; 		%radius of shell 3 (skull)
    ScalpRadius=0.092; 			%radius of shell 4 (scalp)
    % DEFINE CONDUCTIVITY VARIABLES (ohms * meters)
    ocort=1/3;  				%sigma1 of shell 1 (brain or cort)   = 0.333
    ocsf=3 * ocort;   			%sigma2 of shell 2 (cerebro-spinal fluid)  =1.0
    oskull= ocort / 80;   		%sigma3 of shell 3 (skull) = 1/240 = 0.0042
    oscalp = ocort; 			% sigma4 of shell 4 (scalp) = 0.333
    NSqrtScalpLoc=32;
    DipoleRadius=0.04;
    LengthLegVec=5001;
    InvIter=18;
    ForIter=18;
    PIter=18;
    MSpherical=1;
    ParaVec =[CortRadius ocort CsfRadius ocsf SkullRadius, ...
            oskull ScalpRadius oscalp DipoleRadius InvIter, ...
            ForIter PIter MSpherical NSqrtScalpLoc LengthLegVec ...
        NChan NChan NPoints NPoints 0 0];
    [nouse1,BasePath]=SepFilePath(which('emegs2d.m'));  
    PathLeg=[BasePath 'emegs3dLegCoeff'];
    
    ExistCalcCoeff(InvIter,0,PIter,MSpherical,LengthLegVec,PathLeg,ParaVec);
        InvIter=15;
        ForIter=15;
        PIter=15;
        MSpherical=2;
    ExistCalcCoeff(InvIter,0,PIter,MSpherical,LengthLegVec,PathLeg,ParaVec);
        InvIter=12;
        ForIter=12;
        PIter=12;
        MSpherical=3;
    ExistCalcCoeff(InvIter,0,PIter,MSpherical,LengthLegVec,PathLeg,ParaVec);
        InvIter=9;
        ForIter=9;
        PIter=9;
        MSpherical=4;
    ExistCalcCoeff(InvIter,0,PIter,MSpherical,LengthLegVec,PathLeg,ParaVec);
return