function[OutFilePath]=MergeSesFiles(InFileMat,OutFilePath)

%	MergeSesFiles.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.   

if nargin<2; OutFilePath=[]; end;
if nargin<1; InFileMat=[]; end;

%==================================================================
DefFilePath=SetDefPath(1,'*.ses*');
[NFiles,InFileMat,NonUse,BatchFilePath]=ReadFileNames(InFileMat,DefFilePath,'Choose *.ses* files:');
if NFiles<2; return; end
[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
if ~strcmp(BatchPath(end),filesep); BatchPath=[BatchPath,filesep]; end
if isempty(OutFilePath)
	[OutFile,OutPath,OutFilePath]=WriteFilePath([BatchPath,'Merge.ses']);
end
pause(.1)
OutFid=fopen(OutFilePath,'w','b');
fprintf('\n\n')
NTotTrials=0;
for FileIndex=1:NFiles
    fprintf(1,'Merge file %g of %g total files ...\n\n',FileIndex,NFiles)
    [SesFile,SesPath,SesFilePath]=GetFileNameOfMat(InFileMat,FileIndex);
    SetFilePath=[SesFilePath,'.set'];
    [SetFilePath,ParaVec,MEGSensorPosMat,EEGSensorPosMat,MEGSensorNameVec,...
     EEGSensorNameVec,MEGSensorIndexVec,EEGSensorIndexVec,MsiFormat,MSIChannelOrderVec,...
     MsiPatient,MsiScan,MsiSession,MsiRun,ExternSensorNameVec,ExternSensorIndexVec]=ReadMsiSet(SetFilePath);
    NTotChan=ParaVec(1);
    NMsiPoints=ParaVec(2);
    NTrials=ParaVec(3);
    NMegChan=ParaVec(4);
    NEegChan=ParaVec(5);
    SampRate=ParaVec(6);
    SampPeriod=ParaVec(7);
    BaseMs=ParaVec(8);
    Duration=ParaVec(9);
    NBit=ParaVec(10)
    NExternChan=ParaVec(11);
    NMEegChan=NMegChan+NEegChan;
    MEegSensorIndexVec=zeros(NMEegChan,1);
    MEegSensorIndexVec(1:NMegChan)=MEGSensorIndexVec;
    MEegSensorIndexVec(NMegChan+1:NMEegChan)=EEGSensorIndexVec;
    NTotTrials=NTotTrials+NTrials;
    
    InFid=fopen(SesFilePath,'r','b');
    for TrialInd=1:NTrials	
        if round(TrialInd./10)==TrialInd./10	
            fprintf(1,'%g\n',TrialInd)
        else
            fprintf(1,'.')
        end
        DataMat=fread(InFid,[NTotChan,NMsiPoints],MsiFormat);
        fwrite(OutFid,DataMat,MsiFormat); 
    end
    fclose(InFid);
end
fclose(OutFid);
[SesFile,SesPath,SesFilePath]=GetFileNameOfMat(InFileMat,1);
InSetFilePath=[SesFilePath,'.set']
OutSetFilePath=[OutFilePath,'.set']
KeyWordMat='MSI.TotalEpochs:';
KeyWordFormat='d';
ChangeMsiSet(InSetFilePath,OutSetFilePath,KeyWordMat,KeyWordFormat,NTotTrials);
return;
