function PCAasPlot2d(action);

%	PCAMusic

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Andreas Keil, Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.    

global hPlot2dMenuFig
hList=get(hPlot2dMenuFig,'Userdata');
Domain=get(hList(20),'Value');
ActFileNo=get(hList(1),'Userdata');
NChanVec=get(hList(16),'Userdata');
NChan=NChanVec(1);
FileNoVec=get(hList(56),'Userdata');
NListHdr=get(hList(51),'Userdata');
MinPoint=get(hList(54),'Value');
MaxPoint=get(hList(55),'Value');
NPoints=MaxPoint-MinPoint+1;
TrigPoint=get(hList(22),'Value');
SampRate = get(hList(60),'Userdata');
MinPointMs = (MinPoint-TrigPoint).*1000./SampRate;	
MaxPointMs = (MaxPoint-TrigPoint).*1000./SampRate;
AllActType=[action(length(action)-8:length(action)-6)];
OrgActType=[action(length(action)-5:length(action)-3)];
DataType=[action(length(action)-2:length(action))];
if strcmp(DataType,'Cov')
	VFigureName='Time Courses of Covariance Matrix PCA';
	SFigureName='Variance Vector of Covariance Matrix PCA';
elseif strcmp(DataType,'Cor')
	VFigureName='Time Courses of Correlation Matrix PCA';
	SFigureName='Variance Vector of Correlation Matrix PCA';
else
	VFigureName='Time Courses of Data Matrix PCA';
	SFigureName='Variance Vector of Data Matrix PCA';
end
if strcmp(AllActType,'Act');
	FileNoVec=FileNoVec(ActFileNo);
end

if isempty(MinPointMs); MinPointMs=1; end
if isempty(MaxPointMs); MaxPointMs=MinPointMs+NPoints-1; end
if strcmp(computer,'MAC2')	
   VFigPosVec=[0.4 0 0.6 1];	
	SFigPosVec=[0.6 0 0.4 0.4];
elseif strcmp(computer,'PCWIN') 
  	VFigPosVec=[0.405 0.05 .60 0.88];  
  	SFigPosVec=[0.61 0.05 0.4 0.4];
elseif strcmp(computer,'SOL2')
	VFigPosVec=[0.41 0.01 .601 0.935];  
  	SFigPosVec=[0.6224 0.01 0.4 0.4];		
end;

UMat=zeros(NChan,NChan,length(FileNoVec));
VMat=zeros(NPoints,NPoints,length(FileNoVec));
MinPointsChan=min(NPoints,NChan);
VarVecMat=zeros(MinPointsChan,length(FileNoVec));
NComp1=0;
for	FileIndex=1:length(FileNoVec)
	if strcmp(OrgActType,'Act'); Tmp=1; else; Tmp=24; end
   	ActTmpMat=get(hList(NListHdr+(FileNoVec(FileIndex)-1).*50+Tmp),'Userdata');
  	[NoUse,NOrigPoints]=size(ActTmpMat);
	ActTmpMat=ActTmpMat(:,MinPoint:MaxPoint);
	if strcmp(DataType,'Cov')
		ActTmpMat = cov(ActTmpMat);
	elseif strcmp(DataType,'Cor')
		ActTmpMat = corrcoef(ActTmpMat);	
	end
	[U,S,V] = svd(ActTmpMat);
	VarVec = (diag(S)).^2/sum(diag(S).^2);
	UMat(:,:,FileIndex)=U;
	VMat(:,:,FileIndex)=V;
    VarVecMat(:,FileIndex)=VarVec;
	NComp1=max(NComp1,length(find(VarVec>=.01)));
	MinVVec(FileIndex)=min(min(V(:,1:1:NComp1)));
   	MaxVVec(FileIndex)=max(max(V(:,1:1:NComp1)));
end
set(hList(113),'Userdata',VarVecMat);
[SigValVec] = FindRCrit(MinPointsChan);
set(hList(114),'Userdata',SigValVec);
NComp1=NComp1+1;
if NComp1==1
	NRow1=1; NCol1=1;
elseif NComp1==2
	NRow1=1; NCol1=2;
elseif NComp1==3
	NRow1=1; NCol1=3;
elseif NComp1==5 | NComp1==6
	NRow1=2; NCol1=3;
else
	NRow1=ceil(sqrt(NComp1));
	NCol1=NRow1;
end
hPCAVFig=figure('Units','normal','Position',VFigPosVec, ...
        	'Name',VFigureName,'Color',[1 1 1],'NumberTitle','off','Visible','on');

TimeVec=linspace(MinPointMs,MaxPointMs,NPoints);
for Comp = 1 : NComp1
	hPCAVhAxesVec(Comp)=subplot(NRow1,NCol1,Comp);
end

hPCASFig=figure('Units','normal','Position',SFigPosVec, ...
        	'Name',SFigureName,'Color',[1 1 1],'NumberTitle','off','Visible','on');
if NPoints>NComp1
	hPCAShAxesVec(1)=subplot(1,2,1);
	hPCAShAxesVec(2)=subplot(1,2,2);
else
	hPCAShAxesVec=axes;
end

for	FileIndex=1:length(FileNoVec)
  	LineStyleStr=get(hList(NListHdr+(FileNoVec(FileIndex)-1).*50+17),'Userdata');
	ColorVal=get(hList(NListHdr+(FileNoVec(FileIndex)-1).*50+16),'Value');
	if 	ColorVal==1; 		ColorStr='k'; 	
	elseif 	ColorVal==2; 	ColorStr='w'; 	
   	elseif 	ColorVal==3;	ColorStr='y'; 	
   	elseif 	ColorVal==4; 	ColorStr='r'; 	
	elseif 	ColorVal==5; 	ColorStr='g'; 	
	elseif 	ColorVal==6; 	ColorStr='b'; 	
	elseif 	ColorVal==7; 	ColorStr='m'; 	
	elseif 	ColorVal==8; 	ColorStr='c'; 	
	else;					ColorStr='b'; 	
	end
   ColorLineStyleStr=[ColorStr,LineStyleStr];
  	for Comp = 1 : NComp1
		axes(hPCAVhAxesVec(Comp))
		plot(TimeVec,VMat(:,Comp,FileIndex),ColorLineStyleStr)
		hold on
    	TitleString = (['Component #',num2str(Comp),';']);
		title (TitleString)
    	xlabel('Time [ms]') 
		text('Units','Normal','Position',[.05 .05+(FileIndex-1).*.08],'String',['Var.: ',sprintf('%g',round(VarVecMat(Comp,FileIndex).*1000)./10),' %'],'FontSize',12,'FontWeight','bold','Color',ColorStr);
     	axis([MinPointMs MaxPointMs min(MinVVec) max(MaxVVec)])   
   end
	axes(hPCAShAxesVec(1))
	plot(VarVecMat(:,FileIndex).*100,ColorLineStyleStr)
	hold on
	axis([1 NPoints 0 1.1.*max(VarVecMat(:,FileIndex).*100)])
	xlabel('Component []') 
	ylabel('Variance [%]') 
	if NPoints>NComp1
		axes(hPCAShAxesVec(2))		
		plot(VarVecMat(:,FileIndex).*100,ColorLineStyleStr)
		hold on
		axis([1 NComp1 0 1.1.*max(VarVecMat(:,FileIndex).*100)])
		xlabel('Component #') 
		ylabel('Variance [%]') 
	end

	if strcmp(DataType,'Dat')
		ActTmpMat=zeros(NChan,NOrigPoints);
 		for CompInd=1:MinPointsChan
 			ActTmpMat(:,CompInd)=UMat(:,CompInd,FileIndex).*VarVecMat(CompInd,FileIndex);
 		end
		set(hList(NListHdr+(FileNoVec(FileIndex)-1).*50+1),'Userdata',ActTmpMat);
		MinTmpVec(FileIndex)=min(min(ActTmpMat(:,1:MinPointsChan)))
		MaxTmpVec(FileIndex)=max(max(ActTmpMat(:,1:MinPointsChan)))
	end
end
hold off
if strcmp(DataType,'Dat')
	MinAmp=min(MinTmpVec)
	MaxAmp=max(MaxTmpVec)
	MinAmpVec=get(hList(52),'Userdata');
	MaxAmpVec=get(hList(53),'Userdata');
	MinAmpVec(5)=MinAmp
	MaxAmpVec(5)=MaxAmp
	set(hList(52),'Value',MinAmp,'Userdata',MinAmpVec,'String',sprintf('%g',MinAmp)); %MinAmp
	set(hList(53),'Value',MaxAmp,'Userdata',MaxAmpVec,'String',sprintf('%g',MaxAmp)); %MaxAmp
	if Domain~=5
		set(hList(20),'Value',5);	%Domain=5; PCA
		Plot2d('setPCADomain')
	end
	Plot2d('PlotData')
end

return;
