%   Plot2dPath.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

clc;
ActPath=pwd;
NActPath=length(ActPath);
MatlabVersionString=version;						
MainMatlabVersion=str2num(MatlabVersionString(1));


if MainMatlabVersion>4
	CmpString=ActPath(NActPath-8:NActPath-1);
else
	CmpString=ActPath(NActPath-7:NActPath);
end
if ~strcmp(CmpString,'Plot2d3d')
	fprintf('Please start this file from the "Plot2d3d" directory !\n\n')
	fprintf('To do this, please choose the matlab "File:Open" Menu \n')
	fprintf('and look for the "Plot2d3d" directory. If you got it, press "Cancel".')
	return;
else
	path(path,ActPath);

	ErrorString='If the following step forces this message:\n\nName is nonexistent or not a directory\n\n';
	
	clc; fprintf(ErrorString)
	fprintf('"Plot2dLib" has to be a subfolder of "Plot2d3d" !\n\n\n'); pause(1)
	cd 'Plot2dLib'
	cd ..
	
	clc; fprintf(ErrorString)
	fprintf('"Plot2Util" has to be a subfolder of "Plot2d3d" !\n\n\n\n'); pause(1)
	cd 'Plot2dUtil'
	cd ..
	
	clc; fprintf(ErrorString)
	fprintf('"Plot3dLegCoeff" has to be a subfolder of "Plot2d3d" !\n\n\n\n'); pause(1)
	cd 'Plot3dLegCoeff'
	cd ..

	clc; fprintf(ErrorString)
	fprintf('"Plot3dCoeff40" has to be a subfolder of "Plot2d3d" !\n\n\n\n'); pause(1)
	cd 'Plot3dCoeff40'
	cd ..

	clc; fprintf(ErrorString)
	fprintf('"Plot3dInvCoeff" has to be a subfolder of "Plot2d3d" !\n\n\n\n'); pause(1)
	cd 'Plot3dInvCoeff'
	cd ..
	
	cd 'Plot2dUtil'
	clc; fprintf(ErrorString)
	fprintf('"ElectrodeCfg" has to be a subfolder of "Plot2dUtil" !\n\n\n\n'); pause(1)
	cd 'ElectrodeCfg'
	cd ..
	
	clc; fprintf(ErrorString)
	fprintf('"ViewDefault" has to be a subfolder of "Plot2dUtil" !\n\n\n\n'); pause(1)
	cd 'ViewDefault'
	
	

	Plot2dLibPathStatus=findstr(path,':Plot2dLib');
	Plot2dUtilPathStatus=findstr(path,':Plot2dUtil');
	Plot3dLegCoeffPathStatus=findstr(path,':Plot3dLegCoeff');
	Plot3dCoeff40PathStatus=findstr(path,':Plot3dCoeff40');
	Plot3dInvCoeffPathStatus=findstr(path,':Plot3dInvCoeff');

	if MainMatlabVersion>4
		Plot2LibPath=[ActPath,'Plot2dLib'];
	else
		Plot2LibPath=[ActPath,':Plot2dLib'];
	end
	if isempty(Plot2dLibPathStatus)
		fprintf('Add "Plot2dLib" to Matlab path:\n\n')
		pause(2)
		path(path,Plot2LibPath);
	end
	if MainMatlabVersion>4
		Plot2dUtilPath=[ActPath,'Plot2dUtil'];
	else
		Plot2dUtilPath=[ActPath,':Plot2dUtil'];
	end
	if isempty(Plot2dUtilPathStatus)
		fprintf('Add "Plot2dUtil" to Matlab path:\n\n')
		pause(1)
		path(path,Plot2dUtilPath);
	end
	if MainMatlabVersion>4
		Plot3dLegCoeffPath=[ActPath,'Plot3dLegCoeff'];
	else
		Plot3dLegCoeffPath=[ActPath,':Plot3dLegCoeff'];
	end
	if isempty(Plot3dLegCoeffPathStatus)
		fprintf('Add "Plot3dLegCoeff" to Matlab path:\n\n')
		pause(1)
		path(path,Plot3dLegCoeffPath);
	end
	if MainMatlabVersion>4
		Plot3dCoeff40Path=[ActPath,'Plot3dCoeff40'];
	else
		Plot3dCoeff40Path=[ActPath,':Plot3dCoeff40'];
	end
	if isempty(Plot3dCoeff40PathStatus)
		fprintf('Add "Plot3dLegCoeff" to Matlab path:\n\n')
		pause(1)
		path(path,Plot3dCoeff40Path);
	end
	if MainMatlabVersion>4
		Plot3dInvCoeffPath=[ActPath,'Plot3dInvCoeff'];
	else
		Plot3dInvCoeffPath=[ActPath,':Plot3dInvCoeff'];
	end
	if isempty(Plot3dInvCoeffPathStatus)
		fprintf('Add "Plot3dInvCoeff" to Matlab path:\n\n')
		pause(1)
		path(path,Plot3dInvCoeffPath);
	end
	Plot2LibPathStatus=findstr(path,'Plot2dLib');
	Plot2UtilPathStatus=findstr(path,'Plot2dUtil');
	Plot3dLegCoeffPathStatus=findstr(path,'Plot3dLegCoeff');
	Plot3dCoeff40PathStatus=findstr(path,'Plot3dCoeff40');
	Plot3dInvCoeffPathStatus=findstr(path,'Plot3dInvCoeff');

	if length(Plot2LibPathStatus)>1
		fprintf('This program found more than one folder "Plot2dLib" in the Matlab search path !!\n\n')
	end
	if length(Plot2UtilPathStatus)>1
		fprintf('This program found more than one folder "Plot2dUtil" in the Matlab search path !!\n\n')
	end
	if length(Plot3dLegCoeffPathStatus)>1
		fprintf('This program found more than one folder "Plot3dLegCoeff" in the Matlab search path !!\n\n')
	end
	if length(Plot3dCoeff40PathStatus)>1
		fprintf('This program found more than one folder "Plot3dCoeff40" in the Matlab search path !!\n\n')
	end
	if length(Plot3dInvCoeffPathStatus)>1
		fprintf('This program found more than one folder "Plot3dInvCoeff" in the Matlab search path !!\n\n')
	end
	if length(Plot2LibPathStatus)>1 | length(Plot2UtilPathStatus)>1
		fprintf('Please take care !\n\n')
		fprintf('If files with identical file names are available in the Matlab search path \n')
		fprintf('Matlab uses the one which is the first in the search path !\n\n')	
		fprintf('For reasons of clarity the user should avoid this !!!')
	end
end
fprintf('To save this Matlab search path for later sessions \n')
fprintf('please bring the Matlab Command window to front\n')
fprintf('and choose the "File:SetPath" menu.\n\n')	
if MainMatlabVersion>4
	fprintf('Press "Save" to set this path to default.')
else
	fprintf('Please add the follwing paths to the Matlab search path:\n\n')
	fprintf(ActPath); fprintf('\n');
	fprintf(Plot2LibPath);  fprintf('\n');
	fprintf(Plot2dUtilPath);  fprintf('\n\n\n');
	fprintf('Press "Save" to set this path to default.')
end
	
