function [] = PlotSurfNew(pot,title_num, status)

%	PlotSurfNew.m
%	This function will plot a given potential like a movie

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  

global X_scalp Y_scalp Z_scalp Z_scalp_high Z_scalp_low x_scalp_v n_scalp
global X_cort Y_cort Z_cort Z_cort_high Z_cort_low x_cort_v n_cort
global E_positions_cart E_positions_spher C_positions_cart C_positions_cart 
global E_names para_vec total_electrodes plot_surf_index
global caxis_v total_title_num
global time_vec ref_e_pot
global ch_kind_data
global dist_time_point CH_AVGTIMEINT DistIndex
global samp_rate
global ch_data_domain
global ch_time_ref_e_pot
global frequ_resol

size_pot=size(pot);
if ch_kind_data==2
	time_vec=[1:size_pot(2)];
end
MinIndex=time_vec(1);
MaxIndex=time_vec(length(time_vec));
TFVec=time_vec;
LengthRefEPot=length(ref_e_pot);

if isempty(pot)
	error('The matrix "pot" is empty!')
end
cort_radius=para_vec(1);	 
scalp_radius=para_vec(7);  
clc;

MinMaxInfo(pot,title_num);

[title_string]=title_string_func(title_num,1);


if length(TFVec)==1
	PlotIndexVector=1;
	PlotTimeVector=TFVec;
else
	[ch_PlotAllIndices]=IfEmptyInputBo(['Do you wish to plot or surf all data ?'],[],[],0,1);
	if ch_PlotAllIndices
		PlotIndexVector=[1:length(TFVec)];
		if CH_AVGTIMEINT
			PlotTimeVector=[TFVec(1):TFVec(length(TFVec))+dist_time_point-1];
		else
			PlotTimeVector=[TFVec(1):TFVec(length(TFVec))];
		end		
				
		if ch_data_domain==2
			MinPlotFrequ=floor(min(TFVec)*frequ_resol);
			MaxPlotFrequ=floor(max(TFVec)*frequ_resol);
		end
	else
		%===============================================
		clc;
		if dist_time_point==1
			[ch_PlotRefSignal]=IfEmptyInputBo(['Do you want to have a look at your reference signal'],['to choose a special intervall ?'],ch_PlotRefSignal,1);
			if ch_PlotRefSignal
				if ch_data_domain==1
					PlotSingleTimeVec(ref_e_pot',time_vec,ch_time_ref_e_pot);
				elseif ch_data_domain==2
					PlotSingleFrequVec(ref_e_pot',time_vec,ch_time_ref_e_pot,frequ_resol);
				end
			end
		end
		%===============================================
		fprintf('\n');
		clc;
		fprintf('Which data do you want to plot and/or surf ? \n\n')
		fprintf('(if minimum = maximum of course only one plot will be made)\n\n')   
		if ch_data_domain==1
			if dist_time_point==1
				[MinPlotIndex]=IfEmptyInputValInt(['Please insert minimal point of time to plot:'],[],[],[],min(TFVec),max(TFVec));
				[MaxPlotIndex]=IfEmptyInputValInt(['Please insert maximal point of time to plot:'],[],[],[],min(TFVec),max(TFVec));
				PlotIndexVector=[MinPlotIndex-min(TFVec)+1:MaxPlotIndex-min(TFVec)+1];
				PlotTimeVector=[MinPlotIndex:MaxPlotIndex];
			else
				MinIndex=1;MaxIndex=0;
				while MaxIndex<=MinIndex
					[MinPlotIndex,MinIndex]=IfEmptyInputSpecVal([],TFVec(1:length(TFVec)),[],...
					['Please insert minimum averaged intervall of time to plot:']);
					[MaxPlotIndex,MaxIndex]=IfEmptyInputSpecVal([],TFVec(MinIndex:length(TFVec)),[],...
					['Please insert maximum averaged intervall of time to plot:']);
					if MaxIndex<=MinIndex
						fprintf('Sorry ! MinIndex has to be lower than MaxIndex !!!');
					end
				end
				PlotIndexVector=[MinIndex:MaxIndex];
				if CH_AVGTIMEINT
					PlotTimeVector=[TFVec(MinIndex):TFVec(MaxIndex)+dist_time_point-1];
				else
					PlotTimeVector=[TFVec(MinIndex):TFVec(MaxIndex)];
				end
			end
		elseif ch_data_domain==2
			MinPlotFrequ=floor(min(TFVec)*frequ_resol);
			MaxPlotFrequ=floor(max(TFVec)*frequ_resol);
			[MinPlotFrequ]=IfEmptyInputValInt(['Please insert minimum frequency to plot:'],[],[],MinPlotFrequ,MinPlotFrequ,MaxPlotFrequ);
			MinPlotIndex=floor(MinPlotFrequ/frequ_resol)+1
			[MaxPlotFrequ]=IfEmptyInputValInt(['Please insert maximum frequency to plot:'],[],[],MaxPlotFrequ,MinPlotFrequ,MaxPlotFrequ);
			MaxPlotIndex=floor(MaxPlotFrequ/frequ_resol)+1
		end
	end
end
fprintf('\n');
clc;
fprintf('Do you wish to look at data in\n\n');
fprintf('    3D movie     [1]\n');
fprintf('or  2D course  ? [2]\n\n');
[ch_MovieCourse]=IfEmptyInputVal(['Please insert your choice:'],[],[],1);
if ch_MovieCourse==1
	if ch_kind_data==1
		if ch_data_domain==1
			surf_movie_t_o(pot,TFVec,PlotIndexVector,PlotTimeVector,title_num,status);
		elseif ch_data_domain==2
			surf_movie_f_o(pot,MinPlotIndex,MinPlotFrequ,MaxPlotIndex,MaxPlotFrequ,title_num,status);
		end
	elseif ch_kind_data==2
		surf_movie_t_o(pot,TFVec,PlotIndexVector,PlotTimeVector,title_num,status);
		%surf_movie_s(pot,MinPlotIndex,MaxPlotIndex,title_num,status);
	end
elseif ch_MovieCourse==2
	if ch_kind_data==1
		if ch_data_domain==1
			surf_course_o(pot,TFVec,PlotIndexVector,PlotTimeVector,title_num,status);
		elseif ch_data_domain==2
			fprintf('Kommt noch!!!')
			return;
		end
	elseif ch_kind_data==2
		surf_course_o(pot,TFVec,PlotIndexVector,PlotTimeVector,title_num,status);
		%surf_course_s(pot,v_time,title_num,status);
	end
end

return;
